/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.worker.AbortException;
import org.w3c.dom.Node;

public final class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset SJIS = Charset.forName("MS932");

    private IO() {
    }

    public static final void close(Closeable obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + obj, ex);
        }
    }

    public static final void close(ZipFile obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + obj, ex);
        }
    }

    public static void delete(File file) throws IOException {
        assert (!file.exists() || file.isFile()) : file + " \u306f\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093";
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + file);
            }
            assert (!file.isFile());
            logger.finer("\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f: " + file);
        }
    }

    public static void mkdir(File dir) throws IOException {
        if (dir.isDirectory()) {
            return;
        }
        if (!dir.mkdirs()) {
            if (dir.isFile()) {
                throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + dir + " \u306f\u65e2\u306b\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u5b58\u5728\u3057\u307e\u3059");
            }
            throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + dir);
        }
        assert (dir.isDirectory());
    }

    public static void rmdir(File dir) throws IOException {
        assert (!dir.exists() || dir.isDirectory()) : dir + " \u306f\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093";
        assert (dir.getParentFile() != null);
        if (dir.exists()) {
            IO.rmdir(dir.getCanonicalFile(), dir);
            logger.finer("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u524a\u9664\u3057\u307e\u3057\u305f: " + dir);
        } else {
            logger.finer("\u524a\u9664\u5bfe\u8c61\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093: " + dir);
        }
    }

    private static void rmdir(File root, File dir) throws IOException {
        assert (root.getCanonicalPath().equals(root.getAbsolutePath()));
        for (File f : dir.listFiles()) {
            if (!f.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                throw new IOException("\u30d5\u30a1\u30a4\u30eb " + f + " \u306f " + root + " \u306e\u4e0b\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
            if (f.isDirectory()) {
                IO.rmdir(root, f);
                continue;
            }
            if (!f.isFile()) continue;
            IO.delete(f);
        }
        if (!dir.delete()) {
            throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + dir + " \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093");
        }
        assert (!dir.exists());
        logger.finer("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f: " + dir);
    }

    public static void rename(File src, File dst) throws IOException {
        assert (src.isFile()) : "\u30d5\u30a1\u30a4\u30eb " + src.getName() + " \u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093";
        assert (!dst.exists() || dst.isFile()) : dst.getName() + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u3059";
        if (src.renameTo(dst)) {
            logger.finer("\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3057\u307e\u3057\u305f: " + src.getName() + " -> " + dst.getName());
            assert (!src.isFile());
            return;
        }
        logger.finer("\u30ea\u30cd\u30fc\u30e0\u306b\u5931\u6557\u3057\u307e\u3057\u305f (\u4e00\u56de\u76ee): " + src.getName() + " -> " + dst.getName());
        if (dst.exists()) {
            File temp = IO.mktemp(dst);
            IO.delete(temp);
            if (dst.renameTo(temp)) {
                logger.finer("\u30de\u30b9\u30bf\u30fc\u3092\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3057\u307e\u3057\u305f: " + dst.getName() + " -> " + temp.getName());
                if (src.renameTo(dst)) {
                    logger.finer("\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3057\u307e\u3057\u305f: " + src.getName() + " -> " + dst.getName());
                    IO.delete(temp);
                    assert (!src.isFile());
                    return;
                }
                logger.finer("\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u30de\u30b9\u30bf\u30fc\u306b\u623b\u3057\u307e\u3057\u305f: " + temp.getName() + " -> " + dst.getName());
                temp.renameTo(dst);
            }
        }
        logger.warning("\u30ea\u30cd\u30fc\u30e0\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + src.getName() + " -> " + dst.getName());
        throw new IOException(src.getAbsolutePath() + " -> " + dst.getName());
    }

    public static File mktemp(File file) throws IOException {
        logger.finest("mktemp(" + file + ")");
        String name = file.getName();
        String ext = "";
        int sep = name.lastIndexOf(46);
        if (sep >= 0) {
            ext = name.substring(sep);
            name = name.substring(0, sep);
        }
        while (name.length() < 3) {
            name = name + "_";
        }
        File dir = file.getParentFile();
        IO.mkdir(dir);
        File temp = File.createTempFile(name, ext, dir);
        logger.finest("\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u4f5c\u6210: " + temp);
        return temp;
    }

    public static long copy(File src, File dst) throws IOException {
        return IO.copy(src.toURI().toURL(), dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(URL url, File file) throws IOException {
        long length = 0L;
        InputStream in = null;
        RollbackOutputStream out = null;
        try {
            in = url.openStream();
            out = new RollbackOutputStream(file);
            length = IO.copy(in, out);
        }
        catch (Throwable throwable) {
            IO.close(in);
            IO.close(out);
            throw throwable;
        }
        IO.close(in);
        IO.close(out);
        return length;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int len;
        long length = 0L;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
            length += (long)len;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long safeCopy(InputStream in, RollbackOutputStream out) throws IOException {
        long length = 0L;
        boolean success = false;
        try {
            length = IO.copy(in, out);
            success = true;
        }
        finally {
            if (!success) {
                out.rollback();
            }
        }
        return length;
    }

    public static long copy(Reader in, Writer out) throws IOException {
        int len;
        long length = 0L;
        char[] buffer = new char[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
            length += (long)len;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File src, File dst) throws IOException {
        FileInputStream is = null;
        RollbackOutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new RollbackOutputStream(dst);
            GZIPOutputStream out = new GZIPOutputStream(os);
            IO.copy(is, out);
            out.finish();
            os.close();
            os = null;
        }
        finally {
            if (os != null) {
                os.rollback();
            }
            IO.close(is);
            IO.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(File src, File dst) throws IOException {
        FileInputStream is = null;
        RollbackOutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new RollbackOutputStream(dst);
            GZIPInputStream in = new GZIPInputStream(is);
            IO.copy(in, os);
            os.close();
            os = null;
        }
        finally {
            if (os != null) {
                os.rollback();
            }
            IO.close(is);
            IO.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader in) throws IOException {
        try {
            StringWriter out = new StringWriter();
            IO.copy(in, out);
            String string = out.toString();
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void expand(InputStream in, File dir) throws IOException {
        dir = dir.getCanonicalFile();
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                File file = null;
                try {
                    String name = new URI(entry.getName()).normalize().toString();
                    while (name.startsWith("/") || name.startsWith("\\")) {
                        name = name.substring(1);
                    }
                    file = new File(dir, name).getCanonicalFile();
                    if (!file.toString().startsWith(dir.getCanonicalPath())) {
                        throw new URISyntaxException(name, "\u5b9f\u30d5\u30a1\u30a4\u30eb\u304c\u5c55\u958b\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3088\u308a\u4e0a\u4f4d\u3092\u53c2\u7167\u3057\u3066\u3044\u307e\u3059: " + dir);
                    }
                }
                catch (URISyntaxException ex) {
                    logger.fine("\u4e0d\u6b63\u306a\u30d1\u30b9\u5f62\u5f0f\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059: " + entry.getName());
                    continue;
                }
                if (entry.isDirectory()) {
                    IO.mkdir(file);
                    continue;
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(file);
                    IO.copy(zin, out);
                }
                catch (Throwable throwable) {
                    IO.close(out);
                    throw throwable;
                }
                IO.close(out);
            }
        }
        catch (Throwable throwable) {
            IO.close(zin);
            throw throwable;
        }
        IO.close(zin);
    }

    public static final void write(OutputStream out, Node xml) throws IOException {
        try {
            DOMSource src = new DOMSource(xml);
            StreamResult rs = new StreamResult(out);
            TransformerFactory f = TransformerFactory.newInstance();
            Transformer t = f.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(src, rs);
        }
        catch (TransformerException ex) {
            logger.log(Level.SEVERE, "XML \u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            throw new IOException(ex.toString());
        }
    }

    public static void checkCancel() throws AbortException {
        if (Thread.interrupted()) {
            logger.finer("\u51e6\u7406\u306e\u30ad\u30e3\u30f3\u30bb\u30eb\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            throw new AbortException();
        }
    }

    public static String safename(String str) {
        return IO.safename(str, false);
    }

    public static String safename(String str, boolean jp) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < str.length() && buffer.length() < 256; ++i) {
            char ch = str.charAt(i);
            if (ch == '_') {
                buffer.append("__");
                continue;
            }
            if (Character.isDefined(ch) && IO.isSafeCharacter(ch, jp)) {
                buffer.append(ch);
                continue;
            }
            buffer.append('_').append(String.format("%04X", ch));
        }
        return buffer.toString();
    }

    public static IOException wrapThrow(Exception ex) throws IOException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        IOException e = new IOException();
        e.initCause(ex);
        throw e;
    }

    public static File changeExtension(File file, String ext) {
        String fileName;
        String base = fileName = file.getName();
        int sep = fileName.lastIndexOf(46);
        if (sep >= 0) {
            base = fileName.substring(0, sep);
        }
        return new File(file.getParentFile(), base + ext);
    }

    private static boolean isSafeCharacter(char ch, boolean jp) {
        if (ch == File.separatorChar || ch == File.pathSeparatorChar) {
            return false;
        }
        if (ch <= '\u00ff') {
            return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '.' || ch == '-' || ch == '_' || ch == '$' || ch == '!' || ch == '=' || ch == '(' || ch == ')';
        }
        return jp;
    }
}

