/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.koiroha.jive2ch.util.IO;
import org.w3c.dom.Node;

public final class Debug {
    private static final Logger logger = Logger.getLogger(Debug.class.getName());

    private Debug() {
    }

    public static String literal(String str) {
        return Debug.literal(str, true);
    }

    public static String literal(String str, boolean quote) {
        StringBuilder buffer = new StringBuilder();
        if (quote) {
            buffer.append('\"');
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            Debug.literize(buffer, ch, quote);
        }
        if (quote) {
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static String literal(char ch) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\'');
        Debug.literize(buffer, ch, true);
        buffer.append('\'');
        return buffer.toString();
    }

    private static void literize(StringBuilder buffer, char ch, boolean quote) {
        switch (ch) {
            case '\u0000': {
                buffer.append("\\0");
                break;
            }
            case '\b': {
                buffer.append("\\b");
                break;
            }
            case '\f': {
                buffer.append("\\f");
                break;
            }
            case '\n': {
                buffer.append("\\n");
                break;
            }
            case '\r': {
                buffer.append("\\r");
                break;
            }
            case '\t': {
                buffer.append("\\t");
                break;
            }
            case '\"': {
                if (quote) {
                    buffer.append(ch);
                    break;
                }
                buffer.append("\\\"");
                break;
            }
            case '\'': {
                if (quote) {
                    buffer.append(ch);
                    break;
                }
                buffer.append("\\'");
                break;
            }
            case '\\': {
                buffer.append("\\\\");
                break;
            }
            default: {
                if (Character.isDefined(ch) && !Character.isISOControl(ch)) {
                    buffer.append(ch);
                    break;
                }
                buffer.append(String.format("\\u%04X", ch));
            }
        }
    }

    public static final void dump(String msg, Node xml) {
        if (logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IO.write(baos, xml);
                logger.finest(msg + "\n" + new String(baos.toByteArray(), IO.UTF8.name()));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "XML \u306e\u30c0\u30f3\u30d7\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            }
        }
    }

    public static final void dump(String msg, String format, Object ... args) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(msg + "\n" + String.format(format, args));
        }
    }

    public static String getJavaVMInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Properties p = System.getProperties();
        pw.println("java version \"" + p.getProperty("java.version") + "\"");
        pw.println(p.getProperty("java.runtime.name") + " (build " + p.getProperty("java.runtime.version") + ")");
        pw.print(p.getProperty("java.vm.name") + " (build " + p.getProperty("java.vm.version") + ", " + p.getProperty("java.vm.info", "") + ")");
        return sw.toString().replace("(TM)", "\u2122");
    }

    public static String getSWTInfo() {
        return "SWT Version " + new DecimalFormat("0.000").format((double)SWT.getVersion() / 1000.0) + " for " + SWT.getPlatform();
    }

    public static String getDiagnostic() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Properties p = System.getProperties();
        pw.println(Debug.getJavaVMInfo());
        pw.println(Debug.getSWTInfo());
        pw.println("---------------------------------");
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            keys.add(en.nextElement().toString());
        }
        Collections.sort(keys);
        for (String k : keys) {
            pw.println(k + "=" + Debug.literal(p.getProperty(k)));
        }
        pw.println("---------------------------------");
        pw.println("Runtime.availableProcessors=" + Runtime.getRuntime().availableProcessors());
        pw.println("Runtime.maxMemory=" + Runtime.getRuntime().maxMemory());
        return sw.toString().trim();
    }
}

