/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.koiroha.jive2ch.Resource;

public final class AWT {
    private static final Logger logger = Logger.getLogger(AWT.class.getName());

    private AWT() {
    }

    public static byte[] getImage(String fileName, int width, int height) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("getImage(" + fileName + "," + width + "," + ")");
        }
        URL url = Resource.getResource(fileName);
        try {
            BufferedImage image = ImageIO.read(url);
            return AWT.resize(image, width, height);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static byte[] getImage(URL url, int width, int height) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("getImage(" + url + "," + width + "," + ")");
        }
        try {
            BufferedImage image = ImageIO.read(url);
            return AWT.resize(image, width, height);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static byte[] getImage(InputStream in, int width, int height) {
        try {
            BufferedImage image = ImageIO.read(in);
            return AWT.resize(image, width, height);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static byte[] getAAThumbnail(String aa) {
        Graphics g;
        BufferedImage image;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("getAAThumbnail(" + aa + ")");
        }
        int SIZE = 62;
        String[] lines = aa.split("[\r\n]");
        Font font = null;
        Dimension dim = new Dimension(1, 1);
        if (aa.length() > 0) {
            image = new BufferedImage(1, 1, 6);
            g = image.getGraphics();
            for (int i = 4; i < 62; ++i) {
                font = new Font("Dialog", 1, i);
                g.setFont(font);
                FontMetrics fm = g.getFontMetrics();
                for (String line : lines) {
                    dim.width = Math.max(dim.width, fm.stringWidth(line));
                    dim.height += fm.getHeight();
                }
                if (dim.width > 62 || dim.height > 62) break;
                dim = new Dimension(1, 1);
            }
            image.flush();
        }
        image = new BufferedImage(dim.width, dim.height, 6);
        g = image.getGraphics();
        int x = 0;
        int y = 0;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(Color.BLACK);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        for (String line : lines) {
            g.drawString(line, x, y + fm.getAscent());
            y += fm.getHeight();
        }
        return AWT.resize(image, 62, 62);
    }

    private static byte[] resize(BufferedImage image, int width, int height) {
        int w = image.getWidth();
        int h = image.getHeight();
        double d = Math.min((double)width / (double)w, (double)height / (double)h);
        BufferedImage thumb = image;
        if (d < 1.0) {
            int w2 = Math.max(0, (int)((double)w * d));
            int h2 = Math.max(0, (int)((double)h * d));
            Image img = image.getScaledInstance(w2, h2, 4);
            thumb = new BufferedImage(w2, h2, 6);
            Graphics g = thumb.getGraphics();
            g.drawImage(img, 0, 0, null);
            logger.finest("\u753b\u50cf\u30b5\u30a4\u30ba: (" + w + "," + h + ") -> (" + w2 + "," + h2 + ")");
            img.flush();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)thumb, "png", baos);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "PNG\u5f62\u5f0f\u306e\u5909\u63db\u306b\u5931\u6557", ex);
        }
        image.flush();
        thumb.flush();
        return baos.toByteArray();
    }
}

