/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.util.AWT;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class AADB {
    private static final Logger logger = Logger.getLogger(AADB.class.getName());
    private static final String AA_INDEX = "index.xml";
    private static final String AA_EXT = ".txt";
    private final File dir;
    private final List<AA> aa = new ArrayList<AA>();
    private boolean modified = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AADB(File dir) throws IOException {
        String name;
        this.dir = dir;
        IO.mkdir(dir);
        File file = new File(dir, AA_INDEX);
        Properties prop = new Properties();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            prop.loadFromXML(in);
        }
        catch (FileNotFoundException ex) {
            IO.close(in);
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        for (File f : dir.listFiles()) {
            String fileName = f.getName();
            if (!fileName.endsWith(AA_EXT) || prop.containsKey(fileName)) continue;
            if (f.length() == 0L) {
                f.delete();
                logger.info("\u7ba1\u7406\u5916\u306eAA\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3057\u305f: " + fileName);
                continue;
            }
            logger.info("\u7ba1\u7406\u5916\u306eAA\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u51fa: " + fileName);
            name = fileName.substring(0, fileName.length() - AA_EXT.length());
            prop.setProperty(fileName, name + "\\\u672a\u5206\u985e");
        }
        for (Object key : prop.keySet()) {
            String fileName = key.toString();
            String value = prop.getProperty(fileName);
            String[] elem = this.parse(value);
            name = elem[0];
            ArrayList<String> tags = new ArrayList<String>(elem.length - 1);
            for (int i = 1; i < elem.length; ++i) {
                tags.add(elem[i]);
            }
            if (tags.size() == 0) {
                tags.add("");
            }
            AA aa = new AA(new File(dir, fileName), name);
            aa.setTags(tags);
            this.aa.add(aa);
        }
    }

    public List<Tag> getTags() {
        HashSet<String> tags = new HashSet<String>();
        for (AA aa : this.aa) {
            tags.addAll(aa.getTags());
        }
        ArrayList<String> t = new ArrayList<String>(tags);
        Collections.sort(t);
        return this.parse(t);
    }

    public List<AA> getAA(String ... tags) throws IOException {
        logger.finest("getAA(" + Arrays.toString(tags) + ")");
        ArrayList<AA> aa = new ArrayList<AA>();
        for (String tag : tags) {
            for (AA a : this.aa) {
                if (!a.getTags().contains(tag)) continue;
                aa.add(a);
            }
        }
        return aa;
    }

    public void delete(AA aa) {
        for (int i = 0; i < this.aa.size(); ++i) {
            if (this.aa.get(i) != aa) continue;
            aa.delete();
            this.aa.remove(i);
            this.setModified(true);
            logger.fine("AA\u3092\u524a\u9664\u3057\u307e\u3057\u305f: " + aa.file.getName());
            return;
        }
        logger.warning("\u6307\u5b9a\u3055\u308c\u305fAA\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093: " + aa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (!this.modified) {
            logger.finer("save(): AA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        Properties prop = new Properties();
        for (AA aa : this.aa) {
            String key = aa.file.getName();
            StringBuilder value = new StringBuilder();
            value.append(aa.getName().replaceAll("\\\\", "\\\\"));
            for (String tag : aa.getTags()) {
                if (tag.length() <= 0) continue;
                value.append('\\');
                value.append(tag.replaceAll("\\\\", "\\\\"));
            }
            prop.setProperty(key, value.toString());
        }
        IO.mkdir(this.dir);
        File file = new File(this.dir, AA_INDEX);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new RollbackOutputStream(file));
            prop.storeToXML((OutputStream)out, "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306fAA\u7ba1\u7406\u7528\u3067\u3059\u3002\u76f4\u63a5\u7de8\u96c6\u3057\u306a\u3044\u3067\u304f\u3060\u3055\u3044\u3002", IO.UTF8.name());
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
        logger.finer("save(): AA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f");
        this.setModified(false);
    }

    public AA createAA() throws IOException {
        File file = File.createTempFile("noname", AA_EXT, this.dir);
        AA aa = new AA(file, "\u65b0\u898fAA");
        aa.setTags(Arrays.asList("\u672a\u5206\u985e"));
        this.aa.add(aa);
        this.setModified(true);
        return aa;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void flush() {
        logger.finest("flush()");
        for (AA aa : this.aa) {
            aa.flush();
        }
    }

    private List<Tag> parse(List<String> tags) {
        ArrayList<Tag> top = new ArrayList<Tag>();
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            String[] elem = tag.split("/");
            this.create(top, elem, tag);
        }
        return top;
    }

    private Tag create(List<Tag> top, String[] child, String canName) {
        for (Tag tag : top) {
            if (!tag.getName().equals(child[0])) continue;
            return this.create(tag, child, canName);
        }
        Tag t = new Tag(child[0], child[0]);
        top.add(t);
        return this.create(t, child, canName);
    }

    private Tag create(Tag tag, String[] child, String canName) {
        for (int i = 1; i < child.length; ++i) {
            Tag childTag = tag.getChild(child[i]);
            if (childTag == null) {
                childTag = new Tag(child[i], canName);
                tag.addChild(childTag);
            }
            tag = childTag;
        }
        return tag;
    }

    private String[] parse(String value) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> elem = new ArrayList<String>();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= value.length() || value.charAt(i + 1) != '\\') {
                    elem.add(buffer.toString());
                    buffer.setLength(0);
                    continue;
                }
                buffer.append('\\');
                ++i;
                continue;
            }
            buffer.append(ch);
        }
        elem.add(buffer.toString());
        return elem.toArray(new String[elem.size()]);
    }

    public static boolean tagsEquals(List<String> tags1, List<String> tags2) {
        if (tags1.size() != tags2.size()) {
            return false;
        }
        for (String tg : tags1) {
            if (tags2.contains(tg)) continue;
            return false;
        }
        return true;
    }

    public static final class Tag {
        private final String name;
        private final String canonicalName;
        private List<Tag> child = null;
        private Map<String, Tag> childMap = null;

        Tag(String name, String canonicalName) {
            this.name = name;
            this.canonicalName = canonicalName;
        }

        public String getName() {
            return this.name;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public List<Tag> getChild() {
            if (this.child == null) {
                return Collections.emptyList();
            }
            return this.child;
        }

        public Tag getChild(String name) {
            return this.childMap != null ? this.childMap.get(name) : null;
        }

        void addChild(Tag c) {
            if (this.child == null) {
                this.child = new ArrayList<Tag>();
                this.childMap = new HashMap<String, Tag>();
            }
            this.child.add(c);
            this.childMap.put(c.getName(), c);
        }

        public String toString() {
            return this.name;
        }
    }

    public class AA {
        private File file = null;
        private String name = "";
        private List<String> tags = new ArrayList<String>();
        private Image image = null;
        private String aa = null;

        private AA(File file, String name) throws IOException {
            this.file = file;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) throws IOException {
            assert (name != null);
            if (name.equals(this.name)) {
                logger.finer("setName(" + name + "): \u540d\u524d\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                return;
            }
            this.name = name;
            logger.finer("setName(" + name + "): \u540d\u524d\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f");
            String base = IO.safename(name, true);
            File dst = new File(AADB.this.dir, base + AADB.AA_EXT);
            if (!dst.createNewFile()) {
                while (base.length() < 3) {
                    base = base + "_";
                }
                dst = File.createTempFile(base, AADB.AA_EXT, AADB.this.dir);
            }
            if (this.file.isFile()) {
                IO.rename(this.file, dst);
                logger.finer("AA\u30d5\u30a1\u30a4\u30eb\u540d\u5909\u66f4: " + this.file.getName() + " -> " + dst.getName());
            }
            this.file = dst;
            AADB.this.setModified(true);
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            assert (tags != null);
            if (AADB.tagsEquals(this.tags, tags)) {
                return;
            }
            this.tags = tags;
            AADB.this.setModified(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getAA() throws IOException {
            if (this.aa == null) {
                FileReader in = null;
                try {
                    in = new FileReader(this.file);
                    StringWriter sw = new StringWriter();
                    IO.copy(in, sw);
                    logger.finest("AA\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f: " + this.file.getName());
                    this.aa = sw.toString();
                }
                catch (FileNotFoundException ex) {
                    String string;
                    try {
                        string = "(AA\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059: " + this.file.getName() + ")";
                    }
                    catch (Throwable throwable) {
                        IO.close(in);
                        throw throwable;
                    }
                    IO.close(in);
                    return string;
                }
                IO.close(in);
            }
            return this.aa;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAA(String aa) throws IOException {
            assert (aa != null);
            if (aa.equals(this.aa)) {
                logger.finer("AA\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u305b\u3093: " + this.file.getName());
                return;
            }
            FileWriter out = null;
            try {
                out = new FileWriter(this.file);
                out.write(aa);
            }
            catch (Throwable throwable) {
                IO.close(out);
                throw throwable;
            }
            IO.close(out);
            this.aa = aa;
            logger.finer("AA\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + this.file.getName());
        }

        public Image getImage() throws IOException {
            if (this.image == null) {
                byte[] bin = AWT.getAAThumbnail(this.getAA());
                this.image = new Image((Device)Display.getDefault(), new ByteArrayInputStream(bin));
            }
            return this.image;
        }

        public void flush() {
            this.aa = null;
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }

        public String toString() {
            return this.getName();
        }

        private void delete() {
            try {
                IO.delete(this.file);
            }
            catch (IOException ex) {
                logger.warning("AA\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.file);
            }
            this.flush();
        }
    }
}

