/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.koiroha.jive2ch.plugin.AppletPlugin;
import org.koiroha.jive2ch.plugin.Plugin;
import org.koiroha.jive2ch.plugin.PluginClassLoader;
import org.koiroha.jive2ch.plugin.PluginContext;
import org.koiroha.jive2ch.plugin.PluginException;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginStub {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PluginStub.class.getName());
    private final PluginContext context;
    private final Element config;
    private Plugin plugin = null;
    private boolean active = false;
    private final File streamKeys;
    private File archive = null;
    private final File temp;
    private final Map<String, Object> attribute = new HashMap<String, Object>();

    public PluginStub(PluginContext context, Element config, File dir, File archive) {
        this.context = context;
        this.config = config;
        this.archive = archive;
        this.streamKeys = new File(dir, "datastore" + File.separator + this.getId() + File.separator + ".index" + File.separator);
        this.temp = new File(dir, "tmp" + File.separator + this.getId() + File.separator);
        if (config.getTagName().equals("applet")) {
            String appletClassName = this.getAttr("code");
            Element param = config.getOwnerDocument().createElement("param");
            param.setAttribute("name", "org.koiroha.jive2ch.plugin.applet");
            param.setAttribute("value", appletClassName);
            config.insertBefore(param, config.getFirstChild());
            config.setAttribute("code", AppletPlugin.class.getName());
        }
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public String getId() {
        return this.getAttr("id");
    }

    public String getTitle() {
        return this.getAttr("title");
    }

    public URL getCodeBase() {
        String uri = this.getAttr("codebase");
        try {
            if (uri != null) {
                try {
                    URI u = new URI(uri);
                    if (u.isAbsolute()) {
                        return u.toURL();
                    }
                }
                catch (URISyntaxException ex) {
                    logger.log(Level.WARNING, "codebase \u306e URI \u304c\u4e0d\u6b63\u3067\u3059: " + uri, ex);
                }
            }
            return this.temp.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            logger.log(Level.WARNING, "codebase \u306e URI \u304c\u4e0d\u6b63\u3067\u3059: " + uri, ex);
            return null;
        }
    }

    public URI getIcon() {
        String uri = this.getAttr("icon");
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            logger.log(Level.WARNING, "URI\u69cb\u6587\u304c\u4e0d\u6b63\u3067\u3059: " + uri, ex);
            return null;
        }
    }

    public Plugin create(Composite parent) throws PluginException {
        assert (this.plugin == null);
        assert (parent != null);
        String IGNOREABLE_SUFFIX = ".class";
        PluginClassLoader loader = null;
        try {
            loader = new PluginClassLoader(this.archive, this.temp);
        }
        catch (IOException ex) {
            throw new PluginException("\u30d7\u30e9\u30b0\u30a4\u30f3\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u5c55\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
        String className = this.getAttr("code");
        if (className == null) {
            throw new PluginException("\u30d7\u30e9\u30b0\u30a4\u30f3\u69cb\u6210\u306b code \u5c5e\u6027\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (className.endsWith(".class")) {
            logger.config("\u30d7\u30e9\u30b0\u30a4\u30f3\u69cb\u6210\u306e code \u5c5e\u6027\u306b\u4ed8\u5c5e\u3059\u308b .class \u306f\u7121\u8996\u3055\u308c\u307e\u3059");
            className = className.substring(0, className.length() - ".class".length());
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            throw new PluginException("\u30d7\u30e9\u30b0\u30a4\u30f3\u30af\u30e9\u30b9 " + className + " \u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093", ex);
        }
        if (!Plugin.class.isAssignableFrom(clazz)) {
            throw new PluginException("\u30d7\u30e9\u30b0\u30a4\u30f3\u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u3067\u6307\u5b9a\u3055\u308c\u305f " + clazz.getSimpleName() + " \u306f " + Plugin.class.getSimpleName() + " \u306e\u30b5\u30d6\u30af\u30e9\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Composite.class);
        }
        catch (NoSuchMethodException ex) {
            throw new PluginException(Composite.class.getSimpleName() + " \u3092\u5f15\u6570\u306b\u6301\u3064 " + clazz.getSimpleName() + " \u30af\u30e9\u30b9\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093; \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf " + clazz.getSimpleName() + "(" + Composite.class.getSimpleName() + ") \u3092\u5b9a\u7fa9" + "\u3057\u3066\u4e0b\u3055\u3044", ex);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            this.plugin = (Plugin)constructor.newInstance(parent);
        }
        catch (InstantiationException ex) {
            throw new PluginException(className + " \u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
        catch (IllegalAccessException ex) {
            throw new PluginException(className + " \u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PluginException(className + " \u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3067\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", ex.getTargetException() != null ? ex.getTargetException() : ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.plugin.setStub(this);
        return this.plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void init() {
        if (this.plugin != null) {
            this.plugin.init();
        }
    }

    public void destroy() {
        if (this.plugin != null) {
            this.plugin.destroy();
        }
    }

    public void start() {
        if (this.plugin != null) {
            this.active = true;
            this.plugin.start();
        }
    }

    public void stop() {
        if (this.plugin != null) {
            this.active = false;
            this.plugin.stop();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public String getParameter(String name) {
        for (Node node : XML.evalList("param", this.config)) {
            Element param = (Element)node;
            if (!param.getAttribute("name").equals(name)) continue;
            return param.getAttribute("value");
        }
        return null;
    }

    public PluginContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Iterator<String> getStreamKeys() {
        logger.finest("getStreamKeys()");
        Set<Object> keys = new HashSet();
        FileChannel channel = null;
        try {
            channel = new FileInputStream(this.streamKeys).getChannel();
            channel.lock(0L, Integer.MAX_VALUE, true);
            Properties prop = new Properties();
            prop.load(Channels.newInputStream(channel));
            for (Object o : prop.keySet()) {
                keys.add((String)o);
            }
        }
        catch (FileNotFoundException ex) {
            keys = Collections.emptySet();
            IO.close(channel);
        }
        catch (IOException ex2) {
            logger.log(Level.WARNING, "\u30b9\u30c8\u30ea\u30fc\u30e0\u30d5\u30a1\u30a4\u30eb\u306e\u53c2\u7167\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex2);
            keys = Collections.emptySet();
            {
                catch (Throwable throwable) {
                    IO.close(channel);
                    throw throwable;
                }
            }
            IO.close(channel);
        }
        IO.close(channel);
        return keys.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public InputStream getStream(String key) {
        logger.finest("getStream(" + key + ")");
        String fileName = null;
        FileChannel channel = null;
        try {
            channel = new FileInputStream(this.streamKeys).getChannel();
            channel.lock(0L, Integer.MAX_VALUE, true);
            Properties prop = new Properties();
            prop.load(Channels.newInputStream(channel));
            fileName = prop.getProperty(key);
        }
        catch (FileNotFoundException ex) {
            InputStream inputStream = null;
            IO.close(channel);
            return inputStream;
        }
        catch (IOException ex2) {
            InputStream inputStream = null;
            {
                catch (Throwable throwable) {
                    IO.close(channel);
                    throw throwable;
                }
            }
            IO.close(channel);
            return inputStream;
        }
        IO.close(channel);
        if (fileName == null) {
            logger.fine("\u30ad\u30fc " + key + " \u306b\u5bfe\u3059\u308b\u30b9\u30c8\u30ea\u30fc\u30e0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            return null;
        }
        File file = new File(this.streamKeys.getParentFile(), fileName);
        if (!file.isFile()) {
            logger.warning("\u30ad\u30fc " + key + " \u306b\u5bfe\u3059\u308b\u30d5\u30a1\u30a4\u30eb " + fileName + " \u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            return null;
        }
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStream(String key, InputStream stream) throws IOException {
        logger.finest("setStream(" + key + "," + stream + ")");
        String fileName = null;
        FileChannel channel = null;
        try {
            if (!this.streamKeys.isFile()) {
                IO.mkdir(this.streamKeys.getParentFile());
                this.streamKeys.createNewFile();
            }
            channel = new RandomAccessFile(this.streamKeys, "rw").getChannel();
            channel.lock(0L, Integer.MAX_VALUE, false);
            Properties prop = new Properties();
            prop.load(Channels.newInputStream(channel));
            fileName = prop.getProperty(key);
            if (fileName == null) {
                File file = this.getStreamFile(key);
                if (file == null) {
                    throw new IOException("\u30ad\u30fc\u306e\u6587\u5b57\u5217\u9577\u304c\u9577\u3059\u304e\u307e\u3059: " + key.length() + "\u6587\u5b57; 256\u6587\u5b57\u4ee5\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                file.createNewFile();
                fileName = file.getName();
                prop.setProperty(key, fileName);
                channel.position(0L);
                prop.store(Channels.newOutputStream(channel), "");
                channel.truncate(channel.position());
            }
        }
        catch (Throwable throwable) {
            IO.close(channel);
            throw throwable;
        }
        IO.close(channel);
        File file = new File(this.streamKeys.getParentFile(), fileName);
        long length = 0L;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.getChannel().lock();
            length = IO.copy(stream, out);
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
        logger.fine("\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + key + " (" + length + "B)");
    }

    public void cleanup() throws IOException {
        assert (this.temp.getParentFile().getParentFile().equals(this.archive.getParentFile().getParentFile())) : this.temp.getParent() + " \u3068 " + this.archive.getParent();
        IO.rmdir(this.temp);
        IO.rmdir(this.streamKeys.getParentFile());
        IO.delete(this.archive);
    }

    public Object getAttribute(String name) {
        return this.attribute.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attribute.put(name, value);
    }

    private File getStreamFile(String key) {
        if (key.length() > 256) {
            logger.finer("\u30ad\u30fc\u306e\u6587\u5b57\u5217\u304c\u9577\u3059\u304e\u307e\u3059: " + key);
            return null;
        }
        String fileName = IO.safename(key) + ".sdt";
        return new File(this.streamKeys.getParentFile(), fileName);
    }

    private String getAttr(String name) {
        if (!this.config.hasAttribute(name)) {
            logger.finest(name + "=null");
            return null;
        }
        String value = this.config.getAttribute(name);
        logger.finest(name + "=" + value);
        return value;
    }
}

