/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.event.Jive2chListener;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.Jive2chFrame;
import org.koiroha.jive2ch.plugin.Plugin;
import org.koiroha.jive2ch.plugin.PluginContext;
import org.koiroha.jive2ch.plugin.PluginException;
import org.koiroha.jive2ch.plugin.PluginStub;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.XML;
import org.w3c.dom.Document;

public class PluginManager
implements PluginContext {
    private static final Logger logger = Logger.getLogger(PluginManager.class.getName());
    private static final String PLUGIN_EXT = ".j2p";
    private final File dir;
    private final File lib;
    private final Jive2chFrame frame;
    private final List<PluginStub> stubs = Collections.synchronizedList(new ArrayList());
    private PluginStub currentStub = null;
    private List<Throwable> exceptions = new ArrayList<Throwable>();

    public PluginManager(Jive2chFrame frame, File dir) {
        logger.finer("\u30d7\u30e9\u30b0\u30a4\u30f3\u30de\u30cd\u30fc\u30b8\u30e3\u3092\u8d77\u52d5\u3057\u3066\u3044\u307e\u3059: " + dir);
        this.frame = frame;
        this.dir = dir;
        this.lib = new File(dir, "lib");
        File[] archive = this.lib.listFiles();
        for (int i = 0; archive != null && i < archive.length; ++i) {
            File file = archive[i];
            if (!file.isFile() || !file.getName().endsWith(PLUGIN_EXT)) continue;
            try {
                PluginStub stub = this.createPluginStub(file);
                this.addPluginStub(stub, true);
                continue;
            }
            catch (IOException ex) {
                this.exceptions.add(ex);
                logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u69cb\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + file, ex);
            }
        }
    }

    public void install(CTabFolder tab, File file) throws PluginException {
        try {
            PluginStub stub = this.createPluginStub(file);
            this.addPluginStub(stub, true);
            this.create(tab, stub);
            this.init(stub);
            File lib = new File(this.dir, "lib");
            File dst = new File(lib, file.getName());
            if (dst.isFile()) {
                dst = IO.mktemp(dst);
            }
            IO.copy(file, dst);
            stub.setArchive(dst);
            logger.info("\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u307e\u3057\u305f");
        }
        catch (IOException ex) {
            throw new PluginException(ex);
        }
    }

    public void uninstall(PluginStub stub) throws IOException {
        try {
            if (stub.isActive()) {
                stub.stop();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + stub, ex);
        }
        try {
            stub.destroy();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u7d42\u4e86\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + stub, ex);
        }
        CTabItem item = (CTabItem)stub.getAttribute("item");
        item.dispose();
        logger.finest("\u30bf\u30d6\u3092\u30af\u30ed\u30fc\u30ba\u3057\u307e\u3057\u305f");
        stub.cleanup();
        this.stubs.remove(stub.getId());
        IO.delete(stub.getArchive());
        logger.info("\u30d7\u30e9\u30b0\u30a4\u30f3 " + stub.getId() + " (" + stub.getTitle() + ") \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u307e\u3057\u305f");
    }

    public void setCTabItem(CTabItem item, PluginStub stub) {
        item.setData(stub);
        stub.setAttribute("item", item);
        item.setControl(stub.getPlugin());
    }

    private PluginStub createPluginStub(File file) throws IOException {
        Document doc = PluginManager.readConfigureXML(file);
        return new PluginStub(this, doc.getDocumentElement(), this.dir, file);
    }

    private boolean addPluginStub(PluginStub stub, boolean overwrite) throws IOException {
        String id2 = stub.getId();
        PluginStub old = this.getPluginStub(id2);
        if (old == null) {
            this.stubs.add(stub);
            return true;
        }
        if (!overwrite) {
            return false;
        }
        this.uninstall(old);
        this.stubs.add(stub);
        return true;
    }

    public boolean isPluginArchive(File file, boolean external) {
        try {
            if (external && file.getCanonicalPath().startsWith(this.lib.getCanonicalPath())) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        if (!file.isFile() || !file.getName().endsWith(PLUGIN_EXT)) {
            logger.finest("\u30d5\u30a1\u30a4\u30eb\u3067\u306a\u3044\u304b.j2p\u62e1\u5f35\u5b50\u3092\u6301\u3061\u307e\u305b\u3093: " + file);
            return false;
        }
        try {
            PluginManager.readConfigureXML(file);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "\u30d7\u30e9\u30b0\u30a4\u30f3\u69cb\u6210\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + file, ex);
            return false;
        }
        return true;
    }

    public List<Throwable> getSetupExceptions() {
        return this.exceptions;
    }

    public void create(CTabFolder tab) {
        for (int i = 0; i < this.stubs.size(); ++i) {
            PluginStub stub = this.stubs.get(i);
            try {
                this.create(tab, stub);
                continue;
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                this.exceptions.add(ex);
                logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + stub, ex);
                this.stubs.remove(stub.getId());
                this.stubs.remove(i);
                --i;
            }
        }
        for (PluginStub stub : this.stubs) {
            this.init(stub);
        }
        if (tab.getItemCount() > 0) {
            tab.setSelection(0);
            this.setSelectedTabItem(tab.getItem(0));
        }
        tab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PluginManager.this.setSelectedTabItem((CTabItem)e.item);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin create(CTabFolder tab, PluginStub stub) throws PluginException {
        Plugin plugin = stub.create(tab);
        CTabItem item = new CTabItem(tab, 0);
        item.setToolTipText(stub.getTitle());
        this.setCTabItem(item, stub);
        if (stub.getIcon() != null) {
            Closeable in = null;
            URI uri = stub.getIcon();
            try {
                URL codebase = stub.getCodeBase();
                if (!uri.isAbsolute() && codebase != null) {
                    uri = codebase.toURI().resolve(uri);
                }
                Image image = Resource.loadImage(item.getDisplay(), uri.toURL(), 16, 16);
                item.setImage(image);
            }
            catch (Exception ex) {
                this.exceptions.add(ex);
                logger.warning("\u30a2\u30a4\u30b3\u30f3\u53c2\u7167\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + uri);
            }
            finally {
                IO.close(in);
            }
        }
        if (item.getImage() == null) {
            item.setImage(GUI.ICON_PLUGIN_DEFAULT);
        }
        return plugin;
    }

    private void init(PluginStub stub) {
        if (stub.getPlugin() != null) {
            try {
                stub.init();
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                this.exceptions.add(ex);
                logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + stub, ex);
            }
        }
    }

    public void dispose() {
        for (PluginStub stub : this.stubs) {
            try {
                if (!stub.isActive()) continue;
                stub.stop();
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + stub, ex);
            }
        }
        for (PluginStub stub : this.stubs) {
            try {
                stub.destroy();
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u7d42\u4e86\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + stub, ex);
            }
        }
    }

    public void setSelectedTabItem(CTabItem item) {
        PluginStub stub = null;
        if (item != null) {
            stub = (PluginStub)item.getData();
        }
        try {
            if (this.currentStub != null) {
                this.currentStub.stop();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
        this.currentStub = stub;
        try {
            if (this.currentStub != null) {
                this.currentStub.start();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
    }

    @Override
    public Plugin getPlugin(String id2) {
        PluginStub stub = this.getPluginStub(id2);
        if (stub == null) {
            return null;
        }
        return stub.getPlugin();
    }

    @Override
    public Iterator<Plugin> getPlugins() {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        for (PluginStub stub : this.stubs) {
            list.add(stub.getPlugin());
        }
        return list.iterator();
    }

    @Override
    public void showDocument(URL url) {
        logger.finest("showDocument(" + url + ")");
        this.frame.show(url.toString(), null);
    }

    @Override
    public void showDocument(URL url, String target) {
        logger.finest("showDocument(" + url + "," + target + ")");
        this.frame.show(url.toString(), target);
    }

    @Override
    public void showStatus(String status) {
        logger.finest("showStatus(" + status + ")");
        this.frame.setStatus(status);
    }

    @Override
    public void addJive2chListener(Jive2chListener listener) {
        this.frame.addJive2chListener(listener);
    }

    @Override
    public void removeJive2chListener(Jive2chListener listener) {
        this.frame.removeJive2chListener(listener);
    }

    private PluginStub getPluginStub(String id2) {
        for (PluginStub stub : this.stubs) {
            if (!stub.getId().equals(id2)) continue;
            return stub;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document readConfigureXML(File archive) throws IOException {
        Document document;
        InputStream in = null;
        ZipFile zip = null;
        try {
            Document doc;
            zip = new ZipFile(archive);
            ZipEntry entry = zip.getEntry("plugin.xml");
            if (entry == null) {
                throw new IOException("\u30d7\u30e9\u30b0\u30a4\u30f3\u30a2\u30fc\u30ab\u30a4\u30d6 " + archive + " \u306b plugin.xml \u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            in = zip.getInputStream(entry);
            document = doc = XML.read(in);
        }
        catch (Throwable throwable) {
            IO.close(in);
            IO.close(zip);
            throw throwable;
        }
        IO.close(in);
        IO.close(zip);
        return document;
    }
}

