/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import org.koiroha.jive2ch.util.IO;

class PluginClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(PluginClassLoader.class.getName());

    public PluginClassLoader(File archive, File dir) throws IOException {
        super(PluginClassLoader.getLibrary(archive, dir));
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = super.getPermissions(codesource);
        logger.finest("location=" + codesource.getLocation());
        return pc;
    }

    public String toString() {
        return Arrays.toString(super.getURLs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] getLibrary(File archive, File dir) throws IOException {
        IO.rmdir(dir);
        IO.mkdir(dir);
        FileInputStream in = null;
        try {
            in = new FileInputStream(archive);
            IO.expand(in, dir);
        }
        catch (Throwable throwable) {
            IO.close(in);
            throw throwable;
        }
        IO.close(in);
        logger.finest("\u30d7\u30e9\u30b0\u30a4\u30f3\u30a2\u30fc\u30ab\u30a4\u30d6\u3092\u5c55\u958b\u3057\u307e\u3057\u305f: " + dir);
        HashSet<URL> urls = new HashSet<URL>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".jar") && !f.getName().endsWith(".zip")) continue;
            URL u = f.toURI().toURL();
            urls.add(u);
            logger.finest("\u30e9\u30a4\u30d6\u30e9\u30ea\u691c\u51fa: " + f.getName() + " -> " + u);
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

