/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.pref;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.pref.PrefPanel;
import org.koiroha.jive2ch.util.NGWord;

public class NGWordPanel
extends PrefPanel {
    private static final String CHECK = "\u2713";
    private static final String UNCHECK = "";
    private final Table table;
    private final TableEditor editor;
    private final Button transparent;

    public NGWordPanel(Composite cmp) {
        this(cmp, Config.getDefault().getNGWords());
    }

    public NGWordPanel(Composite cmp, List<NGWord> list) {
        super(cmp);
        String[] label;
        ToolBar toolbar = new ToolBar(this, 0x800000);
        ToolItem ins = new ToolItem(toolbar, 8);
        ins.setImage(GUI.ICON_LIST_ADD);
        ins.setToolTipText("\u65b0\u3057\u3044NG\u30ef\u30fc\u30c9\u3092\u767b\u9332\u3057\u307e\u3059");
        ins.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                NGWordPanel.this.insert();
            }
        });
        final ToolItem del = new ToolItem(toolbar, 8);
        del.setImage(GUI.ICON_LIST_REMOVE);
        del.setToolTipText("\u9078\u629e\u3055\u308c\u3066\u3044\u308bNG\u30ef\u30fc\u30c9\u3092\u524a\u9664\u3057\u307e\u3059");
        del.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                NGWordPanel.this.delete();
            }
        });
        del.setEnabled(false);
        this.table = new Table(this, 2594);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData(new GridData(1808));
        TableColumn tc = null;
        tc = new TableColumn(this.table, 16384);
        tc.setText("NG\u30ef\u30fc\u30c9");
        tc.setWidth(160);
        tc.setResizable(true);
        for (String l : label = new String[]{"\u540d\u524d", "\u5185\u5bb9", "ID", "BE"}) {
            tc = new TableColumn(this.table, 16384);
            tc.setText(l);
            tc.setWidth(30);
            tc.setResizable(false);
        }
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.transparent = new Button(this, 32);
        this.transparent.setText("NG\u30ef\u30fc\u30c9\u3092\u542b\u3080\u30ec\u30b9\u3092\u5b8c\u5168\u975e\u8868\u793a\u306b\u3059\u308b");
        this.transparent.setSelection(Config.getDefault().isTransparentAbone());
        this.table.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int i = NGWordPanel.this.table.getSelectionIndex();
                del.setEnabled(i >= 0);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                TableItem item = NGWordPanel.this.table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                int index = -1;
                for (int i = 0; i < NGWordPanel.this.table.getColumnCount(); ++i) {
                    if (!item.getBounds(i).contains(e.x, e.y)) continue;
                    index = i;
                    break;
                }
                switch (index) {
                    case 0: {
                        NGWordPanel.this.edit();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (item.getText(index).equals(NGWordPanel.UNCHECK)) {
                            item.setText(index, NGWordPanel.CHECK);
                            break;
                        }
                        item.setText(index, NGWordPanel.UNCHECK);
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.character == '\t') {
                    NGWordPanel.this.insert();
                } else if (e.character == '\u007f') {
                    NGWordPanel.this.delete();
                } else if (e.character == '\r') {
                    NGWordPanel.this.edit();
                }
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            NGWord n = list.get(i);
            TableItem item = new TableItem(this.table, 32);
            NGWordPanel.set(item, n);
        }
    }

    private static void set(TableItem item, NGWord n) {
        item.setChecked(n.isEnabled());
        item.setText(0, n.getNGWord());
        if ((n.getField() & 1) != 0) {
            item.setText(1, CHECK);
        } else {
            item.setText(1, UNCHECK);
        }
        if ((n.getField() & 0x10) != 0) {
            item.setText(2, CHECK);
        } else {
            item.setText(2, UNCHECK);
        }
        if ((n.getField() & 4) != 0) {
            item.setText(3, CHECK);
        } else {
            item.setText(3, UNCHECK);
        }
        if ((n.getField() & 8) != 0) {
            item.setText(4, CHECK);
        } else {
            item.setText(4, UNCHECK);
        }
    }

    @Override
    public void commit() throws IOException {
        ArrayList<NGWord> list = new ArrayList<NGWord>();
        for (TableItem i : this.table.getItems()) {
            NGWord n = new NGWord();
            n.setEnabled(i.getChecked());
            n.setNGWord(i.getText(0));
            int field = 0;
            if (i.getText(1).equals(CHECK)) {
                field |= 1;
            }
            if (i.getText(2).equals(CHECK)) {
                field |= 0x10;
            }
            if (i.getText(3).equals(CHECK)) {
                field |= 4;
            }
            if (i.getText(4).equals(CHECK)) {
                field |= 8;
            }
            n.setField(field);
            list.add(n);
        }
        Config.getDefault().setNGWords(list);
        Config.getDefault().setTransparentAbone(this.transparent.getSelection());
    }

    private void insert() {
        NGWord n = new NGWord();
        TableItem item = new TableItem(this.table, 32);
        NGWordPanel.set(item, n);
        this.table.deselectAll();
        this.table.setSelection(item);
        this.edit();
    }

    private void delete() {
        TableItem[] item = this.table.getSelection();
        if (item == null || item.length == 0) {
            return;
        }
        if (!NGWordPanel.confirm("\u9078\u629e\u3055\u308c\u3066\u3044\u308b" + item.length + "\u500b\u306eNG\u30ef\u30fc\u30c9\u3092\u524a\u9664\u3057\u307e\u3059\u304b?", "NG\u30ef\u30fc\u30c9\u306e\u524a\u9664")) {
            return;
        }
        for (TableItem i : item) {
            this.table.remove(this.table.indexOf(i));
        }
    }

    private void edit() {
        int i = this.table.getSelectionIndex();
        if (i < 0) {
            return;
        }
        this.table.deselectAll();
        TableItem item = this.table.getItem(i);
        final Text text = new Text(this.table, 0);
        text.setText(item.getText(0));
        text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NGWordPanel.this.onChange(text);
            }
        });
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    NGWordPanel.this.onChange(text);
                } else if (e.character == '\u001b') {
                    text.dispose();
                }
            }
        });
        this.editor.setEditor(text, item, 0);
        text.setFocus();
        text.selectAll();
    }

    private void onChange(Text input) {
        String text = input.getText();
        TableItem item = this.editor.getItem();
        item.setText(0, text);
        input.dispose();
        this.table.setSelection(item);
    }
}

