/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.popup;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.ThreadBrowser;
import org.koiroha.jive2ch.gui.ThreadViewer;
import org.koiroha.jive2ch.gui.popup.Popup;
import org.koiroha.jive2ch.gui.popup.PopupHelper;
import org.koiroha.jive2ch.gui.popup.PopupLayer;
import org.koiroha.jive2ch.util.NGWord;
import org.koiroha.jive2ch.util.Pointer;

public class PopupManager {
    private static final Logger logger = Logger.getLogger(PopupManager.class.getName());
    private final ThreadViewer viewer;
    private final PopupLayer root;
    private boolean rolloverPopup = true;

    public PopupManager(ThreadViewer viewer, ThreadBrowser browser) {
        this.viewer = viewer;
        this.root = new PopupLayer(browser.getBrowser());
        new CallbackFunction(this.root, browser.getBrowser());
    }

    public void setRolloverPopup(boolean overrollPopup) {
        this.rolloverPopup = overrollPopup;
    }

    public void closeAll() {
        assert (GUI.isEventDispatchThread());
        if (this.root.getChild() != null) {
            this.root.getChild().close();
        }
    }

    private void callback(PopupLayer layer, Object[] argo) {
        Object[] args = new String[argo.length];
        for (int i = 0; i < argo.length; ++i) {
            args[i] = String.valueOf(argo[i]);
        }
        if (args.length == 0) {
            logger.warning("\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        if (args[0].equals("mouseover") && args.length > 7) {
            Rectangle p = PopupManager.getRectangle(argo, 2);
            this.rollover(layer, args[1], p);
            return;
        }
        if (args[0].equals("click") && args.length > 7) {
            Rectangle p = PopupManager.getRectangle(argo, 2);
            this.click(layer, (String)args[1], p);
            return;
        }
        logger.finest("\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u306f\u7121\u8996\u3055\u308c\u307e\u3057\u305f: " + Arrays.toString(args));
    }

    private void rollover(PopupLayer layer, String target, Rectangle rect) {
        logger.finest("rollover(" + target + "," + rect + ")");
        if (!this.rolloverPopup && !PopupLayer.isMetaKeyPressed()) {
            logger.finest("\u30ed\u30fc\u30eb\u30aa\u30fc\u30d0\u30fc\u51e6\u7406\u306f\u7121\u52b9\u5316\u3055\u308c\u3066\u3044\u307e\u3059");
            return;
        }
        long interval = Config.getDefault().getPopupInterval();
        if (target.startsWith(">>") || target.startsWith("ID:")) {
            PopupLayer child = new PopupLayer(layer, target);
            child.addListener(new Listener(target));
            child.scheduleOpen(interval, rect);
            return;
        }
        if (PopupLayer.isMetaKeyPressed() && (target.startsWith("http:") || target.startsWith("https:"))) {
            PopupLayer child = new PopupLayer(layer, target);
            child.addListener(new Listener(target));
            child.scheduleOpen(interval, rect);
            return;
        }
        logger.finest("\u30ed\u30fc\u30eb\u30aa\u30fc\u30d0\u30fc\u51e6\u7406\u306f\u7121\u8996\u3055\u308c\u307e\u3057\u305f: [" + target + "] " + rect);
    }

    private void click(PopupLayer layer, String target, Rectangle rect) {
        logger.finest("click(" + target + "," + rect + ")");
        if (target.regionMatches(true, 0, "num:", 0, 4)) {
            try {
                int num = Integer.parseInt(target.substring(4)) - 1;
                if (num < 0) {
                    logger.warning("\u30ec\u30b9\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059" + target);
                    return;
                }
                this.numberPopup(layer, num, rect);
            }
            catch (NumberFormatException ex) {
                logger.warning("\u7121\u52b9\u306a\u30ec\u30b9\u756a\u53f7\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + target);
            }
            return;
        }
        if (target.startsWith("http:") || target.startsWith("https:")) {
            this.viewer.getAppFrame().show(target, "_blank");
            return;
        }
        logger.finest("\u30af\u30ea\u30c3\u30af\u51e6\u7406\u306f\u7121\u8996\u3055\u308c\u307e\u3057\u305f: [" + target + "] " + rect);
    }

    private void numberPopup(final PopupLayer layer, int num, final Rectangle rect) {
        logger.finest("numberPopup(" + num + "," + rect + ")");
        final Thread thread = this.viewer.getThread();
        final Response res = thread.getResponse().get(num);
        final Thread th = this.viewer.getThread();
        if (th == null) {
            return;
        }
        final Pointer ptr = thread.getLocalNG();
        Browser browser = (Browser)layer.getControl();
        assert (browser != null);
        Display display = browser.getDisplay();
        Menu popup = new Menu(browser);
        MenuItem item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u3092\u53c2\u7167\u3057\u3066\u3044\u308b\u30ec\u30b9\u3092\u8868\u793a");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String p = PopupManager.getReferrer(th, res);
                if (p.length() > 0) {
                    String target = ">>" + p;
                    PopupLayer l = new PopupLayer(layer, target);
                    l.addListener(new Listener(target));
                    l.scheduleOpen(0L, rect);
                }
            }
        });
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u306b\u30ec\u30b9(&R)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PopupManager.this.viewer.getMultiPane().edit(">>" + res.getNumber() + "\n");
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u3092\u5f15\u7528\u3057\u3066\u30ec\u30b9(&Q)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String c = "\n> " + res.getPlainText().replaceAll("\n", "\n> ");
                PopupManager.this.viewer.getMultiPane().edit(">>" + res.getNumber() + c + "\n");
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u306e\u540d\u524d\u3092\u5f15\u7528\u3057\u3066\u30ec\u30b9(&N)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PopupManager.this.viewer.getMultiPane().edit(">>" + res.getAuthor() + "\n");
            }
        });
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u306eURL\u3092\u30b3\u30d4\u30fc(&C)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String url = thread.getBrowserURI().toString();
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                url = url + res.getNumber();
                GUI.copyToClipboard(url);
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u306b\u5f15\u7528\u7b26\u3092\u4ed8\u3051\u3066\u30b3\u30d4\u30fc(&R)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String c = "\n> " + res.getPlainText().replaceAll("\n", "\n> ");
                GUI.copyToClipboard(">>" + res.getNumber() + c + "\n");
            }
        });
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        if (!ptr.contains(thread.getResponseCount(), res.getNumber())) {
            item.setText("\u3053\u306e\u30ec\u30b9\u3092\u3042\u307c\u301c\u3093(&T)");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    thread.setLocalNG(ptr.add(res.getNumber()));
                    thread.saveMetaInfo();
                    PopupManager.this.viewer.reload(ThreadViewer.RefreshMode.REDRAW_ONLY);
                    PopupManager.this.viewer.jump(res.getNumber());
                }
            });
        } else {
            item.setText("\u3053\u306e\u30ec\u30b9\u306e\u3042\u307c\u301c\u3093\u3092\u89e3\u9664(&T)");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    thread.setLocalNG(ptr.minus(res.getNumber()));
                    thread.saveMetaInfo();
                    PopupManager.this.viewer.reload(ThreadViewer.RefreshMode.REDRAW_ONLY);
                    PopupManager.this.viewer.jump(res.getNumber());
                }
            });
        }
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u540d\u524d\u3092NG\u30ef\u30fc\u30c9\u306b\u8ffd\u52a0");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                List<NGWord> list = Config.getDefault().getNGWords();
                NGWord word = new NGWord();
                word.setNGWord(res.getAuthor());
                word.setField(1);
                list.add(word);
                Config.getDefault().setNGWords(list);
                PopupManager.this.viewer.reload(ThreadViewer.RefreshMode.REDRAW_ONLY);
                PopupManager.this.viewer.jump(res.getNumber());
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306eID\u3092NG\u30ef\u30fc\u30c9\u306b\u8ffd\u52a0(&N)");
        if (res.getId() == null) {
            item.setEnabled(false);
        } else {
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    List<NGWord> list = Config.getDefault().getNGWords();
                    NGWord word = new NGWord();
                    word.setNGWord(res.getId());
                    word.setField(4);
                    list.add(word);
                    Config.getDefault().setNGWords(list);
                    PopupManager.this.viewer.resetNGWord();
                    PopupManager.this.viewer.reload(ThreadViewer.RefreshMode.REDRAW_ONLY);
                    PopupManager.this.viewer.jump(res.getNumber());
                }
            });
        }
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306eBE\u3092NG\u30ef\u30fc\u30c9\u306b\u8ffd\u52a0(&E)");
        if (res.getBe() == null) {
            item.setEnabled(false);
        } else {
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    List<NGWord> list = Config.getDefault().getNGWords();
                    NGWord word = new NGWord();
                    word.setNGWord(res.getBe());
                    word.setField(8);
                    list.add(word);
                    Config.getDefault().setNGWords(list);
                    PopupManager.this.viewer.resetNGWord();
                    PopupManager.this.viewer.reload(ThreadViewer.RefreshMode.REDRAW_ONLY);
                    PopupManager.this.viewer.jump(res.getNumber());
                }
            });
        }
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u306eID\u3067\u30ec\u30b9\u30d5\u30a3\u30eb\u30bf(&F)");
        if (res.getId() == null) {
            item.setEnabled(false);
        }
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30ec\u30b9\u306e\u540d\u524d\u3067\u30ec\u30b9\u30d5\u30a3\u30eb\u30bf(&U)");
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        item.setText("\u3053\u3053\u304b\u3089\u307e\u3068\u3081\u3066...(&M)");
        if (rect != null) {
            popup.setLocation(browser.toDisplay(rect.x, rect.y + rect.height));
        } else {
            popup.setLocation(display.getCursorLocation());
        }
        popup.setVisible(true);
    }

    private ThreadBrowser openBrowser(PopupLayer layer, String target) {
        assert (GUI.isEventDispatchThread());
        Popup popup = layer.getPopup();
        Rectangle hotspot = layer.getParent().getHotspot();
        Display display = popup.getDisplay();
        popup.getShell().setAlpha(230);
        ThreadBrowser browser = new ThreadBrowser(popup, 0);
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("popup", "popup");
            browser.showBaseHTML(param);
            browser.setThread(this.viewer.getThread());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        browser.setLayoutData(new GridData(1808));
        Browser b = browser.getBrowser();
        Point cursor = null;
        if (hotspot != null) {
            PopupLayer parent = layer.getParent();
            cursor = parent.getControl().toDisplay(hotspot.x, hotspot.y);
        } else {
            cursor = display.getCursorLocation();
            cursor.x -= 5;
            cursor.y += 5;
        }
        Point size = b.computeSize(460, 150);
        popup.getShell().setSize(size);
        PopupHelper helper = new PopupHelper(layer, browser);
        Point newSize = helper.showTargetAndCalRect(target);
        if (newSize == null) {
            newSize = new Point(size.x, size.y);
        }
        Rectangle screen = display.getClientArea();
        size = b.computeSize(newSize.x, newSize.y + 20);
        size.x = Math.min(screen.width, size.x);
        size.y = Math.min(screen.height, size.y);
        int x = Math.max(screen.x, Math.min(cursor.x, screen.x + screen.width - size.x));
        int y = Math.max(screen.y, Math.min(cursor.y - size.y, screen.y + screen.height - screen.y));
        Rectangle r = new Rectangle(x, y, size.x, size.y);
        popup.getShell().setBounds(r);
        logger.finer("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u30b5\u30a4\u30ba\u8a2d\u5b9a: " + r);
        new CallbackFunction(layer, b);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u3092\u30aa\u30fc\u30d7\u30f3\u3057\u307e\u3057\u305f: [" + target + "] " + popup.getShell().getBounds());
        }
        return browser;
    }

    private static String getReferrer(Thread th, Response res) {
        StringBuilder buffer = new StringBuilder();
        Pattern p = Pattern.compile("[>\uff1e\u226b]{1,2}([\\d\uff10-\uff19]+)");
        block0: for (Response r : th.getResponse()) {
            String text = r.getPlainText();
            Matcher m = p.matcher(text);
            while (m.find()) {
                if (Integer.parseInt(m.group(1)) != res.getNumber()) continue;
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(r.getNumber());
                continue block0;
            }
        }
        return buffer.toString();
    }

    private static Rectangle getRectangle(Object[] args, int offset) {
        if (args.length <= offset + 5) {
            return null;
        }
        int x0 = PopupManager.intValue(args[offset + 0]);
        int y0 = PopupManager.intValue(args[offset + 1]);
        int x1 = PopupManager.intValue(args[offset + 2]);
        int y1 = PopupManager.intValue(args[offset + 3]);
        int w = PopupManager.intValue(args[offset + 4]);
        int h = PopupManager.intValue(args[offset + 5]);
        if (x0 < 0 || y0 < 0 || x1 < 0 || y1 < 0 || w < 0 || h < 0) {
            return null;
        }
        return new Rectangle(x1 - x0, y1 - y0, w, h);
    }

    private static int intValue(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(obj));
        }
        catch (NumberFormatException ex) {
            logger.warning("\u6570\u5024\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059: " + obj);
            return -1;
        }
    }

    private class CallbackFunction
    extends BrowserFunction {
        private final PopupLayer layer;

        public CallbackFunction(PopupLayer layer, Browser browser) {
            super(browser, "jive2ch_callback");
            this.layer = layer;
            browser.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent e) {
                    CallbackFunction.this.dispose();
                }
            });
        }

        @Override
        public Object function(Object[] args) {
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("\u30b9\u30af\u30ea\u30d7\u30c8\u30b3\u30fc\u30eb\u30d0\u30c3\u30af: " + Arrays.toString(args));
                }
                if (this.layer.hasShowingChild()) {
                    logger.finer("\u4e00\u756a\u4e0a\u306e\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u4ee5\u5916\u304b\u3089\u306e\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u306f\u7121\u8996\u3055\u308c\u307e\u3059");
                    return null;
                }
                PopupManager.this.callback(this.layer, args);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("\u30b9\u30af\u30ea\u30d7\u30c8\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u51e6\u7406\u306e\u7d42\u4e86: " + Arrays.toString(args));
                }
            }
            catch (Exception ex) {
                J2Component.fatal(ex);
            }
            return null;
        }
    }

    private class Listener
    implements PopupLayer.Listener {
        private final String target;

        public Listener(String target) {
            this.target = target;
        }

        @Override
        public void popupOpening(PopupLayer.Event e) {
            ThreadBrowser browser = PopupManager.this.openBrowser(e.getPopupLayer(), this.target);
            e.setControl(browser.getBrowser());
        }

        @Override
        public void popupClosing(PopupLayer.Event e) {
        }
    }
}

