/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.popup;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.popup.Popup;
import org.koiroha.jive2ch.gui.popup.PopupDisposeException;

class PopupLayer
extends MouseTrackAdapter
implements MouseMoveListener,
KeyListener {
    private static final Logger logger = Logger.getLogger(PopupLayer.class.getName());
    private static boolean metaKeyPressed = false;
    private final String name;
    private final PopupLayer parent;
    private Popup popup = null;
    private Control control = null;
    private PopupLayer child = null;
    private Rectangle hotspot = null;
    private GUI.SWTTimerTask timerTask = null;
    private boolean closed = false;
    private final List<Listener> listener = new ArrayList<Listener>();

    public PopupLayer(Control control) {
        this.parent = null;
        this.control = control;
        this.name = "root";
        this.setEventListener(control);
    }

    public PopupLayer(PopupLayer parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public void scheduleOpen(long interval, Rectangle hotspot) {
        assert (this.parent != null) : "\u30eb\u30fc\u30c8\u306e\u30ec\u30a4\u30e4\u30fc\u306f\u30aa\u30fc\u30d7\u30f3\u3067\u304d\u307e\u305b\u3093";
        logger.finest("scheduleOpen(" + interval + "," + hotspot + ")");
        if (this.parent.child != null) {
            this.parent.child.close();
        }
        this.parent.setChild(hotspot, this);
        if (logger.isLoggable(Level.FINEST)) {
            PopupLayer mover;
            int count = 0;
            for (mover = this; mover != null; mover = mover.getParent()) {
                ++count;
            }
            for (mover = this; mover != null; mover = mover.getParent()) {
                logger.finest("PopupLayer[" + --count + "] " + mover);
            }
        }
        this.timerTask = new GUI.SWTTimerTask(){

            @Override
            public void asyncExec() {
                try {
                    PopupLayer.this.open();
                }
                catch (PopupDisposeException ex) {
                    logger.finer("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u8868\u793a\u4e2d\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u307e\u3057\u305f");
                }
            }
        };
        GUI.schedule(this.timerTask, interval);
    }

    private void open() {
        assert (GUI.isEventDispatchThread());
        this.timerTask = null;
        if (this.closed) {
            logger.finer("\u30ec\u30a4\u30e4\u30fc\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
            return;
        }
        this.popup = new Popup(this.parent.popup);
        Event e = new Event();
        for (Listener l : this.listener) {
            l.popupOpening(e);
        }
        this.control = e.getControl();
        if (this.control != null) {
            this.setEventListener(this.control);
        } else {
            Label label = new Label(this.popup, 0);
            label.setText("control not specified");
            this.control = label;
        }
        this.popup.open();
    }

    public void close() {
        assert (GUI.isEventDispatchThread());
        assert (this.parent != null) : "\u30eb\u30fc\u30c8\u306e\u30ec\u30a4\u30e4\u30fc\u306f\u30af\u30ed\u30fc\u30ba\u3067\u304d\u307e\u305b\u3093";
        this.closed = true;
        if (this.popup == null || this.popup.isDisposed()) {
            return;
        }
        if (this.child != null) {
            this.child.close();
        }
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.close();
        }
        this.popup = null;
        this.control = null;
        assert (this.parent.child == this);
        this.parent.setChild(null, null);
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        final Control control = this.parent.control;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!control.isDisposed()) {
                    control.setFocus();
                }
            }
        });
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u3092\u30af\u30ed\u30fc\u30ba\u3057\u307e\u3057\u305f");
        }
    }

    public PopupLayer getParent() {
        return this.parent;
    }

    public PopupLayer getChild() {
        return this.child;
    }

    public boolean hasShowingChild() {
        return this.child != null && this.child.popup != null && this.child.popup.isVisible();
    }

    public String getName() {
        return this.name;
    }

    public Popup getPopup() {
        return this.popup;
    }

    public Control getControl() {
        return this.control;
    }

    public Rectangle getHotspot() {
        return this.hotspot;
    }

    private void setChild(Rectangle hotspot, PopupLayer child) {
        assert (GUI.isEventDispatchThread());
        if (this.child != null) {
            this.child.close();
        }
        this.child = child;
        this.hotspot = hotspot;
    }

    private static void initMetaKeyPressed(int stateMask) {
        boolean old = metaKeyPressed;
        boolean bl = metaKeyPressed = (stateMask & Platform.META) == Platform.META;
        if (logger.isLoggable(Level.FINEST) && old != metaKeyPressed) {
            if (metaKeyPressed) {
                logger.finest("\u30e1\u30bf\u30ad\u30fc\u306e\u62bc\u4e0b\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
            } else {
                logger.finest("\u30e1\u30bf\u30ad\u30fc\u306e\u89e3\u653e\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
            }
        }
    }

    public static boolean isMetaKeyPressed() {
        return metaKeyPressed;
    }

    @Override
    public void mouseMove(MouseEvent e) {
        assert (GUI.isEventDispatchThread());
        if (this.hotspot != null && !this.hotspot.contains(e.x, e.y)) {
            assert (this.child != null);
            this.child.close();
        }
        PopupLayer.initMetaKeyPressed(e.stateMask);
    }

    @Override
    public void mouseExit(MouseEvent e) {
        assert (GUI.isEventDispatchThread());
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("mouseExit(" + e + ")");
        }
        if (this.getParent() != null && this.getChild() == null) {
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        PopupLayer.initMetaKeyPressed(e.stateMask);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        PopupLayer.initMetaKeyPressed(e.stateMask);
    }

    public void addListener(Listener l) {
        this.listener.add(l);
    }

    public void removeListener(Listener l) {
        this.listener.remove(l);
    }

    protected void setEventListener(Control control) {
        control.addMouseMoveListener(this);
        control.addKeyListener(this);
        control.addMouseTrackListener(this);
    }

    public String toString() {
        return this.getName();
    }

    public static interface Listener
    extends EventListener {
        public void popupOpening(Event var1);

        public void popupClosing(Event var1);
    }

    public class Event
    extends EventObject {
        private static final long serialVersionUID = 1L;

        private Event() {
            super(PopupLayer.this);
        }

        public PopupLayer getPopupLayer() {
            return PopupLayer.this;
        }

        public Rectangle getHotspot() {
            return PopupLayer.this.hotspot;
        }

        public Control getControl() {
            return PopupLayer.this.control;
        }

        public void setControl(Control control) {
            PopupLayer.this.control = control;
        }
    }
}

