/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.popup;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.ThreadBrowser;
import org.koiroha.jive2ch.gui.popup.PopupLayer;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.xml.Html;

class PopupHelper {
    private static final Logger logger = Logger.getLogger(PopupHelper.class.getName());
    private final PopupLayer layer;
    private final ThreadBrowser browser;

    public PopupHelper(PopupLayer layer, ThreadBrowser browser) {
        this.browser = browser;
        this.layer = layer;
    }

    public Point showTargetAndCalRect(String target) {
        if (target.startsWith(">>")) {
            this.showHtml(this.browser, target.substring(2));
            return this.getElementSize(this.browser, "content");
        }
        if (target.toLowerCase().matches("http://.*\\.(jpg|jpeg|gif|png|tif|tiff)")) {
            return this.showImageTarget(target);
        }
        if (target.startsWith("ID:")) {
            String id2 = target.substring(3);
            Thread thread = this.browser.getThread();
            StringBuilder buffer = new StringBuilder();
            for (Response res : thread.getResponse()) {
                if (!id2.equals(res.getId())) continue;
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(res.getNumber());
            }
            this.showHtml(this.browser, buffer.toString());
            return this.getElementSize(this.browser, "content");
        }
        if (target.startsWith("http://")) {
            List<Response> list = this.getTopResponse(target);
            if (list != null) {
                if (list.size() > 0 && list.get(0).getTitle() != null) {
                    this.browser.getBrowser().setToolTipText(list.get(0).getTitle());
                }
                this.showHtml(this.browser, list);
                return this.getElementSize(this.browser, "content");
            }
            this.browser.setExternalURLEnabled(true);
            this.browser.getBrowser().setJavascriptEnabled(false);
            this.browser.getBrowser().setUrl(target);
            return null;
        }
        return null;
    }

    public Point showImageTarget(String target) {
        this.browser.getBrowser().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                PopupHelper.this.layer.close();
            }
        });
        String html = "<html><body style=\"margin:0px; padding:0px;\"><div id=\"content\"><img id=\"img\" title=\"" + Html.escape(target) + "\" src=\"" + Html.escape(target) + "\">" + "</div>" + "</body>" + "</html>";
        this.browser.setHTML(html);
        return this.getElementSize(this.browser, "img");
    }

    private List<Response> getTopResponse(String threadUri) {
        try {
            URI u = new URI(threadUri);
            Service svc = Service.getService(u);
            if (svc == null) {
                return null;
            }
            URI uri = svc.getDataURI(u);
            URI boardUri = svc.getBoardURI(uri);
            String fileName = svc.getFileName(uri);
            Pointer pointer = svc.getResponsePointer(u);
            if (pointer == null) {
                pointer = Pointer.compile("1");
            }
            Category cat = new Category(Jive2ch.getDefault(), "\u7121\u984c");
            Board board = svc.createBoard(cat, "\u7121\u984c", boardUri);
            Thread thread = svc.createThread(board, fileName, "\u7121\u984c", 1);
            return Thread.quicklook(thread, pointer);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "\u30b9\u30ec\u306e\u30af\u30a4\u30c3\u30af\u30eb\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            return null;
        }
    }

    private Point getElementSize(ThreadBrowser browser, String id2) {
        Object width = browser.getBrowser().evaluate("return document.getElementById('" + id2 + "').offsetWidth;");
        Object height = browser.getBrowser().evaluate("return document.getElementById('" + id2 + "').offsetHeight;");
        if (!(width instanceof Number) || !(height instanceof Number)) {
            return null;
        }
        return new Point(((Number)width).intValue(), ((Number)height).intValue());
    }

    private void showHtml(ThreadBrowser browser, String pointer) {
        Pointer p = Pointer.compile(pointer);
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("popup", "popup");
            if (!browser.getBrowser().isDisposed()) {
                browser.showBaseHTML(param);
                browser.addResponse(p, param);
            }
        }
        catch (IOException ex) {
            J2Component.fatal(ex);
        }
    }

    private void showHtml(ThreadBrowser browser, List<Response> list) {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("popup", "popup");
            if (!browser.getBrowser().isDisposed()) {
                browser.showBaseHTML(param);
                browser.addResponse(list, param);
            }
        }
        catch (IOException ex) {
            J2Component.fatal(ex);
        }
    }
}

