/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.util.IO;

public class TextEditDialog
extends J2Dialog {
    private static final Logger logger = Logger.getLogger(TextEditDialog.class.getName());
    private File file = null;
    private final Text editor;
    private final MenuItem save;

    public TextEditDialog(J2Component parent) {
        super(parent, 67696);
        Composite panel = this.getMessagePane();
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 5;
        panel.setLayout(layout);
        this.editor = new Text(panel, 2626);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 400;
        this.editor.setLayoutData(gd);
        this.setOptionIcon(null);
        this.setOptions(new Object[]{J2Dialog.Option.OK});
        this.setDefaultOption((Object)J2Dialog.Option.OK);
        Menu menubar = new Menu(this.getShell(), 2);
        this.getShell().setMenuBar(menubar);
        MenuItem edit = new MenuItem(menubar, 64);
        Menu menu = new Menu(menubar);
        edit.setText("\u7de8\u96c6");
        edit.setMenu(menu);
        this.save = new MenuItem(menu, 8);
        this.save.setText("\u4fdd\u5b58(&S)");
        this.save.setAccelerator(Platform.META | 0x53);
        this.save.setEnabled(false);
        this.save.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                try {
                    TextEditDialog.this.save();
                }
                catch (IOException ex) {
                    J2Component.fatal(ex);
                }
            }
        });
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setText(String text) {
        this.editor.setText(text);
        this.editor.setSelection(text.length());
    }

    public void setEditable(boolean editable) {
        this.editor.setEditable(editable);
        this.save.setEnabled(this.editor.isEnabled() && this.file != null);
    }

    public void setCaretPosition(int pos) {
        this.editor.setSelection(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        this.file = file;
        this.save.setEnabled(this.editor.isEnabled() && file != null);
        StringBuilder buffer = new StringBuilder();
        FileReader in = null;
        try {
            int len;
            in = new FileReader(file);
            char[] buf = new char[1024];
            while ((len = in.read(buf)) >= 0) {
                buffer.append(buf, 0, len);
            }
            logger.finer("\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f: " + file);
        }
        catch (FileNotFoundException ex) {
            try {
                logger.finer("\u8aad\u307f\u8fbc\u307f\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093: " + file);
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
            IO.close(in);
        }
        IO.close(in);
        this.setText(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("\u4fdd\u5b58\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        FileWriter out = null;
        try {
            out = new FileWriter(this.file);
            out.write(this.getText());
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
        logger.finer("\u7de8\u96c6\u5185\u5bb9\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + this.file);
    }
}

