/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.gui.ThreadBrowser;

public class PreviewDialog
extends J2Dialog {
    private final ThreadBrowser browser;
    private final Label remoteTime;

    public PreviewDialog(J2Component parent, Thread thread, Response res) throws IOException {
        super(parent, 67696);
        this.setTitle("\u66f8\u304d\u8fbc\u307f\u30d7\u30ec\u30d3\u30e5\u30fc");
        Composite panel = this.getMessagePane();
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 5;
        panel.setLayout(layout);
        this.browser = new ThreadBrowser(panel, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 200;
        this.browser.setLayoutData(gd);
        String host = thread.getBoard().getURI().getHost();
        this.remoteTime = new Label(panel, 131072);
        gd = new GridData(768);
        this.remoteTime.setLayoutData(gd);
        this.remoteTime.setToolTipText("\u66f8\u304d\u8fbc\u307f\u5148\u306e\u30b5\u30fc\u30d0 " + host + " \u306e\u73fe\u5728\u6642\u523b\u3067\u3059 (\u00b1500ms\u7a0b\u5ea6\u306e\u8aa4\u5dee\u304c\u3042\u308a\u307e\u3059)\u3002" + "\u5b9f\u969b\u306e\u66f8\u304d\u8fbc\u307f\u6642\u523b\u306f\u3053\u308c\u306b\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u9045\u5ef6\u3084\u30b5\u30fc\u30d0\u9045\u5ef6\u306a\u3069\u3092\u52a0\u7b97\u3057\u305f\u6642\u523b\u3068\u306a\u308a\u307e\u3059\u3002");
        this.setOptionIcon(null);
        this.setOptions(new Object[]{J2Dialog.Option.OK, J2Dialog.Option.CANCEL});
        this.setDefaultOption((Object)J2Dialog.Option.OK);
        ArrayList<Response> list = new ArrayList<Response>();
        list.add(res);
        this.browser.showBaseHTML();
        this.browser.setThread(thread);
        this.browser.addResponse(list);
        GUI.schedule((GUI.SWTTimerTask)new RemoteTimeUpdator(host), 0L);
    }

    private class RemoteTimeUpdator
    extends GUI.SWTTimerTask {
        private final String host;
        private final DateFormat df = new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss");

        public RemoteTimeUpdator(String host) {
            this.host = host;
        }

        @Override
        public void asyncExec() {
            if (PreviewDialog.this.remoteTime.isDisposed()) {
                return;
            }
            UserAgent ua = UserAgent.getDefault();
            Long diff = ua.getTimeDifference(this.host);
            if (diff == null) {
                PreviewDialog.this.remoteTime.setText("----/--/--(-) --:--:--");
                return;
            }
            long time = System.currentTimeMillis() + diff;
            Date serverDate = new Date(time);
            PreviewDialog.this.remoteTime.setText(this.df.format(serverDate));
            RemoteTimeUpdator task = new RemoteTimeUpdator(this.host);
            Calendar serverCal = Calendar.getInstance();
            serverCal.setTime(serverDate);
            serverCal.set(14, 0);
            serverCal.add(13, 1);
            Date next = new Date(serverCal.getTimeInMillis() - diff);
            GUI.schedule((GUI.SWTTimerTask)task, next);
        }
    }
}

