/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.gui.J2WorkerListener;
import org.koiroha.jive2ch.util.TextUtil;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.RemoteBoardUpdateWorker;
import org.koiroha.jive2ch.worker.Worker;

public class NextThreadSearchDialog
extends J2Dialog {
    private static final Logger logger = Logger.getLogger(NextThreadSearchDialog.class.getName());
    private final Thread thread;
    private final Label message;
    private final Button exec;
    private final Button done;
    private final org.eclipse.swt.widgets.List candidate;
    private final List<Thread> list = new ArrayList<Thread>();
    private Thread selectedNextThread = null;

    public NextThreadSearchDialog(J2Component parent, Thread thread) {
        super(parent);
        this.setTitle("\u6b21\u30b9\u30ec\u691c\u7d22");
        this.thread = thread;
        Composite panel = this.getMessagePane();
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout(layout);
        this.message = new Label(panel, 0);
        this.message.setText(thread.getTitle() + "\u306e\u6b21\u30b9\u30ec\u3092\u691c\u7d22\u3057\u307e\u3059");
        GridData gd = new GridData(768);
        this.message.setLayoutData(gd);
        this.candidate = new org.eclipse.swt.widgets.List(panel, 2564);
        this.candidate.setEnabled(false);
        gd = new GridData(1808);
        this.candidate.setLayoutData(gd);
        this.candidate.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                NextThreadSearchDialog.this.done.setEnabled(NextThreadSearchDialog.this.candidate.getSelectionIndex() >= 0);
            }
        });
        Object[] options = new Object[]{"\u691c\u7d22\u958b\u59cb", "\u30b9\u30ec\u30c3\u30c9\u8868\u793a", J2Dialog.Option.CANCEL};
        this.setOptions(options);
        this.setOptionAvailable(options[0], false);
        this.setDefaultOption(options[0]);
        this.exec = this.getOptionButton(options[0]);
        this.exec.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                NextThreadSearchDialog.this.execute();
            }
        });
        this.done = this.getOptionButton(options[1]);
        this.done.setEnabled(false);
    }

    public Thread getSelectedNextThread() {
        if (this.getSelectedOption() == null || this.getSelectedOption() == J2Dialog.Option.CANCEL) {
            return null;
        }
        return this.selectedNextThread;
    }

    @Override
    public void close() {
        int index = this.candidate.getSelectionIndex();
        if (index >= 0) {
            this.selectedNextThread = this.list.get(index);
        }
        super.close();
    }

    private void execute() {
        this.message.setText(this.thread.getBoard().getName() + "\u677f\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...");
        this.candidate.removeAll();
        this.list.clear();
        this.exec.setEnabled(false);
        this.candidate.setEnabled(false);
        Board board = this.thread.getBoard();
        List<Thread> existing = Collections.emptyList();
        RemoteBoardUpdateWorker worker = new RemoteBoardUpdateWorker(board, existing, false, true);
        PropertyChangeListener safe1 = GUI.wrapSWTInvoke(this.app, PropertyChangeListener.class);
        worker.addPropertyChangeListener(safe1);
        worker.addListener(GUI.wrapSWTInvoke(new Listener(), Worker.Listener.class));
        Launcher.start(worker);
    }

    private List<Thread> filterNextThread(List<Thread> list) {
        String literal;
        String t1 = this.thread.getTitle();
        t1 = TextUtil.toSearchString(t1);
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(t1);
        StringBuilder buffer = new StringBuilder();
        int begin = 0;
        while (m.find()) {
            literal = Pattern.quote(t1.substring(begin, m.start()));
            buffer.append(literal);
            buffer.append("\\d+");
            begin = m.end();
        }
        literal = Pattern.quote(t1.substring(begin));
        buffer.append(literal);
        buffer.append(".*");
        String pattern = buffer.toString();
        logger.finer("\u6b21\u30b9\u30ec\u4e00\u81f4\u30d1\u30bf\u30fc\u30f3: " + pattern);
        ArrayList<Thread> filter = new ArrayList<Thread>();
        for (Thread t : list) {
            String t2;
            if (t.sameAs(this.thread) || !(t2 = TextUtil.toSearchString(t.getTitle())).matches(pattern)) continue;
            filter.add(t);
        }
        return filter;
    }

    private class Listener
    extends J2WorkerListener<Thread, Icon> {
        @Override
        public void processing(List<Thread> value) {
            value = NextThreadSearchDialog.this.filterNextThread(value);
            for (Thread t : value) {
                NextThreadSearchDialog.this.candidate.add(t.getTitle() + " (" + t.getResponseCount() + ")");
                NextThreadSearchDialog.this.list.add(t);
            }
        }

        @Override
        public void done(Icon ret) {
            NextThreadSearchDialog.this.exec.setEnabled(true);
            NextThreadSearchDialog.this.candidate.setEnabled(true);
            if (NextThreadSearchDialog.this.candidate.getItemCount() == 0) {
                NextThreadSearchDialog.this.message.setText("\u6b21\u30b9\u30ec\u5019\u88dc\u306f\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
            } else {
                NextThreadSearchDialog.this.message.setText("\u6b21\u30b9\u30ec\u5019\u88dc\u304c" + NextThreadSearchDialog.this.candidate.getItemCount() + "\u500b\u898b\u4ed8\u304b\u308a\u307e\u3057\u305f");
            }
        }

        @Override
        public void error(Throwable ex) {
            NextThreadSearchDialog.this.exec.setEnabled(true);
            super.error(ex);
        }
    }
}

