/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Dialog;

public class MessageDialog
extends J2Dialog {
    private static final int MESSAGE_WIDTH = 320;
    private Label message = null;
    private Label show = null;
    private Text desc = null;

    public MessageDialog() {
        super(Display.getDefault(), 67680);
        this.initialize();
    }

    public MessageDialog(Composite parent) {
        super(parent, 67680);
        this.initialize();
    }

    private void initialize() {
        Composite panel = this.getMessagePane();
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 5;
        panel.setLayout(layout);
        this.message = new Label(panel, 2048);
        this.message.setFont(GUI.deriveStyle(this.message.getFont(), 1));
        GridData gd = new GridData(768);
        gd.widthHint = 320;
        gd.minimumWidth = 320;
        this.message.setLayoutData(gd);
        this.show = new Label(panel, 0);
        this.show.setToolTipText("\u8a73\u7d30");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.show.setLayoutData(gd);
        this.desc = new Text(panel, 2818);
        this.desc.setFont(GUI.deriveFontSize(this.desc, 0.98f));
        this.desc.setTabs(2);
        this.desc.setEditable(false);
        this.desc.addKeyListener(GUI.DEFAULT_KEY_LISTENER);
        gd = new GridData(1808);
        gd.widthHint = 320;
        this.desc.setLayoutData(gd);
        this.show.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                MessageDialog.this.setDescriptionVisible(!MessageDialog.this.desc.isVisible());
            }
        });
        this.setOptionIcon(GUI.ICON_ERROR_DIALOG);
        this.setOptions(new Object[]{J2Dialog.Option.OK});
        this.setDefaultOption((Object)J2Dialog.Option.OK);
        this.setMessage(null);
        this.setDescription(null);
        this.setDescriptionVisible(false);
    }

    public void setMessage(String message) {
        if (!this.message.isDisposed()) {
            if (message == null) {
                this.message.setText(" ");
                GridData gd = new GridData(768);
                gd.heightHint = 0;
                this.message.setLayoutData(gd);
                this.message.setVisible(false);
            } else {
                this.message.setText(message);
                GridData gd = new GridData(768);
                gd.heightHint = -1;
                this.message.setLayoutData(gd);
                this.message.setVisible(true);
            }
        }
    }

    public void setDescription(String desc) {
        if (desc != null) {
            this.desc.setText(desc);
            this.show.setVisible(true);
        } else {
            this.desc.setText("");
            this.show.setVisible(false);
        }
    }

    public void setStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        this.setDescription(sw.toString());
    }

    public void setDescriptionVisible(boolean visible) {
        this.desc.setVisible(visible);
        GridData gd = (GridData)this.desc.getLayoutData();
        if (visible) {
            gd.heightHint = 120;
            this.show.setImage(GUI.ICON_NODE_COLLAPSE);
        } else {
            gd.heightHint = 0;
            this.show.setImage(GUI.ICON_NODE_EXPAND);
        }
        this.getShell().pack();
    }

    @Override
    public void open() {
        this.getDisplay().beep();
        super.open();
    }
}

