/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.util.IO;

public class FavouriteDialog
extends J2Dialog {
    private static final Logger logger = Logger.getLogger(FavouriteDialog.class.getName());
    private final File dir;
    private final Text name;
    private final Label msg;
    private final Button ok;
    private String input = null;

    public FavouriteDialog(J2Component parent, File dir) {
        super(parent);
        this.dir = dir;
        try {
            IO.mkdir(dir);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u63b2\u793a\u677f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + dir, ex);
        }
        this.setTitle("\u304a\u6c17\u306b\u5165\u308a\u30b0\u30eb\u30fc\u30d7");
        Composite panel = this.getMessagePane();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout(layout);
        this.name = new Text(panel, 2052);
        this.name.setLayoutData(new GridData(768));
        this.msg = new Label(panel, 0);
        this.msg.setText("\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.msg.setLayoutData(new GridData(768));
        this.setOptions(new Object[]{J2Dialog.Option.OK, J2Dialog.Option.CANCEL});
        this.setDefaultOption((Object)J2Dialog.Option.OK);
        this.ok = this.getOptionButton((Object)J2Dialog.Option.OK);
        this.ok.setEnabled(false);
        this.name.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                FavouriteDialog.this.verify(text);
            }
        });
    }

    @Override
    protected void onClose(Object option) {
        if (option == J2Dialog.Option.OK) {
            this.input = this.name.getText();
        }
    }

    public String getNewName() {
        return this.input;
    }

    private void verify(String text) {
        File dir = new File(this.dir, text);
        logger.finest(text + ": " + dir);
        try {
            if (text.length() == 0) {
                this.ok.setEnabled(false);
                this.msg.setText("\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
            } else if (!dir.getParentFile().equals(this.dir)) {
                this.ok.setEnabled(false);
                this.msg.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u6307\u5b9a\u51fa\u6765\u307e\u305b\u3093");
            } else if (dir.exists()) {
                this.ok.setEnabled(false);
                this.msg.setText("\u65e2\u306b\u540c\u3058\u540d\u524d\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5b58\u5728\u3057\u307e\u3059");
            } else if (dir.createNewFile()) {
                this.ok.setEnabled(true);
                dir.delete();
                this.msg.setText("");
            } else {
                this.ok.setEnabled(false);
                this.msg.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093");
            }
        }
        catch (IOException ex) {
            this.ok.setEnabled(false);
            this.msg.setText(ex.getMessage());
        }
    }
}

