/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.util.AWT;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class BoardPropertyDialog
extends J2Dialog
implements PropertyChangeListener {
    private final Board board;
    private Label icon = null;
    private CLabel dirSize;

    public BoardPropertyDialog(J2Component parent, Board board) {
        super(parent, 67696);
        this.board = board;
        this.setTitle(board.getName());
        Composite panel = this.getMessagePane();
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 5;
        panel.setLayout(layout);
        TabFolder tab = new TabFolder(panel, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        tab.setLayoutData(gd);
        this.initBasic(tab);
        this.initSetting(tab);
        this.setOptionIcon(null);
        this.setOptions(new Object[]{J2Dialog.Option.OK});
        this.setDefaultOption((Object)J2Dialog.Option.OK);
        board.addPropertyChangeListener(this);
        this.getShell().addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                BoardPropertyDialog.this.board.removePropertyChangeListener(BoardPropertyDialog.this);
            }
        });
    }

    private void initBasic(TabFolder tab) {
        GridData gd = null;
        TabItem item = new TabItem(tab, 0);
        Composite cmp = new Composite(tab, 0);
        item.setControl(cmp);
        item.setText("\u57fa\u672c");
        cmp.setLayout(BoardPropertyDialog.newGridLayout(2));
        Properties settings = this.board.getSettings();
        this.icon = new Label(cmp, 2048);
        gd = new GridData();
        gd.heightHint = 20;
        gd.widthHint = 20;
        gd.verticalSpan = 2;
        gd.verticalAlignment = 128;
        this.icon.setImage(this.board.getIcon().getImage(16));
        this.icon.setLayoutData(gd);
        CLabel title = new CLabel(cmp, 0);
        title.setFont(GUI.deriveFontSize(title, 1.4f));
        if (settings != null) {
            title.setText(settings.getProperty("BBS_TITLE", this.board.getName()));
        } else {
            title.setText(this.board.getName());
        }
        gd = new GridData(768);
        title.setLayoutData(gd);
        Link ib = new Link(cmp, 0);
        ib.setText("<a href=\"change\" title=\"\u63b2\u793a\u677f\u306e\u30a2\u30a4\u30b3\u30f3\u3092\u5909\u66f4\u3057\u307e\u3059\u3002\">\u5909\u66f4</a>  <a href=\"reset\" title=\"\u63b2\u793a\u677f\u306e\u30a2\u30a4\u30b3\u30f3\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u306b\u623b\u3057\u307e\u3059\u3002\">\u30ea\u30bb\u30c3\u30c8</a>");
        ib.setFont(GUI.deriveFontSize(ib, 0.8f));
        gd = new GridData(768);
        ib.setLayoutData(gd);
        ib.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if ("change".equals(e.text)) {
                    BoardPropertyDialog.this.setBoardIcon();
                } else if ("reset".equals(e.text)) {
                    BoardPropertyDialog.this.resetBoardIcon();
                }
            }
        });
        Group group = new Group(cmp, 16);
        group.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        group.setLayout(new GridLayout(2, false));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData(gd);
        Button drive = new Button(group, 0x800008);
        drive.setImage(Resource.loadImage(this.getDisplay(), "drive-harddisk.png"));
        gd = new GridData();
        gd.verticalSpan = 2;
        drive.setLayoutData(gd);
        drive.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                BoardPropertyDialog.this.openDirectory();
            }
        });
        CLabel dir = new CLabel(group, 0);
        dir.setText(this.board.getDirectory().toString());
        dir.setToolTipText(this.board.getDirectory().toString());
        gd = new GridData(768);
        gd.widthHint = 250;
        dir.setLayoutData(gd);
        this.dirSize = new CLabel(group, 0);
        this.dirSize.setText("");
        this.dirSize.setLayoutData(new GridData(768));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                BoardPropertyDialog.this.updateDirectorySize();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void initSetting(TabFolder tab) {
        Properties prop = this.board.getSettings();
        if (prop == null) {
            return;
        }
        TabItem item = new TabItem(tab, 0);
        Table table = new Table(tab, 65536);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 100;
        table.setLayoutData(gd);
        item.setControl(table);
        item.setText("\u8a2d\u5b9a");
        item.setToolTipText("\u3053\u306e\u63b2\u793a\u677f\u306eSETTING.TXT\u306e\u5185\u5bb9");
        TableColumn col = new TableColumn(table, 16384);
        col.setText("\u540d\u524d");
        col.setWidth(200);
        col = new TableColumn(table, 16384);
        col.setText("\u5024");
        col.setWidth(300);
        ArrayList<String> keys = new ArrayList<String>();
        for (Object o : prop.keySet()) {
            keys.add(o.toString());
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String k = (String)keys.get(i);
            String v = prop.getProperty(k);
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, k);
            ti.setText(1, v);
        }
    }

    private void openDirectory() {
        Program.launch(this.board.getDirectory().toString());
    }

    private void updateDirectorySize() {
        File dir = this.board.getDirectory();
        long size = 0L;
        int count = 0;
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (!file[i].isFile()) continue;
            size += file[i].length();
            if (++count % 100 != 0) continue;
            this.updateDirectorySize(count, size);
        }
        this.updateDirectorySize(count, size);
    }

    private void updateDirectorySize(final int count, final long sz) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NumberFormat nf = NumberFormat.getNumberInstance();
                if (!BoardPropertyDialog.this.dirSize.isDisposed()) {
                    BoardPropertyDialog.this.dirSize.setText(nf.format(count) + "\u30d5\u30a1\u30a4\u30eb\u3001" + nf.format(sz) + "B");
                    BoardPropertyDialog.this.dirSize.getParent().layout();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBoardIcon() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(new String[]{"*.jpg;*.png;*.gif", "*.*"});
        dialog.setFilterNames(new String[]{"\u753b\u50cf\u30d5\u30a1\u30a4\u30eb", "\u5168\u3066\u306e\u30d5\u30a1\u30a4\u30eb"});
        dialog.setFilterPath(Config.getDefault().getExportDirectory().getAbsolutePath());
        String filename = dialog.open();
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        RollbackOutputStream out = null;
        try {
            byte[] binary = AWT.getImage(file.toURI().toURL(), 16, 16);
            out = new RollbackOutputStream(this.board.getCustomIconFile());
            IO.copy(new ByteArrayInputStream(binary), out);
            IO.close(out);
        }
        catch (IOException ex) {
            BoardPropertyDialog.fatal(ex);
        }
        finally {
            IO.close(out);
        }
        this.board.resetIcon();
    }

    private void resetBoardIcon() {
        if (!BoardPropertyDialog.confirm("\u63b2\u793a\u677f\u30a2\u30a4\u30b3\u30f3\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u306b\u623b\u3057\u307e\u3059\u304b?", "\u30a2\u30a4\u30b3\u30f3\u306e\u30ea\u30bb\u30c3\u30c8")) {
            return;
        }
        try {
            IO.delete(this.board.getCustomIconFile());
        }
        catch (IOException ex) {
            BoardPropertyDialog.fatal(ex);
        }
        this.board.resetIcon();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("icon")) {
            this.icon.setImage(this.board.getIcon().getImage(16));
        }
    }
}

