/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.gui.J2WorkerListener;
import org.koiroha.jive2ch.worker.BBSMenuUpdateWorker;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.Worker;

public class BBSMenuUpdateDialog
extends J2Dialog
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(BBSMenuUpdateDialog.class.getName());
    private final File localFile;
    private final Text url;
    private final ProgressBar prog;
    private List<Category> categories = null;

    public BBSMenuUpdateDialog(J2Component parent, String u, File localFile, String msg) {
        super(parent, 67680);
        this.localFile = localFile;
        Composite panel = this.getMessagePane();
        panel.setLayout(new GridLayout(1, false));
        Label label = new Label(panel, 0);
        label.setText(msg);
        this.url = new Text(panel, 2052);
        this.url.setText(u);
        this.url.setLayoutData(new GridData(768));
        this.prog = new ProgressBar(panel, 2048);
        this.prog.setLayoutData(new GridData(768));
        Object[] options = new Object[]{"\u66f4\u65b0\u958b\u59cb", J2Dialog.Option.CANCEL};
        this.setTitle("BBS\u30e1\u30cb\u30e5\u30fc\u306e\u66f4\u65b0");
        this.setOptions(options);
        this.setDefaultOption(options[0]);
        this.setOptionAvailable(options[0], false);
        final Button ok = this.getOptionButton(options[0]);
        final Button cancel = this.getOptionButton(options[1]);
        this.url.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                try {
                    new URL(BBSMenuUpdateDialog.this.url.getText());
                    ok.setEnabled(true);
                }
                catch (MalformedURLException ex) {
                    ok.setEnabled(false);
                }
            }
        });
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                logger.finer("BBS\u30e1\u30cb\u30e5\u30fc\u3092\u66f4\u65b0\u3057\u3066\u3044\u307e\u3059...: " + BBSMenuUpdateDialog.this.url.getText());
                ok.setEnabled(false);
                cancel.setEnabled(false);
                BBSMenuUpdateDialog.this.asyncExec();
            }
        });
        this.moveCenterOfDisplay();
    }

    public List<Category> getCategoryList() {
        return this.categories;
    }

    private void asyncExec() {
        URL url = null;
        try {
            url = new URL(this.url.getText());
        }
        catch (MalformedURLException ex) {
            logger.log(Level.WARNING, "\u4e0d\u6b63\u306aURL\u3067\u5b9f\u884c\u304c\u8a66\u307f\u3089\u308c\u307e\u3057\u305f: " + this.url.getText(), ex);
            return;
        }
        this.categories = new ArrayList<Category>();
        BBSMenuUpdateWorker worker = new BBSMenuUpdateWorker(url, this.localFile);
        worker.addListener(GUI.wrapSWTInvoke(new J2WorkerListener<Category, Object>(){

            @Override
            public void processing(List<Category> value) {
                BBSMenuUpdateDialog.this.categories.addAll(value);
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                BBSMenuUpdateDialog.this.propertyChange(e);
            }

            @Override
            public void done(Object result) {
                BBSMenuUpdateDialog.this.close();
            }

            @Override
            public void error(Throwable ex) {
                super.error(ex);
                BBSMenuUpdateDialog.this.close();
            }
        }, Worker.Listener.class));
        Launcher.start(worker);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        logger.finest("propertyChange(" + e.getPropertyName() + "," + e.getOldValue() + " -> " + e.getNewValue() + ")");
        if (this.prog.isDisposed()) {
            return;
        }
        if (e.getPropertyName().equals("progress")) {
            this.prog.setSelection((Integer)e.getNewValue());
        } else if (e.getPropertyName().equals("minimum")) {
            this.prog.setMinimum((Integer)e.getNewValue());
        } else if (e.getPropertyName().equals("maximum")) {
            int max = ((Number)e.getNewValue()).intValue();
            if (max == Integer.MAX_VALUE) {
                this.prog.setState(4);
                this.prog.setMaximum(Integer.MAX_VALUE);
            } else if (max == 0x7FFFFFFE) {
                this.prog.setState(4);
                this.prog.setSelection(0);
                this.prog.setMaximum(0);
                this.prog.setMinimum(0);
            } else {
                this.prog.setState(0);
                this.prog.setMaximum(max);
            }
        }
    }
}

