/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui.dialog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.util.AADB;

public class AAPrefDialog
extends J2Dialog {
    private static final Logger logger = Logger.getLogger(AAPrefDialog.class.getName());
    private final AADB aadb;
    private final Tree tagTree;
    private final CTabFolder aaList;
    private ToolItem delButton = null;

    public AAPrefDialog(J2Component parent, AADB ad) {
        super(parent, 1200);
        this.getShell().setAlpha(230);
        this.setDefaultClose(false);
        this.aadb = ad;
        Composite root = this.getMessagePane();
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        root.setLayout(layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 280;
        root.setLayoutData(gd);
        this.createMenuBar(root);
        this.createToolbar(root);
        SashForm sash = new SashForm(root, 256);
        sash.setLayoutData(new GridData(1808));
        this.tagTree = new Tree(sash, 2052);
        this.updateTree();
        this.tagTree.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AAPrefDialog.this.onSelectTag();
            }
        });
        Display display = sash.getDisplay();
        this.aaList = new CTabFolder(sash, 128);
        this.aaList.setSelectionBackground(new Color[]{display.getSystemColor(32), display.getSystemColor(31)}, new int[]{90}, true);
        this.aaList.setSelectionForeground(display.getSystemColor(30));
        this.aaList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int i = AAPrefDialog.this.aaList.getSelectionIndex();
                AAPrefDialog.this.delButton.setEnabled(i >= 0);
                CTabItem item = AAPrefDialog.this.aaList.getSelection();
                if (item != null) {
                    ((Control)item.getData("name")).setFocus();
                }
            }
        });
        sash.setWeights(new int[]{100, 300});
        new GUI.ResizeWeight(sash, 0.0, 1.0);
        this.setTitle("AA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9");
        this.setOptions(new Object[]{J2Dialog.Option.OK});
        this.setDefaultOption((Object)J2Dialog.Option.OK);
        this.setDefaultOption(null);
    }

    @Override
    public void close() {
        this.closeAllTabs();
        try {
            this.app.aadb.save();
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
        super.close();
    }

    private void updateTree() {
        TreeItem[] is = this.tagTree.getSelection();
        HashSet<String> selected = new HashSet<String>();
        for (int i = 0; i < is.length; ++i) {
            selected.add(((AADB.Tag)is[i].getData()).getCanonicalName());
        }
        HashSet<String> expand = new HashSet<String>();
        for (TreeItem i : this.tagTree.getItems()) {
            if (!i.getExpanded()) continue;
            expand.add(((AADB.Tag)i.getData()).getCanonicalName());
        }
        logger.finest("\u958b\u304b\u308c\u3066\u3044\u308b\u30ce\u30fc\u30c9: " + expand);
        for (TreeItem i : this.tagTree.getItems()) {
            i.dispose();
        }
        List<AADB.Tag> tags = this.aadb.getTags();
        for (AADB.Tag t : tags) {
            TreeItem item = new TreeItem(this.tagTree, 0);
            item.setText(t.getName());
            item.setData(t);
            for (AADB.Tag c : t.getChild()) {
                this.createAATreeItem(item, c, expand, selected);
            }
            if (expand.contains(t.getCanonicalName())) {
                item.setExpanded(true);
            }
            if (!selected.contains(t.getCanonicalName())) continue;
            this.tagTree.setSelection(item);
        }
    }

    private void onSelectTag() {
        TreeItem[] ti;
        boolean tagChanged = this.closeAllTabs();
        if (tagChanged) {
            this.updateTree();
        }
        if ((ti = this.tagTree.getSelection()) == null || ti.length == 0) {
            return;
        }
        AADB.Tag tag = (AADB.Tag)ti[0].getData();
        try {
            List<AADB.AA> aas = this.aadb.getAA(tag.getCanonicalName());
            this.openTabs(aas);
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
    }

    private void newAA() {
        try {
            AADB.AA aa = this.aadb.createAA();
            aa.setName("\u65b0\u898fAA");
            ArrayList<String> tags = new ArrayList<String>();
            TreeItem[] ti = this.tagTree.getSelection();
            if (ti != null && ti.length > 0) {
                String tag = ((AADB.Tag)ti[0].getData()).getCanonicalName();
                tags.add(tag);
            } else {
                tags.add("\u672a\u5206\u985e");
            }
            aa.setTags(tags);
            this.openTabs(Arrays.asList(aa));
            this.updateTree();
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
    }

    private void deleteAA() {
        CTabItem item = this.aaList.getSelection();
        int index = this.aaList.getSelectionIndex();
        if (item == null) {
            return;
        }
        AADB.AA aa = (AADB.AA)item.getData();
        if (!AAPrefDialog.confirm(aa.getName() + "\u3092\u524a\u9664\u3057\u307e\u3059\u304b?", "\u524a\u9664\u306e\u78ba\u8a8d")) {
            return;
        }
        this.aadb.delete(aa);
        try {
            this.aadb.save();
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
        item.dispose();
        if (this.aaList.getItemCount() > index) {
            this.aaList.setSelection(index);
        } else if (this.aaList.getItemCount() > 0) {
            this.aaList.setSelection(this.aaList.getItemCount() - 1);
        }
        this.updateTree();
    }

    private void openTabs(List<AADB.AA> aas) {
        for (int i = 0; i < aas.size(); ++i) {
            AADB.AA aa = aas.get(i);
            CTabItem item = this.createView(aa);
            if (i != 0) continue;
            this.aaList.setSelection(item);
            this.delButton.setEnabled(true);
        }
    }

    private boolean closeAllTabs() {
        boolean tagChanged = false;
        for (int i = 0; i < this.aaList.getItemCount(); ++i) {
            tagChanged = this.saveTab(i) || tagChanged;
        }
        for (CTabItem t : this.aaList.getItems()) {
            ((AADB.AA)t.getData()).flush();
            t.dispose();
        }
        this.delButton.setEnabled(false);
        try {
            this.aadb.save();
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
        return tagChanged;
    }

    private boolean saveTab(int index) {
        List<String> src;
        CTabItem t = this.aaList.getItem(index);
        AADB.AA aa = (AADB.AA)t.getData();
        Text text = (Text)t.getData("text");
        Text name = (Text)t.getData("name");
        Text tags = (Text)t.getData("tags");
        ArrayList<String> ts = new ArrayList<String>(Arrays.asList(tags.getText().split("\\s*,\\s*")));
        boolean tagChanged = !AADB.tagsEquals(ts, src = aa.getTags());
        try {
            aa.setName(name.getText());
            aa.setTags(ts);
            aa.setAA(text.getText());
            this.aadb.save();
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
        t.setText(name.getText());
        return tagChanged;
    }

    private CTabItem createView(AADB.AA aa) {
        Composite parent = new Composite(this.aaList, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout(layout);
        Label label = new Label(parent, 0);
        label.setText("\u540d\u524d");
        Text name = new Text(parent, 2052);
        name.setText(aa.getName());
        name.setLayoutData(new GridData(768));
        name.setToolTipText("\u3053\u306eAA\u306e\u540d\u524d\u3067\u3059.\u30e1\u30cb\u30e5\u30fc\u3092\u51fa\u3057\u305f\u3068\u304d\u306b\u8868\u793a\u3055\u308c\u307e\u3059.");
        List<String> tg = aa.getTags();
        Collections.sort(tg);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < tg.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(tg.get(i));
        }
        label = new Label(parent, 0);
        label.setText("\u30bf\u30b0");
        Text tags = new Text(parent, 2052);
        tags.setFont(GUI.deriveFontSize(tags, 0.9f));
        tags.setText(buffer.toString());
        tags.setLayoutData(new GridData(768));
        tags.setToolTipText("\u3053\u306eAA\u306e\u30bf\u30b0\u3067\u3059\u3002\u30b3\u30f3\u30de\u3067\u533a\u5207\u3063\u3066\u8907\u6570\u306e\u30bf\u30b0\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u3059\u3002\u30b9\u30e9\u30c3\u30b7\u30e5'/'\u3092\u4f7f\u7528\u3059\u308b\u3068\u968e\u5c64\u5316\u3067\u304d\u307e\u3059\u3002");
        label = new Label(parent, 0);
        label.setText("AA");
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        label.setLayoutData(gd);
        Text text = new Text(parent, 2818);
        text.setFont(GUI.getAAFont());
        try {
            text.setText(aa.getAA());
        }
        catch (IOException ex) {
            AAPrefDialog.fatal(ex);
        }
        text.setLayoutData(new GridData(1808));
        text.setToolTipText("\u30a2\u30b9\u30ad\u30fc\u30a2\u30fc\u30c8\u306e\u672c\u6587\u3067\u3059.");
        CTabItem item = new CTabItem(this.aaList, 0);
        item.setControl(parent);
        item.setData(aa);
        item.setData("name", name);
        item.setData("text", text);
        item.setData("tags", tags);
        String title = aa.getName();
        item.setText(title);
        return item;
    }

    private void createAATreeItem(TreeItem parent, AADB.Tag tag, Set<String> expand, Set<String> selected) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(tag.getName());
        item.setData(tag);
        for (AADB.Tag c : tag.getChild()) {
            this.createAATreeItem(item, c, expand, selected);
        }
        if (expand.contains(tag.getCanonicalName())) {
            item.setExpanded(true);
        }
        if (selected.contains(tag.getCanonicalName())) {
            this.tagTree.setSelection(item);
        }
    }

    private void createToolbar(Composite root) {
        ToolBar toolbar = new ToolBar(root, 0x800108);
        toolbar.setLayoutData(new GridData(768));
        ToolItem create = new ToolItem(toolbar, 8);
        create.setImage(Resource.loadImage(this.getDisplay(), "address-book-new.png"));
        create.setToolTipText("\u65b0\u3057\u3044AA\u3092\u767b\u9332\u3057\u307e\u3059");
        create.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AAPrefDialog.this.newAA();
            }
        });
        this.delButton = new ToolItem(toolbar, 8);
        this.delButton.setImage(Resource.loadImage(this.getDisplay(), "user-trash.png"));
        this.delButton.setToolTipText("\u9078\u629e\u3055\u308c\u3066\u3044\u308bAA\u3092\u524a\u9664\u3057\u307e\u3059");
        this.delButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AAPrefDialog.this.deleteAA();
            }
        });
        this.delButton.setEnabled(false);
    }

    private void createMenuBar(Composite root) {
        Menu menubar = new Menu(root.getShell(), 2);
        root.getShell().setMenuBar(menubar);
        MenuItem item = new MenuItem(menubar, 64);
        item.setText("\u7de8\u96c6");
        Menu menu = new Menu(menubar);
        item.setMenu(menu);
        item = new MenuItem(menu, 8);
        item.setText("\u4fdd\u5b58(&S)");
        item.setAccelerator(Platform.META | 0x53);
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int i = AAPrefDialog.this.aaList.getSelectionIndex();
                if (i >= 0 && AAPrefDialog.this.saveTab(i)) {
                    AAPrefDialog.this.updateTree();
                }
                try {
                    AAPrefDialog.this.aadb.save();
                }
                catch (IOException ex) {
                    J2Component.fatal(ex);
                }
            }
        });
    }
}

