/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.client.UserAgentEvent;
import org.koiroha.jive2ch.client.UserAgentListener;
import org.koiroha.jive2ch.event.Jive2chAdapter;
import org.koiroha.jive2ch.event.Jive2chEvent;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.Jive2chFrame;
import org.koiroha.jive2ch.util.TextUtil;
import org.koiroha.jive2ch.util.ThreadFilter;

class ToolPanel
extends J2Component {
    private final Label icon;
    private final Text search;
    private final CCombo url;
    private final ProgressBar progress;
    private GUI.SWTTimerTask searchTask = null;
    private final Image ICON_IDLE = Resource.loadImage(this.getDisplay(), "network-idle.png");
    private final Image ICON_RECEIVE = Resource.loadImage(this.getDisplay(), "network-receive.png");
    private final Image ICON_TRANSMIT = Resource.loadImage(this.getDisplay(), "network-transmit.png");
    private final Image ICON_RECEIVE_TRANSMIT = Resource.loadImage(this.getDisplay(), "network-transmit-receive.png");
    private final Image ICON_OFFLINE = Resource.loadImage(this.getDisplay(), "network-error.png");

    public ToolPanel(Jive2chFrame frame) {
        super(frame, 0);
        this.setLayout(ToolPanel.newGridLayout(4, 5, 0, false));
        Display d = this.getDisplay();
        ToolBar toolbar = new ToolBar(this, 0);
        toolbar.setLayoutData(new GridData());
        int keyStroke = Platform.META | 0x20000 | 0x52;
        ToolItem item = new ToolItem(toolbar, 8);
        item.setImage(Resource.loadImage(d, "view-refresh.png"));
        item.setToolTipText("\u8868\u793a\u4e2d\u306e\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u3092\u30ea\u30ed\u30fc\u30c9\u3057\u307e\u3059 (" + Platform.getPlatform().getKeyStrokeLabel(keyStroke) + ")");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ToolPanel.this.getAppFrame().refreshThreads();
            }
        });
        this.url = new CCombo(this, 0x800800);
        this.url.setLayoutData(new GridData(768));
        this.url.addKeyListener(GUI.DEFAULT_KEY_LISTENER);
        this.url.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    ToolPanel.this.getAppFrame().show(ToolPanel.this.getURL(), "_blank");
                }
            }
        });
        this.search = new Text(this, 640);
        GridData gd = new GridData();
        gd.widthHint = 120;
        this.search.setLayoutData(gd);
        this.search.addKeyListener(GUI.DEFAULT_KEY_LISTENER);
        this.search.addFocusListener(GUI.DEFAULT_FOCUS_LISTENER);
        this.search.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                ToolPanel.this.search();
            }
        });
        Composite cmp = new Composite(this, 0);
        cmp.setLayout(ToolPanel.newGridLayout());
        this.icon = new Label(cmp, 0);
        this.icon.setSize(22, 22);
        gd = new GridData(1808);
        gd.heightHint = 22;
        gd.widthHint = 22;
        this.icon.setLayoutData(gd);
        this.icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                ToolPanel.this.getAppFrame().setOffline(!ToolPanel.this.getAppFrame().isOffline());
            }
        });
        this.progress = new ProgressBar(cmp, 0);
        gd = new GridData();
        gd.widthHint = 22;
        gd.heightHint = 4;
        this.progress.setLayoutData(gd);
        UserAgent.getDefault().addUserAgentListener(GUI.wrapSWTInvoke(new UserAgentListener(){

            @Override
            public void connecting(UserAgentEvent e) {
                UserAgent ua = e.getUserAgent();
                if (ua.getReceiveCount() > 0 && ua.getTransmitCount() > 0) {
                    ToolPanel.this.icon.setImage(ToolPanel.this.ICON_RECEIVE_TRANSMIT);
                } else if (ua.getReceiveCount() > 0) {
                    ToolPanel.this.icon.setImage(ToolPanel.this.ICON_RECEIVE);
                } else if (ua.getTransmitCount() > 0) {
                    ToolPanel.this.icon.setImage(ToolPanel.this.ICON_TRANSMIT);
                } else {
                    ToolPanel.this.setOffline(Config.getDefault().isOfflineMode());
                }
            }
        }, UserAgentListener.class));
        this.app.addDispatchListner(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ToolPanel.this.propertyChange(evt);
            }
        });
        frame.addJive2chListener(new Jive2chAdapter(){

            @Override
            public void boardSelected(Jive2chEvent e) {
                ToolPanel.this.setSearchWord("");
            }

            @Override
            public void threadSelected(Jive2chEvent e) {
                Thread thread = e.getThread();
                if (thread != null) {
                    ToolPanel.this.setURL(thread.getBrowserURI().toString());
                } else {
                    ToolPanel.this.setURL("");
                }
            }

            @Override
            public void generalURLSelected(Jive2chEvent e) {
                String url = e.getURL();
                if (url != null) {
                    ToolPanel.this.setURL(url);
                } else {
                    ToolPanel.this.setURL("");
                }
            }
        });
        Config.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("offlineMode")) {
                    ToolPanel.this.setOffline(Config.getDefault().isOfflineMode());
                }
            }
        });
        this.setOffline(Config.getDefault().isOfflineMode());
    }

    public void setURL(String url) {
        this.url.setText(url);
    }

    public String getURL() {
        String u = this.url.getText().trim();
        this.url.setText(u);
        return u;
    }

    public void setOffline(boolean offline) {
        if (offline) {
            this.icon.setImage(this.ICON_OFFLINE);
        } else {
            this.icon.setImage(this.ICON_IDLE);
        }
    }

    public void forcusSearch() {
        this.search.setFocus();
    }

    public void setSearchWord(String word) {
        this.search.setText(word);
    }

    private void search() {
        GUI.SWTTimerTask task = this.searchTask;
        if (task != null) {
            task.cancel();
            this.searchTask = null;
        }
        this.searchTask = new GUI.SWTTimerTask(this.getDisplay()){

            @Override
            public void asyncExec() {
                ToolPanel.this.searchAsync();
                if (ToolPanel.this.searchTask == this) {
                    ToolPanel.this.searchTask = null;
                }
            }
        };
        GUI.schedule(this.searchTask, 200L);
    }

    private void searchAsync() {
        assert (GUI.isEventDispatchThread());
        String text = this.search.getText();
        ThreadFilter filter = ThreadFilter.DENY_ALL;
        final String s = TextUtil.toSearchString(text);
        if (s.length() > 0) {
            filter = new ThreadFilter(){

                @Override
                public boolean accept(Thread thread) {
                    return TextUtil.toSearchString(thread.getTitle()).indexOf(s) >= 0;
                }
            };
        }
        this.getAppFrame().setThreadFilter(filter);
    }

    private void propertyChange(PropertyChangeEvent e) {
        if (!this.progress.isDisposed()) {
            if (e.getPropertyName().equals("progress")) {
                this.progress.setSelection((Integer)e.getNewValue());
            } else if (e.getPropertyName().equals("minimum")) {
                this.progress.setMinimum((Integer)e.getNewValue());
            } else if (e.getPropertyName().equals("maximum")) {
                int max = (Integer)e.getNewValue();
                if (max < 0) {
                    this.progress.setState(4);
                    this.progress.setMaximum(1);
                    this.progress.setSelection(1);
                } else {
                    this.progress.setState(0);
                    this.progress.setMaximum(max);
                }
            }
        }
    }
}

