/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.AboneException;
import org.koiroha.jive2ch.client.InvalidDatException;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2MultiPane;
import org.koiroha.jive2ch.gui.J2WorkerListener;
import org.koiroha.jive2ch.gui.ThreadBrowser;
import org.koiroha.jive2ch.gui.dialog.MessageDialog;
import org.koiroha.jive2ch.gui.popup.PopupManager;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.ResponseUpdateWorker;
import org.koiroha.jive2ch.worker.Worker;

public class ThreadViewer
extends J2Component {
    private static final Logger logger = Logger.getLogger(ThreadViewer.class.getName());
    private static final Timer AUTORELOAD_TIMER = new Timer("AutoReload Timer", true);
    private String name = null;
    private String title = "";
    private Pointer pointer = Pointer.compile("1,50L");
    private final J2MultiPane parent;
    private final ThreadBrowser browser;
    public final Toolbar toolbar;
    private ResponseUpdateWorker worker = null;
    private final PopupManager popupManager;

    public ThreadViewer(J2MultiPane pane, Composite parent) {
        super(parent, 0);
        this.parent = pane;
        this.setLayout(ThreadViewer.newGridLayout(1, 2, 2, false));
        this.toolbar = new Toolbar();
        this.browser = new ThreadBrowser(this, 2048);
        this.browser.setExternalURLEnabled(false);
        this.browser.setLayoutData(new GridData(1808));
        this.popupManager = new PopupManager(this, this.browser);
        this.browser.showBaseHTML();
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                ThreadViewer.this.toolbar.setAutoReload(false);
            }
        });
        this.browser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("title")) {
                    ThreadViewer.this.setTitle((String)evt.getNewValue());
                }
            }
        });
    }

    public String getViewName() {
        return this.name;
    }

    public void setViewName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        String newValue = title;
        this.title = title;
        this.firePropertyChange("title", oldValue, newValue);
    }

    public void stop() {
        this.toolbar.setAutoReload(false);
    }

    @Override
    public void destroy() {
        this.popupManager.closeAll();
        super.destroy();
    }

    public J2MultiPane getMultiPane() {
        return this.parent;
    }

    public Thread getThread() {
        return this.browser.getThread();
    }

    public void setThread(Thread thread) throws IOException {
        Thread oldValue = this.getThread();
        Thread newValue = thread;
        this.popupManager.closeAll();
        this.browser.setThread(thread);
        this.firePropertyChange("thread", oldValue, newValue);
    }

    public void setPointer(Pointer ptr) {
        this.pointer = ptr;
        this.reload(RefreshMode.REDRAW_ONLY);
    }

    public String getPageURL() {
        Thread thread = this.getThread();
        if (thread == null) {
            return this.browser.getBrowser().getUrl();
        }
        return thread.getBrowserURI().toString();
    }

    public void resetNGWord() {
        Thread thread = this.browser.getThread();
        if (thread != null) {
            for (Response res : thread.getResponse()) {
                res.setNG(Config.getDefault().isNG(res));
            }
        }
    }

    public void reload(RefreshMode mode) {
        logger.finest("reload(" + (Object)((Object)mode) + ")");
        this.cancelUpdate();
        this.popupManager.closeAll();
        Thread thread = this.browser.getThread();
        try {
            if (thread == null) {
                logger.finer("\u30b9\u30ec\u30c3\u30c9\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                this.browser.clearPage();
                return;
            }
            if (thread.isArchived()) {
                mode = RefreshMode.LOCAL_RELOAD;
            }
            boolean local = false;
            boolean remote = false;
            switch (mode) {
                case REDRAW_ONLY: {
                    this.browser.showBaseHTML();
                    List<Response> list = thread.getResponse();
                    list = this.pointer.pickup(list);
                    this.browser.addResponse(list);
                    if (list.size() > 0) {
                        this.jump(list.get(list.size() - 1).getNumber());
                    }
                    logger.finer((Object)((Object)mode) + ": \u30da\u30fc\u30b8\u306eHTML\u3092\u518d\u63cf\u5199\u3057\u307e\u3057\u305f");
                    return;
                }
                case LOCAL_RELOAD: {
                    this.browser.clearPage();
                    thread.uncharge();
                    local = true;
                    remote = false;
                    logger.finer((Object)((Object)mode) + ": \u5168\u30ec\u30b9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f");
                    break;
                }
                case RESUME: {
                    if (!thread.isKidoku()) {
                        this.browser.clearPage();
                        mode = RefreshMode.FORCE;
                        local = false;
                    } else if (this.browser.getResponseCount() == 0 || !thread.isCharged()) {
                        this.browser.clearPage();
                        thread.uncharge();
                        local = true;
                    } else {
                        this.browser.clearNewMark();
                        logger.finer((Object)((Object)mode) + ": \u5168New\u30de\u30fc\u30af\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f");
                        local = false;
                    }
                    remote = true;
                    break;
                }
                case FORCE: {
                    this.browser.clearPage();
                    thread.deleteLocalCache();
                    local = false;
                    remote = true;
                }
            }
            boolean resume = mode == RefreshMode.RESUME;
            this.worker = new ResponseUpdateWorker(thread, resume, this.pointer, local, remote);
            this.worker.addPropertyChangeListener(GUI.wrapSWTInvoke(this.app, PropertyChangeListener.class));
            this.worker.addListener(GUI.wrapSWTInvoke(new Listener(this.worker), Worker.Listener.class));
            Launcher.start(this.worker);
            this.toolbar.stop.setEnabled(true);
        }
        catch (IOException ex) {
            ThreadViewer.fatal(ex);
        }
    }

    public void show(URI uri) throws IOException {
        logger.finest("show(" + uri + ")");
        Thread thread = this.getThread(uri);
        if (thread != null) {
            logger.finer("\u30b9\u30ec\u30c3\u30c9\u3092\u8868\u793a\u3057\u3066\u3044\u307e\u3059: " + uri + " -> " + thread);
            thread.addPropertyChangeListener(GUI.wrapSWTInvoke(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("title")) {
                        ThreadViewer.this.setTitle((String)evt.getNewValue());
                    }
                }
            }, PropertyChangeListener.class));
            this.browser.setExternalURLEnabled(false);
            this.setThread(thread);
            this.reload(RefreshMode.RESUME);
            return;
        }
        logger.finer("\u4e00\u822c\u30da\u30fc\u30b8\u3092\u8868\u793a\u3057\u3066\u3044\u307e\u3059: " + uri);
        this.setThread(null);
        this.browser.setExternalURL(uri.toString());
    }

    private Thread getThread(URI uri) throws IOException {
        Service svc = Service.getService(uri);
        if (svc == null) {
            return null;
        }
        uri = svc.getDataURI(uri);
        URI boardUri = svc.getBoardURI(uri);
        String fileName = svc.getFileName(uri);
        Pointer pointer = svc.getResponsePointer(uri);
        if (pointer == null) {
            pointer = Pointer.compile("1,50L");
        }
        for (Category cat : this.app.getCategoryList()) {
            for (Board b : cat.getBoards()) {
                if (!b.getURI().equals(boardUri)) continue;
                return svc.createThread(b, fileName, "NONAME", 1);
            }
        }
        return null;
    }

    private void cancelUpdate() {
        assert (GUI.isEventDispatchThread());
        ResponseUpdateWorker worker = this.worker;
        if (worker != null) {
            worker.cancel();
            try {
                worker.getResult();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void jump(int num) {
        assert (num >= 1);
        this.browser.execute("document.location.hash=\"num" + num + "\";");
    }

    private void initFavouriteMenu(Menu menu, final Thread thread) {
        for (Board b : this.app.favourite.getBoards()) {
            final LocalBoard board = (LocalBoard)b;
            final boolean contains = board.contains(thread);
            MenuItem mi = new MenuItem(menu, 32);
            mi.setText(board.getName());
            mi.setSelection(contains);
            mi.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (contains) {
                        board.removeThread(thread);
                    } else {
                        board.addThread(thread);
                    }
                }
            });
        }
        if (menu.getItemCount() > 0) {
            new MenuItem(menu, 2);
        }
        MenuItem item = new MenuItem(menu, 8);
        item.setText("\u304a\u6c17\u306b\u5165\u308a\u30b0\u30eb\u30fc\u30d7\u306e\u4f5c\u6210");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ThreadViewer.this.getAppFrame().createFavourite();
            }
        });
    }

    private class AutoReload
    extends TimerTask {
        private AutoReload() {
        }

        @Override
        public void run() {
            ThreadViewer.this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadViewer.this.reload(RefreshMode.RESUME);
                }
            });
        }
    }

    private class Listener
    extends J2WorkerListener<String, Integer> {
        private final Performance pfm = Performance.start();
        private final ResponseUpdateWorker updateWorker;

        public Listener(ResponseUpdateWorker worker) {
            this.updateWorker = worker;
        }

        @Override
        public void processing(List<String> value) {
            logger.finer("\u30ec\u30b9\u3092\u8868\u793a\u3057\u3066\u3044\u307e\u3059...");
            ThreadViewer.this.browser.addResponseHTML(value.get(0), Integer.parseInt(value.get(1)));
        }

        @Override
        public void done(Integer jump) {
            ThreadViewer.this.toolbar.stop.setEnabled(false);
            ThreadViewer.this.worker = null;
            if (ThreadViewer.this.toolbar.autoScrollItem.getSelection()) {
                assert (jump >= 0) : jump;
                ThreadViewer.this.jump(jump);
            }
            ThreadViewer.this.browser.getThread().setNew(false);
            this.pfm.mark("\u30ec\u30b9\u8868\u793a\u51e6\u7406\u306e\u5b8c\u4e86");
        }

        @Override
        public void error(Throwable ex) {
            ThreadViewer.this.toolbar.stop.setEnabled(false);
            ThreadViewer.this.worker = null;
            this.pfm.mark("\u30ec\u30b9\u8868\u793a\u51e6\u7406\u306e\u5b8c\u4e86");
            if (ex instanceof InvalidDatException) {
                Thread thread = this.updateWorker.getThread();
                MessageDialog dialog = new MessageDialog(ThreadViewer.this);
                dialog.setTitle("\u30b9\u30ec\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
                dialog.setMessage("\u300c" + thread.getTitle() + "\u300d\u306fDAT\u843d\u3061\u3057\u305f\u3063\u307d\u3044\u3067\u3059");
                dialog.setDescription(((InvalidDatException)ex).getDescription());
                dialog.setDescriptionVisible(true);
                dialog.open();
                return;
            }
            if (ex instanceof AboneException) {
                this.handleAbone();
                return;
            }
            super.error(ex);
        }

        private void handleAbone() {
            if (!J2Component.confirm("\u30b9\u30ec\u30c3\u30c9\u306b\u3042\u307c\u30fc\u3093\u304c\u767a\u751f\u3057\u305f\u304bDAT\u843d\u3061\u3057\u3066\u3057\u307e\u3063\u305f\u3088\u3046\u3067\u3059\u3002\n\u518d\u53d6\u5f97\u3057\u3066\u307f\u307e\u3059\u304b?", "\u518d\u53d6\u5f97\u306e\u78ba\u8a8d")) {
                return;
            }
            try {
                Thread thread = this.updateWorker.getThread();
                thread.setArchived(true);
                Launcher.start(this.updateWorker);
            }
            catch (IOException ex) {
                J2Component.fatal(ex);
            }
        }
    }

    public static enum RefreshMode {
        REDRAW_ONLY,
        LOCAL_RELOAD,
        RESUME,
        FORCE;

    }

    public class Toolbar
    extends Composite {
        private ToolItem stop;
        private AutoReload autoReloadTask;
        private ToolItem autoReloadItem;
        private ToolItem autoScrollItem;
        private ToolItem openEditing;
        private ToolItem rolloverPopup;
        private ToolItem ngWord;
        private ToolItem thumb;
        private ToolItem pluginExpand;

        private Toolbar() {
            super(ThreadViewer.this, 0);
            this.stop = null;
            this.autoReloadTask = null;
            this.autoScrollItem = null;
            this.openEditing = null;
            this.rolloverPopup = null;
            this.ngWord = null;
            this.thumb = null;
            this.pluginExpand = null;
            Display display = this.getDisplay();
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout(layout);
            this.setLayoutData(new GridData(768));
            final ToolBar toolbar = new ToolBar(this, 0x800000);
            toolbar.setLayoutData(new GridData(768));
            final Menu reloadPopup = new Menu(this.getShell(), 8);
            MenuItem forceReload = new MenuItem(reloadPopup, 8);
            forceReload.setText("\u518d\u8868\u793a");
            forceReload.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.reload(RefreshMode.LOCAL_RELOAD);
                }
            });
            MenuItem delLogReload = new MenuItem(reloadPopup, 8);
            delLogReload.setText("\u30ed\u30b0\u3092\u7834\u68c4\u3057\u3066\u30ea\u30ed\u30fc\u30c9");
            delLogReload.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.reload(RefreshMode.FORCE);
                }
            });
            Image image = Resource.loadImage(display, "Page_refresh.png");
            final ToolItem reload = new ToolItem(toolbar, 4);
            reload.setImage(image);
            reload.setToolTipText("\u30ea\u30ed\u30fc\u30c9");
            reload.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Rectangle bounds = reload.getBounds();
                        Point point = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                        reloadPopup.setLocation(point);
                        reloadPopup.setVisible(true);
                    } else {
                        ThreadViewer.this.reload(RefreshMode.RESUME);
                    }
                }
            });
            this.stop = new ToolItem(toolbar, 8);
            this.stop.setImage(Resource.loadImage(display, "Cancel.png"));
            this.stop.setToolTipText("\u51e6\u7406\u4e2d\u306e\u30ea\u30ed\u30fc\u30c9\u3092\u4e2d\u65ad\u3057\u307e\u3059");
            this.stop.setEnabled(false);
            this.stop.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.cancelUpdate();
                }
            });
            new ToolItem(toolbar, 2);
            this.autoReloadItem = new ToolItem(toolbar, 32);
            this.autoReloadItem.setImage(Resource.loadImage(display, "script_save.png"));
            this.autoReloadItem.setToolTipText("\u4e00\u5b9a\u6642\u9593\u304a\u304d\u306b\u30ea\u30ed\u30fc\u30c9\u3092\u884c\u3044\u307e\u3059");
            this.autoReloadItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    Toolbar.this.setAutoReload(Toolbar.this.autoReloadItem.getSelection());
                }
            });
            this.autoScrollItem = new ToolItem(toolbar, 32);
            this.autoScrollItem.setImage(Resource.loadImage(display, "Application_put.png"));
            this.autoScrollItem.setToolTipText("\u30ea\u30ed\u30fc\u30c9\u6642\u306b\u65b0\u7740\u30ec\u30b9\u3078\u30b8\u30e3\u30f3\u30d7\u3057\u307e\u3059");
            this.autoScrollItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.setAutoScroll(Toolbar.this.autoScrollItem.getSelection());
                }
            });
            ToolItem filter = new ToolItem(toolbar, 8);
            filter.setImage(Resource.loadImage(display, "Cog_edit.png"));
            filter.setToolTipText("\u30ec\u30b9\u30d5\u30a3\u30eb\u30bf");
            new ToolItem(toolbar, 2);
            final Menu showAllPopup = new Menu(this.getShell(), 8);
            final String[] ptr = new String[]{"1,1L", "1,50L", "1,100L", "1,250L", "1,500L", "1,1000L", null, "1-5", "1-20", "1-50", "1-100", "1-500", "1-1000"};
            String[] txt = new String[]{"\u6700\u65b01", "\u6700\u65b050", "\u6700\u65b0100", "\u6700\u65b0250", "\u6700\u65b0500", "\u6700\u65b01000", null, "5\u307e\u3067", "20\u307e\u3067", "50\u307e\u3067", "100\u307e\u3067", "500\u307e\u3067", "1000\u307e\u3067"};
            for (int i = 0; i < ptr.length; ++i) {
                if (ptr[i] == null) {
                    new MenuItem(showAllPopup, 2);
                    continue;
                }
                MenuItem mi = new MenuItem(showAllPopup, 8);
                mi.setText(txt[i]);
                final int j = i;
                mi.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        ThreadViewer.this.setPointer(Pointer.compile(ptr[j]));
                    }
                });
            }
            final ToolItem showAll = new ToolItem(toolbar, 4);
            showAll.setImage(Resource.loadImage(display, "Page_green.png"));
            showAll.setToolTipText("\u5168\u3066\u8868\u793a");
            showAll.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Rectangle bounds = showAll.getBounds();
                        Point point = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                        showAllPopup.setLocation(point);
                        showAllPopup.setVisible(true);
                    } else {
                        ThreadViewer.this.setPointer(Pointer.compile("1-"));
                    }
                }
            });
            final ToolItem favourite = new ToolItem(toolbar, 4);
            favourite.setImage(Resource.loadImage(display, "Star.png"));
            favourite.setToolTipText("\u3053\u306e\u30b9\u30ec\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u767b\u9332\u3057\u307e\u3059");
            favourite.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (ThreadViewer.this.getThread() == null) {
                        return;
                    }
                    Menu menu = new Menu(Toolbar.this.getShell(), 8);
                    ThreadViewer.this.initFavouriteMenu(menu, ThreadViewer.this.getThread());
                    Rectangle bounds = favourite.getBounds();
                    Point point = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                    menu.setLocation(point);
                    menu.setVisible(true);
                }
            });
            favourite.setEnabled(false);
            final ToolItem deleteLog = new ToolItem(toolbar, 8);
            deleteLog.setImage(GUI.ICON_TRASH);
            deleteLog.setToolTipText("\u3053\u306e\u30b9\u30ec\u306e\u30ed\u30b0\u3092\u524a\u9664\u3057\u307e\u3059");
            deleteLog.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    if (ThreadViewer.this.browser.getThread() != null) {
                        ThreadViewer.this.browser.getThread().deleteLocalCache();
                    }
                }
            });
            deleteLog.setEnabled(false);
            new ToolItem(toolbar, 2);
            ToolItem newTab = new ToolItem(toolbar, 8);
            newTab.setImage(Resource.loadImage(display, "Tab_add.png"));
            newTab.setToolTipText("\u65b0\u3057\u3044\u30bf\u30d6\u3092\u958b\u304d\u307e\u3059");
            newTab.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.openTab();
                }
            });
            this.openEditing = new ToolItem(toolbar, 32);
            this.openEditing.setImage(Resource.loadImage(display, "mail-message-new.png"));
            this.openEditing.setToolTipText("\u66f8\u304d\u8fbc\u307f\u3092\u8868\u793a\u3057\u307e\u3059");
            this.openEditing.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.setOpenEditing(Toolbar.this.openEditing.getSelection());
                }
            });
            new ToolItem(toolbar, 2);
            this.ngWord = new ToolItem(toolbar, 32);
            this.ngWord.setImage(Resource.loadImage(display, "face-smile.png"));
            this.ngWord.setToolTipText("NG\u30ef\u30fc\u30c9\u3092\u542b\u3080\u30b9\u30ec\u3092\u3042\u307c\u301c\u3093\u3057\u307e\u3059");
            this.ngWord.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.setNGWord(Toolbar.this.ngWord.getSelection());
                }
            });
            this.rolloverPopup = new ToolItem(toolbar, 32);
            this.rolloverPopup.setImage(Resource.loadImage(display, "comment_add.png"));
            this.rolloverPopup.setToolTipText("\u30ed\u30fc\u30eb\u30aa\u30fc\u30d0\u30fc\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002\u7121\u52b9\u306b\u3057\u305f\u5834\u5408\u306f " + Platform.getPlatform().getKeyStrokeLabel(Platform.META) + " \u30ad\u30fc\u3092\u62bc\u3057\u305f\u5834\u5408\u306e\u307f\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u3057\u307e\u3059\u3002");
            this.rolloverPopup.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.setRolloverPopup(Toolbar.this.rolloverPopup.getSelection());
                }
            });
            this.thumb = new ToolItem(toolbar, 32);
            this.thumb.setImage(Resource.loadImage(display, "image.gif"));
            this.thumb.setToolTipText("\u30ec\u30b9\u306b\u542b\u307e\u308c\u3066\u3044\u308b\u753b\u50cfURL\u3092\u30b5\u30e0\u30cd\u30fc\u30eb\u8868\u793a\u3057\u307e\u3059");
            this.thumb.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.setThumbnailEnabled(Toolbar.this.thumb.getSelection());
                }
            });
            ToolBar right = new ToolBar(this, 0);
            right.setLayoutData(new GridData());
            this.pluginExpand = new ToolItem(right, 32);
            this.pluginExpand.setImage(GUI.ICON_PLUGIN_EXPAND);
            this.pluginExpand.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ThreadViewer.this.parent.setPluginExpand(Toolbar.this.pluginExpand.getSelection());
                }
            });
            reload.setEnabled(false);
            ThreadViewer.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("thread")) {
                        Thread thread = (Thread)e.getNewValue();
                        reload.setEnabled(thread != null);
                        favourite.setEnabled(thread != null);
                        favourite.setSelection(ThreadViewer.this.app.favourite.isFavourite(thread));
                        deleteLog.setEnabled(thread != null);
                    }
                }
            });
        }

        public void setAutoReload(boolean autoReload) {
            logger.finer("setAutoReload(" + autoReload + ")");
            if (ThreadViewer.this.toolbar.autoReloadTask != null) {
                ThreadViewer.this.toolbar.autoReloadTask.cancel();
            }
            if (autoReload) {
                ThreadViewer.this.toolbar.autoReloadTask = new AutoReload();
                AUTORELOAD_TIMER.scheduleAtFixedRate((TimerTask)ThreadViewer.this.toolbar.autoReloadTask, 0L, 5000L);
            }
            if (!ThreadViewer.this.toolbar.autoReloadItem.isDisposed()) {
                ThreadViewer.this.toolbar.autoReloadItem.setSelection(autoReload);
            }
        }

        public void setAutoScrollButtonSelected(boolean selected) {
            this.autoScrollItem.setSelection(selected);
        }

        public void setOpenEditingButtonSelected(boolean selected) {
            this.openEditing.setSelection(selected);
        }

        public void setRolloverPopupButtonSelected(boolean selected) {
            this.rolloverPopup.setSelection(selected);
            ThreadViewer.this.popupManager.setRolloverPopup(selected);
        }

        public void setNGWordButtonSelected(boolean selected) {
            this.ngWord.setSelection(selected);
            ThreadViewer.this.reload(RefreshMode.REDRAW_ONLY);
        }

        public void setThumbnailButtonSelected(boolean selected) {
            this.thumb.setSelection(selected);
            ThreadViewer.this.reload(RefreshMode.REDRAW_ONLY);
        }

        public void setPluginExpandButtonSelected(boolean selected) {
            this.pluginExpand.setSelection(selected);
        }
    }
}

