/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2WorkerListener;
import org.koiroha.jive2ch.gui.Scrap;
import org.koiroha.jive2ch.util.MetaInfoEvent;
import org.koiroha.jive2ch.util.MetaInfoListener;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.ThreadFilter;
import org.koiroha.jive2ch.util.ThreadSorter;
import org.koiroha.jive2ch.worker.BoardUpdateWorker;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.LocalBoardUpdateWorker;
import org.koiroha.jive2ch.worker.RemoteBoardUpdateWorker;
import org.koiroha.jive2ch.worker.Worker;

class ThreadList
extends J2Component
implements MetaInfoListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ThreadList.class.getName());
    private Board board = null;
    private Table threads = null;
    private Comparator<Thread> sorter = ThreadSorter.SORTER[1];
    private ThreadFilter filter = ThreadFilter.DENY_ALL;
    private final MetaInfoListener safe1 = GUI.wrapSWTInvoke(this, MetaInfoListener.class);
    private final PropertyChangeListener safe2 = GUI.wrapSWTInvoke(this, PropertyChangeListener.class);
    private BoardUpdateWorker worker = null;

    public ThreadList(Composite parent) {
        super(parent, 0);
        SelectionAdapter sorter = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ThreadList.this.sort((TableColumn)e.getSource());
            }
        };
        this.threads = new Table(this, 67586);
        this.threads.setHeaderVisible(true);
        this.threads.setLayoutData(new GridData(1808));
        TableColumn tc = null;
        tc = new TableColumn(this.threads, 0x1000000);
        tc.setText("");
        tc.setWidth(20);
        tc.setResizable(false);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 131072);
        tc.setText("\u756a\u53f7");
        tc.setWidth(40);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 16384);
        tc.setText("\u30bf\u30a4\u30c8\u30eb");
        tc.setWidth(350);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 131072);
        tc.setText("\u30ec\u30b9");
        tc.setWidth(40);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 131072);
        tc.setText("\u65e2\u5f97\u30ec\u30b9");
        tc.setWidth(40);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 131072);
        tc.setText("\u52e2\u3044");
        tc.setWidth(60);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 16384);
        tc.setText("\u6700\u7d42\u8aad\u307f\u8fbc\u307f");
        tc.setWidth(110);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 16384);
        tc.setText("\u6700\u7d42\u66f8\u304d\u8fbc\u307f");
        tc.setWidth(110);
        tc = new TableColumn(this.threads, 16384);
        tc.setText("\u30b9\u30ec\u7acb\u3061");
        tc.setWidth(110);
        tc.addSelectionListener(sorter);
        tc = new TableColumn(this.threads, 16384);
        tc.setText("URL");
        tc.setWidth(200);
        tc.addSelectionListener(sorter);
        this.threads.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem i = (TableItem)e.item;
                ThreadList.this.getAppFrame().setThread((Thread)i.getData());
            }
        });
        this.threads.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                TableItem i;
                if (GUI.isLeftClick(e) && (i = ThreadList.this.threads.getItem(new Point(e.x, e.y))) != null) {
                    ThreadList.this.getAppFrame().setThread((Thread)i.getData());
                }
            }
        });
        this.threads.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GUI.isKeyStroke(e, Platform.META, 'A')) {
                    ThreadList.this.threads.selectAll();
                }
            }
        });
        this.setSortColumn(1, true);
        this.makePopup();
        DragSource ds = new DragSource(this.threads, 1);
        ds.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        ds.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragSetData(DragSourceEvent event) {
                logger.finest("dragSetData(" + event + ")");
                TableItem[] item = ThreadList.this.threads.getSelection();
                if (item == null || item.length == 0) {
                    event.detail = 0;
                    return;
                }
                Object[] data = new String[item.length];
                for (int i = 0; i < item.length; ++i) {
                    Thread thread = (Thread)item[i].getData();
                    data[i] = thread.getEntityFile().getAbsolutePath();
                }
                logger.finer("\u30d5\u30a1\u30a4\u30eb\u8ee2\u9001: " + Arrays.toString(data));
                event.data = data;
                event.detail = 1;
            }
        });
    }

    public void setBoard(Board board) {
        if (this.board == board) {
            this.reload(false, true);
            return;
        }
        this.board = board;
        String title = "Jive2ch";
        if (board != null) {
            title = board.getSettings().getProperty("BBS_TITLE");
            if (title == null) {
                title = board.getName();
            }
            title = title + " - " + "Jive2ch";
        }
        this.getAppFrame().setTitle(title);
        this.threads.clearAll();
        if (this.threads.getItemCount() > 0) {
            TableItem i = this.threads.getItem(0);
            this.threads.showItem(i);
        }
        this.select(-1);
        this.reload(true, true);
    }

    public boolean reload(boolean local, boolean remote) {
        if (this.board == null) {
            logger.finer("reload(): \u63b2\u793a\u677f\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return true;
        }
        BoardUpdateWorker worker = null;
        J2WorkerListener listener = null;
        if (this.board instanceof LocalBoard) {
            worker = new LocalBoardUpdateWorker((LocalBoard)this.board, !local);
            listener = local ? new EntireUpdateListener() : new OverrideUpdateListener();
        } else {
            List<Thread> existing = this.getThreadList();
            local = local || existing.size() == 0;
            worker = new RemoteBoardUpdateWorker(this.board, existing, local, remote);
            listener = new EntireUpdateListener();
        }
        worker.addPropertyChangeListener(GUI.wrapSWTInvoke(this.app, PropertyChangeListener.class));
        worker.addListener(GUI.wrapSWTInvoke(listener, Worker.Listener.class));
        this.takeOver(worker);
        return true;
    }

    private synchronized boolean takeOver(BoardUpdateWorker newWorker) {
        assert (GUI.isEventDispatchThread());
        BoardUpdateWorker oldWorker = this.worker;
        if (newWorker.sameAs(oldWorker)) {
            logger.finer("\u540c\u4e00\u306e\u63b2\u793a\u677f\u66f4\u65b0\u51e6\u7406\u304c\u65e2\u306b\u5b9f\u884c\u4e2d\u3067\u3059: " + newWorker);
            return false;
        }
        if (oldWorker != null) {
            oldWorker.cancel();
        }
        this.worker = newWorker;
        Launcher.start(newWorker);
        logger.finer("\u63b2\u793a\u677f\u66f4\u65b0\u51e6\u7406\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f: " + newWorker);
        return true;
    }

    private List<Thread> getThreadList() {
        ArrayList<Thread> t = new ArrayList<Thread>();
        for (TableItem i : this.threads.getItems()) {
            t.add((Thread)i.getData());
        }
        return t;
    }

    private Thread getSelectedThread() {
        TableItem[] i = this.threads.getSelection();
        if (i == null || i.length == 0) {
            return null;
        }
        return (Thread)i[0].getData();
    }

    public void sort() {
        this.updateSequence();
    }

    public void setFilter(ThreadFilter filter) {
        if (this.filter != filter) {
            this.filter = filter;
            this.updateSequence();
        }
    }

    private void updateSequence() {
        logger.finer("updateSequence()");
        ArrayList<Thread> list = new ArrayList<Thread>();
        for (TableItem item : this.threads.getItems()) {
            list.add((Thread)item.getData());
        }
        this.entireUpdate(list);
    }

    @Override
    public void init() {
        super.init();
        Scrap scrap = this.app.scrap.subscrap("list.thread");
        String sort = scrap.getString("sort", "1,UP");
        String idx = sort.replaceAll("(\\d+),.*", "$1");
        String dir = sort.replaceAll(".*,(.*)", "$1");
        try {
            this.setSortColumn(Integer.parseInt(idx), !dir.equalsIgnoreCase("down"));
        }
        catch (RuntimeException ex) {
            logger.warning("\u30b9\u30af\u30e9\u30c3\u30d7\u30c7\u30fc\u30bf\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059: " + sort);
        }
    }

    @Override
    public void destroy() {
        Scrap scrap = this.app.scrap.subscrap("list.thread");
        String sort = this.threads.indexOf(this.threads.getSortColumn()) + "," + (this.threads.getSortDirection() == 128 ? "UP" : "DOWN");
        scrap.setString("sort", sort);
        super.destroy();
    }

    private void init(TableItem item, Thread t) {
        DecimalFormat ef = new DecimalFormat("0.0");
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        Display display = item.getDisplay();
        Color color = display.getSystemColor(2);
        Font font = null;
        Image icon = null;
        if (t.isNew()) {
            color = display.getSystemColor(3);
        } else if (t.getCreated() != null) {
            long age = System.currentTimeMillis() - t.getCreated().getTime();
            if (age < 0L) {
                color = display.getSystemColor(15);
            } else if (age <= 86400000L) {
                color = new Color(display, 0, 60, 128);
            }
        }
        if (t.isKidoku()) {
            if (t.isArchived()) {
                color = display.getSystemColor(16);
                font = GUI.deriveStyle(this.threads, 2);
                icon = GUI.ICON_KIDOKU_THREAD;
            } else if (t.getResponseCount() > t.getAcquiredCount()) {
                font = GUI.deriveStyle(this.threads, 1);
                icon = GUI.ICON_KIDOKU_UPDATED_THREAD;
            } else {
                icon = GUI.ICON_KIDOKU_THREAD;
            }
        }
        item.setForeground(color);
        item.setFont(2, font);
        item.setFont(3, font);
        item.setFont(4, font);
        item.setImage(icon);
        String energy = "-";
        double e = t.getEnergy();
        if (!Double.isNaN(e)) {
            energy = ef.format(e);
        }
        String recent = "--/--/-- --:--";
        Date date = t.getRecentAccess();
        if (date != null) {
            recent = df.format(date);
        }
        String contribute = "--/--/-- --:--";
        date = t.getContributeDate();
        if (date != null) {
            contribute = df.format(date);
        }
        String create = "--/--/-- --:--";
        date = t.getCreated();
        if (date != null) {
            create = df.format(date);
        }
        item.setData(t);
        item.setText(0, "");
        item.setText(1, String.valueOf(t.getNumber()));
        item.setText(2, t.getTitle());
        item.setText(3, String.valueOf(t.getResponseCount()));
        item.setText(4, String.valueOf(t.getAcquiredCount()));
        item.setText(5, energy);
        item.setText(6, recent);
        item.setText(7, contribute);
        item.setText(8, create);
        item.setText(9, t.getBrowserURI().toString());
        t.removeMetaInfoListener(this.safe1);
        t.addMetaInfoListener(this.safe1);
        t.removePropertyChangeListener(this.safe2);
        t.addPropertyChangeListener(this.safe2);
    }

    private void itemUpdate(Thread thread) {
        TableItem[] item = this.threads.getItems();
        for (int i = 0; i < item.length; ++i) {
            assert (item[i].getData() instanceof Thread);
            if (!thread.sameAs((Thread)item[i].getData())) continue;
            this.init(item[i], thread);
            return;
        }
        logger.warning("\u5b58\u5728\u3057\u306a\u3044\u30b9\u30ec\u30c3\u30c9\u306e\u66f4\u65b0\u8981\u6c42\u304c\u51fa\u3055\u308c\u307e\u3057\u305f: " + thread.getTitle());
    }

    private void entireUpdate(List<Thread> list) {
        logger.finer("entierUpdate()");
        Performance pfm = Performance.start();
        ArrayList<Thread> primary = new ArrayList<Thread>();
        for (int i = 0; i < list.size(); ++i) {
            if (!this.filter.accept(list.get(i))) continue;
            primary.add(list.get(i));
            list.remove(i);
            --i;
        }
        Collections.sort(primary, this.sorter);
        Collections.sort(list, this.sorter);
        list.addAll(0, primary);
        pfm.mark("\u30b9\u30ec\u30c3\u30c9\u306e\u30bd\u30fc\u30c8\u5b8c\u4e86");
        ArrayList<Thread> selected = new ArrayList<Thread>();
        TableItem[] selectedItem = this.threads.getSelection();
        if (selectedItem != null && selectedItem.length > 0) {
            for (TableItem i : selectedItem) {
                selected.add((Thread)i.getData());
            }
        }
        ArrayList<Integer> nextSelected = new ArrayList<Integer>();
        TableItem[] item = this.threads.getItems();
        for (int i = 0; i < list.size(); ++i) {
            Color c;
            Thread t = list.get(i);
            TableItem it = null;
            if (i < item.length) {
                it = item[i];
                it.setData(t);
                this.init(it, t);
            } else {
                it = this.bind(t);
            }
            if (i % 2 == 1 && GUI.equals(c = it.getBackground(), this.threads.getItem(0).getBackground())) {
                int r = (int)((double)c.getRed() * 0.96);
                int g = (int)((double)c.getGreen() * 0.96);
                int b = c.getBlue() * 1;
                c = new Color(c.getDevice(), r, g, b);
                it.setBackground(c);
            }
            for (Thread sel : selected) {
                if (!t.getBoard().sameAs(sel.getBoard()) || !t.sameAs(sel)) continue;
                nextSelected.add(i);
            }
        }
        int count = this.threads.getItemCount();
        if (count > list.size()) {
            this.threads.remove(list.size(), count - 1);
        }
        int[] array = new int[nextSelected.size()];
        for (int i = 0; i < nextSelected.size(); ++i) {
            array[i] = (Integer)nextSelected.get(i);
        }
        this.select(array);
        pfm.mark("\u30b9\u30ec\u30c3\u30c9\u8868\u793a\u5b8c\u4e86: " + list.size() + "\u30b9\u30ec\u30c3\u30c9");
    }

    private void overrideUpdate(List<Thread> list) {
        logger.finer("overrideUpdate()");
        Performance pfm = Performance.start();
        block0: for (int j = 0; j < this.threads.getItemCount(); ++j) {
            TableItem item = this.threads.getItem(j);
            Thread t1 = (Thread)item.getData();
            for (int i = 0; i < list.size(); ++i) {
                Thread t2 = list.get(i);
                if (!t1.sameAs(list.get(i))) continue;
                t2.setNumber(t1.getNumber());
                item.setData(t2);
                this.init(item, t2);
                continue block0;
            }
        }
        pfm.mark("\u30b9\u30ec\u30c3\u30c9\u8868\u793a\u5b8c\u4e86: " + list.size() + "\u30b9\u30ec\u30c3\u30c9");
    }

    private TableItem bind(Thread t) {
        TableItem item = new TableItem(this.threads, 0);
        this.init(item, t);
        return item;
    }

    @Override
    public void metaInfoCommitted(MetaInfoEvent e) {
        Thread t = (Thread)e.getModifiedObject();
        this.itemUpdate(t);
        this.sort();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String n = e.getPropertyName();
        if (n.equals("kidoku")) {
            Thread t = (Thread)e.getSource();
            if (this.board instanceof LocalBoard && !((LocalBoard)this.board).contains(t)) {
                this.entireUpdate(((LocalBoard)this.board).getThreads());
            } else {
                this.itemUpdate(t);
                this.updateSequence();
            }
        } else if (n.equals("archived")) {
            Thread t = (Thread)e.getSource();
            this.itemUpdate(t);
            this.updateSequence();
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30d7\u30ed\u30d1\u30c6\u30a3 " + n + " \u306e\u5909\u66f4\u3067\u30b9\u30ec\u30c3\u30c9\u9805\u76ee\u306f\u66f4\u65b0\u3055\u308c\u307e\u305b\u3093");
        }
    }

    private void setSortColumn(int column, boolean asc) {
        this.sorter = ThreadSorter.SORTER[column];
        if (!asc) {
            this.sorter = Collections.reverseOrder(this.sorter);
        }
        TableColumn c = this.threads.getColumn(column);
        this.threads.setSortColumn(c);
        this.threads.setSortDirection(asc ? 128 : 1024);
    }

    private void sort(TableColumn column) {
        Table table = column.getParent();
        int index = table.indexOf(column);
        int dir = table.getSortDirection();
        dir = table.getSortColumn() != column ? 128 : (dir == 128 ? 1024 : 128);
        this.setSortColumn(index, dir == 128);
        List<Thread> t = this.getThreadList();
        this.entireUpdate(t);
    }

    private void select(int ... index) {
        this.threads.deselectAll();
        this.threads.select(index);
    }

    private void makePopup() {
        Menu popup = new Menu(this.threads);
        MenuItem item = new MenuItem(popup, 8);
        item.setText("\u3053\u306e\u30b9\u30ec\u30c3\u30c9\u3092\u65b0\u3057\u3044\u30bf\u30d6\u3067\u958b\u304f(&O)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread thread = ThreadList.this.getSelectedThread();
                if (thread != null) {
                    ThreadList.this.getAppFrame().openNewTab();
                    ThreadList.this.getAppFrame().setThread(thread);
                }
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("URL\u3092\u30b3\u30d4\u30fc(&C)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread thread = ThreadList.this.getSelectedThread();
                if (thread != null) {
                    String text = thread.getBrowserURI().toString();
                    GUI.copyToClipboard(text);
                }
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u30bf\u30a4\u30c8\u30eb\u3092\u30b3\u30d4\u30fc(&S)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread thread = ThreadList.this.getSelectedThread();
                if (thread != null) {
                    String text = thread.getTitle();
                    GUI.copyToClipboard(text);
                }
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u30bf\u30a4\u30c8\u30eb\u3068URL\u3092\u30b3\u30d4\u30fc(&T)");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread thread = ThreadList.this.getSelectedThread();
                if (thread != null) {
                    String uri = thread.getBrowserURI().toString();
                    String title = thread.getTitle();
                    GUI.copyToClipboard(title + "\n" + uri);
                }
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f(&B)...");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread thread = ThreadList.this.getSelectedThread();
                if (thread != null) {
                    ThreadList.this.getAppFrame().showBrowser(thread.getBrowserURI().toString());
                }
            }
        });
        item = new MenuItem(popup, 8);
        item.setText("\u30e1\u30e2\u3092\u5165\u529b(&M)...");
        item = new MenuItem(popup, 8);
        item.setText("\u30b9\u30ec\u30c3\u30c9\u3042\u307c\u301c\u3093(&E)");
        item = new MenuItem(popup, 8);
        item.setText("\u95a2\u9023\u30da\u30fc\u30b8\u3092\u958b\u304f(&R)");
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        item.setText("\u5b9a\u671f\u66f4\u65b0\u30c1\u30a7\u30c3\u30af\u5bfe\u8c61\u306b\u8ffd\u52a0(&A)");
        new MenuItem(popup, 258);
        item = new MenuItem(popup, 8);
        item.setText("\u30ed\u30b0\u3092\u524a\u9664(&D)");
        item.setImage(GUI.ICON_TRASH);
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread thread = ThreadList.this.getSelectedThread();
                if (thread != null) {
                    ThreadList.this.select(new int[]{-1});
                    thread.deleteLocalCache();
                }
            }
        });
        this.threads.setMenu(popup);
    }

    private class OverrideUpdateListener
    extends J2WorkerListener<Thread, Icon> {
        @Override
        public void processing(List<Thread> value) {
            ThreadList.this.overrideUpdate(value);
            ThreadList.this.sort();
        }

        @Override
        public void done(Icon icon) {
            ThreadList.this.worker = null;
        }

        @Override
        public void error(Throwable ex) {
            ThreadList.this.worker = null;
            super.error(ex);
        }
    }

    private class EntireUpdateListener
    extends J2WorkerListener<Thread, Icon> {
        private final Thread selected;

        public EntireUpdateListener() {
            this.selected = ThreadList.this.getSelectedThread();
        }

        @Override
        public void processing(List<Thread> value) {
            ThreadList.this.entireUpdate(value);
        }

        @Override
        public void done(Icon icon) {
            if (this.selected != null) {
                for (int i = 0; i < ThreadList.this.threads.getItemCount(); ++i) {
                    TableItem it = ThreadList.this.threads.getItem(i);
                    if (!((Thread)it.getData()).getFileName().equals(this.selected.getFileName())) continue;
                    ThreadList.this.threads.select(i);
                    ThreadList.this.threads.showSelection();
                    break;
                }
            }
            ThreadList.this.worker = null;
        }

        @Override
        public void error(Throwable ex) {
            ThreadList.this.worker = null;
            super.error(ex);
        }
    }
}

