/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.popup.PopupDisposeException;
import org.koiroha.jive2ch.util.Debug;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.Pointer;

public class ThreadBrowser
extends J2Component {
    private static final Logger logger = Logger.getLogger(ThreadBrowser.class.getName());
    private static final String INNER_HTML = "document.getElementById(\"content\").innerHTML";
    private String title = "";
    private final Type type;
    private int responseCount = 0;
    private Thread thread = null;
    private final Browser browser;
    private long callbackTimeout = 3000L;
    private boolean external = false;

    public ThreadBrowser(Composite cmp, int style) {
        super(cmp, 0);
        assert (this.app != null);
        this.setLayout(ThreadBrowser.newGridLayout());
        this.browser = new Browser(this, style);
        this.browser.setLayoutData(new GridData(1808));
        String t = this.browser.getBrowserType();
        this.type = t == null ? Type.UNKNOWN : (t.equalsIgnoreCase("ie") ? Type.IE : (t.equalsIgnoreCase("Safari") ? Type.SAFARI : Type.UNKNOWN));
        logger.fine("\u7d44\u307f\u8fbc\u307f\u30d6\u30e9\u30a6\u30b6: " + (Object)((Object)this.type) + " (" + t + ")");
        this.browser.addLocationListener(new LocationAdapter(){
            private boolean recursive = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changing(LocationEvent event) {
                block15: {
                    try {
                        URI uri = new URI(event.location);
                        if (this.recursive || Service.getService(uri) == null) break block15;
                        logger.finer("\u30cf\u30f3\u30c9\u30eb\u53ef\u80fd\u306aURI\u3092\u5185\u90e8\u51e6\u7406\u3078\u30d0\u30a4\u30d1\u30b9: " + uri);
                        this.recursive = true;
                        try {
                            ThreadBrowser.this.getAppFrame().show(event.location, null);
                        }
                        finally {
                            this.recursive = false;
                        }
                        event.doit = false;
                        return;
                    }
                    catch (URISyntaxException ex) {
                        logger.finest("URI\u3092\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093: " + ex);
                    }
                }
                if (ThreadBrowser.this.external) {
                    return;
                }
                if (event.location.equals("about:blank")) {
                    return;
                }
                if (event.location.lastIndexOf(35) >= 0) {
                    return;
                }
                if (event.location.startsWith("file:")) {
                    try {
                        URI u1 = new URI(event.location).normalize();
                        URI u2 = ThreadBrowser.this.app.repository.localTemplateFile.toURI().normalize();
                        if (u1.equals(u2)) {
                            return;
                        }
                    }
                    catch (URISyntaxException ex) {
                        logger.finer(ex.toString());
                    }
                    try {
                        String p1 = new URL(event.location).getPath();
                        String p2 = ThreadBrowser.this.app.repository.localTemplateFile.toURI().normalize().getPath();
                        logger.finest(p1 + " -> " + p2);
                        if (p2.endsWith(p1)) {
                            return;
                        }
                    }
                    catch (MalformedURLException ex) {
                        logger.finer(ex.toString());
                    }
                }
                event.doit = false;
                logger.finer("URL\u3078\u306e\u79fb\u52d5\u306f\u62d2\u5426\u3055\u308c\u307e\u3057\u305f: " + event.location);
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            @Override
            public void changed(TitleEvent event) {
                ThreadBrowser.this.setTitle(event.title);
            }
        });
        this.debugBrowser();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null || title.length() == 0) {
            title = "\u7121\u984c";
        }
        String oldValue = this.title;
        String newValue = title;
        this.title = title;
        this.firePropertyChange("title", oldValue, newValue);
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) throws IOException {
        if (this.thread == thread) {
            return;
        }
        if (this.thread != null) {
            this.thread.flush();
        }
        this.clearPage();
        this.thread = thread;
        if (thread != null && !thread.isCharged()) {
            thread.charge();
        }
        if (thread != null) {
            this.setExternalURLEnabled(false);
            this.setTitle(thread.getTitle());
        } else {
            this.setTitle("");
        }
    }

    @Override
    public void destroy() {
        if (!this.browser.isDisposed()) {
            logger.finest("destroy(" + this.browser.getUrl() + ")");
            this.browser.stop();
            this.browser.setText("");
        }
        super.destroy();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    public void setExternalURLEnabled(boolean enabled) {
        this.external = enabled;
    }

    public void setExternalURL(String url) {
        logger.finest("setExternalURL(" + url + ")");
        this.setExternalURLEnabled(true);
        this.showAndWait(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHTML(String html) {
        Debug.dump("setHTML()", "%s", html);
        File file = this.app.repository.localTemplateFile;
        FileOutputStream out = null;
        try {
            IO.mkdir(file.getParentFile());
            out = new FileOutputStream(file);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, IO.UTF8);
            w.write(html);
            ((Writer)w).flush();
            IO.close(out);
        }
        catch (IOException ex) {
            ThreadBrowser.fatal(ex);
            return;
        }
        finally {
            IO.close(out);
        }
        this.showAndWait(file.toURI().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAndWait(String url) {
        logger.finest("showAndWait(" + url + ")");
        Performance pfm = Performance.start();
        Watchdog watchdog = new Watchdog();
        this.browser.addProgressListener(watchdog);
        try {
            logger.finer("\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u5b8c\u4e86\u5f85\u6a5f\u4e2d...: " + url);
            this.browser.setUrl(url);
            this.responseCount = 0;
            Display display = this.browser.getDisplay();
            while (!watchdog.isCompleted()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (this.browser.isDisposed()) {
                throw new PopupDisposeException();
            }
        }
        finally {
            if (!this.browser.isDisposed()) {
                this.browser.removeProgressListener(watchdog);
            }
        }
        pfm.mark("HTML \u306e\u8868\u793a\u5b8c\u4e86: " + url);
    }

    public void showBaseHTML() {
        this.showBaseHTML(new HashMap<String, String>());
    }

    public void showBaseHTML(Map<String, String> param) {
        logger.finest("showBaseHTML(" + param + ")");
        InputStreamReader in = null;
        try {
            String html = this.app.skin.getThreadHTML(this.thread, param);
            this.setHTML(html);
            URL url = Resource.getResource("helper.js");
            in = new InputStreamReader(url.openStream(), IO.UTF8);
            StringWriter out = new StringWriter();
            IO.copy(in, out);
            this.browser.execute(out.toString());
        }
        catch (IOException ex) {
            try {
                throw new IllegalStateException("\u30ea\u30bd\u30fc\u30b9\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
    }

    public void addResponse(Pointer pointer) throws IOException {
        this.addResponse(pointer, new HashMap<String, String>());
    }

    public void addResponse(Pointer pointer, Map<String, String> param) throws IOException {
        List<Response> list = this.thread.getResponse();
        list = pointer.newSelector(list.size()).pickup(list, new ArrayList());
        this.addResponse(list, param);
    }

    public void addResponse(List<Response> list) throws IOException {
        this.addResponse(list, new HashMap<String, String>());
    }

    public void addResponse(List<Response> list, Map<String, String> param) throws IOException {
        String html = this.app.skin.getResponseHTML(list, param);
        this.addResponseHTML(html, list.size());
    }

    public void addResponseHTML(String html, int count) {
        this.responseCount += count;
        Performance pfm = Performance.start();
        String script = "document.getElementById(\"content\").innerHTML = document.getElementById(\"content\").innerHTML + " + ThreadBrowser.literal(html) + ";";
        this.execute(script);
        pfm.mark("\u30d6\u30e9\u30a6\u30b6\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u5b9f\u884c");
    }

    public void clearPage() {
        logger.finest("clearPage()");
        this.responseCount = 0;
        if (this.thread != null) {
            String script = "document.getElementById(\"content\").innerHTML = \"\";";
            this.execute(script);
        } else {
            this.showBaseHTML();
        }
    }

    public void clearNewMark() {
        this.execute("clear_all_new_mark();");
        for (Response r : this.thread.getResponse()) {
            r.setNew(false);
        }
        logger.finer("\u65b0\u7740\u30de\u30fc\u30af\u30af\u30ea\u30a2");
    }

    public void execute(String script) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c: " + script);
        }
        this.browser.execute("try{" + script + "}catch(e){alert(e);}");
    }

    public static String literal(CharSequence text) {
        StringBuilder buffer = new StringBuilder((int)((double)text.length() * 1.1));
        buffer.append('\"');
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block10;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block10;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isDefined(ch) && !Character.isISOControl(ch)) {
                        buffer.append(ch);
                        continue block10;
                    }
                    buffer.append("\\u" + String.format("%04d", ch));
                }
            }
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private void debugBrowser() {
        this.browser.addAuthenticationListener(new AuthenticationListener(){

            @Override
            public void authenticate(AuthenticationEvent event) {
                logger.finest("authenticate(" + event + ")");
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            @Override
            public void close(WindowEvent event) {
                logger.finest("Browser.close(" + event + ")");
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            @Override
            public void changed(LocationEvent event) {
                logger.finest("changed(" + event + ")");
            }

            @Override
            public void changing(LocationEvent event) {
                logger.finest("changing(" + event + ")");
            }
        });
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            @Override
            public void open(WindowEvent event) {
                logger.finest("open(" + event + ")");
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            @Override
            public void changed(ProgressEvent event) {
                logger.finest("changed(" + event + ")");
            }

            @Override
            public void completed(ProgressEvent event) {
                logger.finest("completed(" + event + ")");
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(){

            @Override
            public void changed(StatusTextEvent event) {
                logger.finest("changed(" + event + ")");
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            @Override
            public void changed(TitleEvent event) {
                logger.finest("changed(" + event + ")");
            }
        });
        this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            @Override
            public void hide(WindowEvent event) {
                logger.finest("hide(" + event + ")");
            }

            @Override
            public void show(WindowEvent event) {
                logger.finest("show(" + event + ")");
            }
        });
    }

    private static enum Type {
        IE,
        SAFARI,
        MOZILLA,
        UNKNOWN;

    }

    private class Watchdog
    extends ProgressAdapter {
        private final long start = System.currentTimeMillis();
        private boolean completed = false;

        private Watchdog() {
        }

        @Override
        public void completed(ProgressEvent event) {
            logger.finer("\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u5b8c\u4e86\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u78ba\u8a8d");
            this.completed = true;
        }

        public boolean isCompleted() {
            if (Math.abs(System.currentTimeMillis() - this.start) >= ThreadBrowser.this.callbackTimeout) {
                logger.fine("\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u5b8c\u4e86\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u306b\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f");
                return true;
            }
            return this.completed;
        }
    }
}

