/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class Scrap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Scrap.class.getName());
    private final File file;
    private final Properties prop;
    private final String prefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Scrap(File file) throws IOException {
        this.file = file;
        this.prop = new Properties();
        this.prefix = "";
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.prop.load(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IO.close(in);
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
    }

    private Scrap(Scrap parent, String prefix) {
        this.file = parent.file;
        this.prop = parent.prop;
        this.prefix = parent.prefix + prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        RollbackOutputStream out = null;
        try {
            out = new RollbackOutputStream(this.file);
            this.prop.store(out, "Jive2ch scrap file");
        }
        catch (IOException ex) {
            try {
                logger.log(Level.WARNING, "\u30b9\u30af\u30e9\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.file, ex);
            }
            catch (Throwable throwable) {
                IO.close(out);
                throw throwable;
            }
            IO.close(out);
        }
        IO.close(out);
    }

    public String getString(String name, String def) {
        return this.prop.getProperty(this.prefix + name, def);
    }

    public void setString(String name, String value) {
        this.prop.setProperty(this.prefix + name, value);
    }

    public boolean getBoolean(String name, boolean def) {
        String value = this.getString(name, null);
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    public void setBoolean(String name, boolean value) {
        this.setString(name, String.valueOf(value));
    }

    public int getInt(String name, int def) {
        long value = this.getLong(name, def);
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        logger.log(Level.WARNING, name + " \u306e\u5024 \"" + value + "\" \u306f int \u306e\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059");
        return def;
    }

    public void setInt(String name, int value) {
        this.setString(name, String.valueOf(value));
    }

    public long getLong(String name, long def) {
        String value = this.getString(name, null);
        if (value == null) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, name + " \u306e\u5024 \"" + value + "\" \u3092\u6570\u5024\u306b\u5909\u63db\u51fa\u6765\u307e\u305b\u3093", ex);
            return def;
        }
    }

    public void setLong(String name, long value) {
        this.setString(name, String.valueOf(value));
    }

    public Scrap subscrap(String prefix) {
        return new Scrap(this, prefix);
    }
}

