/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.dialog.MessageDialog;
import org.koiroha.jive2ch.plugin.PluginException;
import org.koiroha.jive2ch.plugin.PluginManager;
import org.koiroha.jive2ch.plugin.PluginStub;

public class PluginPanel
extends J2Component {
    private static final Logger logger = Logger.getLogger(PluginPanel.class.getName());
    private final PluginManager manager;
    private final CTabFolder tab;
    private final DnD dnd = new DnD();

    public PluginPanel(Composite parent) {
        super(parent, 0);
        File dir = this.app.repository.getPluginDirectory();
        this.manager = new PluginManager(this.getAppFrame(), dir);
        this.tab = new CTabFolder(this, 0);
        this.tab.setLayoutData(new GridData(1808));
        this.setDropTarget(this.tab);
        this.tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                if (GUI.isRightClick(e)) {
                    CTabItem i = PluginPanel.this.tab.getItem(new Point(e.x, e.y));
                    if (i != null) {
                        PluginPanel.this.tab.setSelection(i);
                    }
                    PluginPanel.this.showContextMenu(PluginPanel.this.tab.toDisplay(e.x, e.y), i);
                }
            }
        });
        DragSource ds = new DragSource(this.tab, 1);
        ds.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        ds.addDragListener(this.dnd);
        this.tab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                PluginPanel.this.manager.setSelectedTabItem(item);
            }
        });
    }

    @Override
    public void init() {
        super.init();
        this.manager.create(this.tab);
        List<Throwable> ex = this.manager.getSetupExceptions();
        if (ex.size() > 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            for (Throwable e : ex) {
                e.printStackTrace(pw);
            }
            pw.flush();
            MessageDialog dialog = new MessageDialog(this);
            dialog.setTitle("\u30d7\u30e9\u30b0\u30a4\u30f3\u8d77\u52d5\u30a8\u30e9\u30fc");
            dialog.setMessage("\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8d77\u52d5\u6642\u306b " + ex.size() + " \u500b\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            dialog.setDescription(sw.toString());
            dialog.setDescriptionVisible(true);
            dialog.open();
        }
    }

    @Override
    public void destroy() {
        this.manager.dispose();
        super.destroy();
    }

    public void setExpand(boolean expand) {
        if (expand) {
            this.manager.setSelectedTabItem(this.tab.getSelection());
        } else {
            this.manager.setSelectedTabItem(null);
        }
    }

    public void setDropTarget(Control control) {
        DropTarget dt = new DropTarget(control, 17);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener(this.dnd);
    }

    private void showContextMenu(Point p, CTabItem item) {
        final PluginStub stub = item != null ? (PluginStub)item.getData() : null;
        Menu menu = new Menu(this.tab);
        MenuItem inst = new MenuItem(menu, 8);
        inst.setText("\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u8ffd\u52a0");
        inst.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PluginPanel.this.install();
            }
        });
        if (stub != null) {
            MenuItem uninst = new MenuItem(menu, 8);
            uninst.setText("\"" + stub.getTitle() + "\" \u3092\u524a\u9664");
            uninst.setImage(GUI.ICON_TRASH);
            uninst.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    PluginPanel.this.uninstall(stub);
                }
            });
        }
        menu.setLocation(p.x, p.y);
        menu.setVisible(true);
    }

    public void install() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(new String[]{"*.j2p", "*"});
        dialog.setFilterNames(new String[]{"Jive2ch\u30d7\u30e9\u30b0\u30a4\u30f3 (*.j2p)", "\u5168\u3066\u306e\u30d5\u30a1\u30a4\u30eb"});
        dialog.setFilterPath(Config.getDefault().getExportDirectory().getAbsolutePath());
        dialog.open();
        String[] files = dialog.getFileNames();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = dialog.getFilterPath() + File.separator + files[i];
        }
        this.install(files);
    }

    public void install(String[] files) {
        logger.finest("install(" + Arrays.toString(files) + ")");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ArrayList<File> avail = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(files[i]);
            if (this.manager.isPluginArchive(file, true)) {
                avail.add(file);
                continue;
            }
            pw.println(file.getName() + " \u306f\u6709\u52b9\u306a\u30d7\u30e9\u30b0\u30a4\u30f3\u30a2\u30fc\u30ab\u30a4\u30d6\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        if (avail.size() == 0) {
            PluginPanel.messageBox("\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u53ef\u80fd\u306a\u30d7\u30e9\u30b0\u30a4\u30f3\u30a2\u30fc\u30ab\u30a4\u30d6\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3067\u3057\u305f", "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb", sw.toString());
            return;
        }
        if (!PluginPanel.confirm(avail.size() + "\u500b\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u307e\u3059\u304b?", "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb", sw.toString())) {
            logger.finer("\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306f\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
            return;
        }
        for (File file : avail) {
            try {
                this.manager.install(this.tab, file);
                pw.println(file.getName() + " \u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u307e\u3057\u305f");
            }
            catch (PluginException ex) {
                pw.println(file.getName() + " \u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                PluginPanel.fatal(ex);
            }
        }
    }

    public void uninstall() {
        CTabItem item = this.tab.getSelection();
        if (item == null) {
            return;
        }
        PluginStub stub = (PluginStub)item.getData();
        this.uninstall(stub);
    }

    public void uninstall(PluginStub stub) {
        logger.finest("uninstall(" + stub + ")");
        if (!PluginPanel.confirm("\u30d7\u30e9\u30b0\u30a4\u30f3 \"" + stub.getTitle() + "\" \u3092\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u307e\u3059\u304b?", "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb")) {
            logger.finer("\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306f\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
            return;
        }
        try {
            this.manager.uninstall(stub);
        }
        catch (IOException ex) {
            PluginPanel.fatal(ex);
        }
    }

    private CTabItem move(CTabItem item, CTabItem ref) {
        int current = this.tab.indexOf(item);
        ArrayList<CTabItem> list = new ArrayList<CTabItem>();
        list.add(item);
        if (ref != null) {
            for (int i = this.tab.indexOf(ref); i < this.tab.getItemCount(); ++i) {
                if (i == current) continue;
                list.add(this.tab.getItem(i));
            }
        }
        CTabItem selection = null;
        for (CTabItem i : list) {
            CTabItem newTab = new CTabItem(this.tab, 0);
            newTab.setText(i.getText());
            newTab.setImage(i.getImage());
            newTab.setToolTipText(i.getToolTipText());
            this.manager.setCTabItem(newTab, (PluginStub)i.getData());
            i.setControl(null);
            i.dispose();
            if (selection != null) continue;
            selection = newTab;
        }
        return selection;
    }

    private class DnD
    extends DropTargetAdapter
    implements DragSourceListener {
        private CTabItem item = null;

        private DnD() {
        }

        @Override
        public void dragStart(DragSourceEvent e) {
            logger.finest("dragStart(" + e + ")");
            this.item = PluginPanel.this.tab.getItem(new Point(e.x, e.y));
            if (this.item == null) {
                e.doit = false;
                e.detail = 0;
                return;
            }
            e.detail = 1;
            e.image = this.item.getImage();
        }

        @Override
        public void dragSetData(DragSourceEvent e) {
            logger.finest("dragSetData(" + e + ")");
            if (this.item != null) {
                PluginStub stub = (PluginStub)this.item.getData();
                e.data = new String[]{stub.getArchive().getAbsolutePath()};
            }
        }

        @Override
        public void dragFinished(DragSourceEvent e) {
            logger.finest("dragFinished(" + e + ")");
            if (this.item == null || !e.doit) {
                return;
            }
            PluginStub stub = (PluginStub)this.item.getData();
            PluginPanel.this.uninstall(stub);
            this.item = null;
        }

        @Override
        public void dragEnter(DropTargetEvent e) {
            logger.finest("dragEnter(" + e + ")");
            e.detail = 1;
        }

        @Override
        public void dragLeave(DropTargetEvent e) {
            logger.finest("dragLeave(" + e + ")");
        }

        @Override
        public void dragOver(DropTargetEvent e) {
            CTabItem item = PluginPanel.this.tab.getItem(PluginPanel.this.tab.toControl(e.x, e.y));
            if (item == null) {
                return;
            }
            PluginPanel.this.tab.setInsertMark(item, false);
        }

        @Override
        public void drop(DropTargetEvent e) {
            logger.finest("drop(" + e + ")");
            if (this.item == null) {
                PluginPanel.this.install((String[])e.data);
                return;
            }
            CTabItem ref = PluginPanel.this.tab.getItem(PluginPanel.this.tab.toControl(e.x, e.y));
            CTabItem newTab = PluginPanel.this.move(this.item, ref);
            PluginPanel.this.tab.setSelection(newTab);
            PluginPanel.this.manager.setSelectedTabItem(newTab);
            this.item = null;
        }
    }
}

