/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.event.Jive2chAdapter;
import org.koiroha.jive2ch.event.Jive2chEvent;
import org.koiroha.jive2ch.func.FavouriteCategory;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.Jive2chFrame;

public class MenuBar {
    private final Jive2chFrame frame;
    private MenuItem[] skins = null;

    public MenuBar(Decorations parent, Jive2chFrame frame) {
        this.frame = frame;
        Menu menubar = new Menu(parent, 2);
        parent.setMenuBar(menubar);
        this.initFileMenu(menubar);
        this.initViewMenu(menubar);
        this.initSearchMenu(menubar);
        this.initFeatureMenu(menubar);
        this.initHelpMenu(menubar);
    }

    private void initFileMenu(Menu menubar) {
        int meta = Platform.META;
        MenuItem file = new MenuItem(menubar, 64);
        Menu menu = new Menu(file);
        file.setText("\u30d5\u30a1\u30a4\u30eb");
        file.setMenu(menu);
        MenuItem newTab = new MenuItem(menu, 8);
        newTab.setText("\u65b0\u898f\u30bf\u30d6(&N)");
        newTab.setAccelerator(meta | 0x4E);
        newTab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.openNewTab();
            }
        });
        new MenuItem(menu, 2);
        MenuItem updateBoard = new MenuItem(menu, 8);
        updateBoard.setText("\u63b2\u793a\u677f\u4e00\u89a7\u306e\u66f4\u65b0(&B)...");
        updateBoard.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.updateBBSMenu("BBS\u30e1\u30cb\u30e5\u30fc\u3092\u66f4\u65b0\u3057\u307e\u3059");
            }
        });
        MenuItem saveContribute = new MenuItem(menu, 8);
        saveContribute.setText("\u66f8\u304d\u8fbc\u307f\u5165\u529b\u5185\u5bb9\u306e\u4eee\u4fdd\u5b58(&S)");
        saveContribute.setAccelerator(meta | 0x53);
        saveContribute.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.saveContribute();
            }
        });
        MenuItem openContributeLog = new MenuItem(menu, 8);
        openContributeLog.setText("\u66f8\u304d\u8fbc\u307f\u30ed\u30b0\u3092\u958b\u304f(&K)...");
        openContributeLog.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.openContributeLog();
            }
        });
        new MenuItem(menu, 2);
        final MenuItem saveHtml = new MenuItem(menu, 8);
        saveHtml.setText("\u73fe\u5728\u306e\u30b9\u30ec\u30c3\u30c9\u3092HTML\u3067\u4fdd\u5b58(&H)...");
        saveHtml.setAccelerator(meta | 0x20000 | 0x53);
        saveHtml.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.saveCurrentThread(false);
            }
        });
        saveHtml.setEnabled(false);
        final MenuItem datExport = new MenuItem(menu, 8);
        datExport.setText("\u73fe\u5728\u306e\u30b9\u30ec\u30c3\u30c9\u306edat\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8(&D)...");
        datExport.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.saveCurrentThread(true);
            }
        });
        datExport.setEnabled(false);
        new MenuItem(menu, 2);
        final MenuItem offlineMode = new MenuItem(menu, 32);
        offlineMode.setText("\u30aa\u30d5\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9(&W)");
        offlineMode.setSelection(this.frame.app.config.isOfflineMode());
        offlineMode.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.setOffline(offlineMode.getSelection());
            }
        });
        if (Platform.getPlatform().getOS() != Platform.OS.MACOSX) {
            new MenuItem(menu, 2);
            MenuItem exit = new MenuItem(menu, 8);
            exit.setText("\u7d42\u4e86(&Q)");
            exit.setAccelerator(meta | 0x100000D);
            exit.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    MenuBar.this.frame.exit();
                }
            });
        }
        this.frame.addJive2chListener(new Jive2chAdapter(){

            @Override
            public void threadSelected(Jive2chEvent e) {
                saveHtml.setEnabled(e.getThread() != null);
                datExport.setEnabled(e.getThread() != null);
            }
        });
        Config.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("offlineMode")) {
                    offlineMode.setSelection((Boolean)e.getNewValue());
                }
            }
        });
    }

    private void initViewMenu(Menu menubar) {
        int meta = Platform.META;
        MenuItem view = new MenuItem(menubar, 64);
        Menu menu = new Menu(view);
        view.setText("\u8868\u793a");
        view.setMenu(menu);
        MenuItem refreshThreads = new MenuItem(menu, 8);
        refreshThreads.setText("\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u306e\u66f4\u65b0(&R)");
        refreshThreads.setAccelerator(meta | 0x20000 | 0x52);
        refreshThreads.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.refreshThreads();
            }
        });
        final MenuItem refresh = new MenuItem(menu, 8);
        refresh.setText("\u30b9\u30ec\u30c3\u30c9\u306e\u66f4\u65b0(&T)");
        refresh.setAccelerator(meta | 0x52);
        refresh.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.refreshThreadContent(false);
            }
        });
        refresh.setEnabled(false);
        final MenuItem refreshForce = new MenuItem(menu, 8);
        refreshForce.setText("\u30ed\u30b0\u3092\u7834\u68c4\u3057\u3066\u66f4\u65b0(&N)");
        refreshForce.setAccelerator(meta | 0x10000 | 0x52);
        refreshForce.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.refreshThreadContent(true);
            }
        });
        refreshForce.setEnabled(false);
        new MenuItem(menu, 2);
        MenuItem showBrowser = new MenuItem(menu, 8);
        showBrowser.setText("\u30a2\u30c9\u30ec\u30b9\u6b04\u306eURL\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f(&B)...");
        showBrowser.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.showBrowser();
            }
        });
        MenuItem openClipboardURL = new MenuItem(menu, 8);
        openClipboardURL.setText("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306eURL\u3092\u958b\u304f(&D)");
        openClipboardURL.setAccelerator(meta | 0x44);
        openClipboardURL.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.openClipbardURL();
            }
        });
        MenuItem popupSelectedResNo = new MenuItem(menu, 8);
        popupSelectedResNo.setText("\u9078\u629e\u7bc4\u56f2\u306e\u30ec\u30b9\u756a\u3092\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7(&P)...");
        popupSelectedResNo.setAccelerator(0x100000D);
        popupSelectedResNo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.popupSelectedResNumber();
            }
        });
        new MenuItem(menu, 2);
        MenuItem skin = new MenuItem(menu, 64);
        final Menu skinMenu = new Menu(skin);
        skin.setText("\u30b9\u30ad\u30f3\u306e\u5207\u308a\u66ff\u3048(&S)");
        skin.setMenu(skinMenu);
        skin.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                MenuBar.this.initSkinList(skinMenu);
            }
        });
        MenuItem textSize = new MenuItem(menu, 64);
        Menu textSizeMenu = new Menu(textSize);
        textSize.setText("\u30ec\u30b9\u8868\u793a\u6b04\u306e\u6587\u5b57\u30b5\u30a4\u30ba(&T)");
        textSize.setMenu(textSizeMenu);
        GUI.FontSize[] fs = GUI.FontSize.values();
        MenuItem[] fontSize = new MenuItem[fs.length];
        for (int i = 0; i < fs.length; ++i) {
            fontSize[i] = this.initThreadFontSize(textSizeMenu, fs[i]);
        }
        MenuItem winTextSize = new MenuItem(menu, 64);
        Menu winTextSizeMenu = new Menu(textSize);
        winTextSize.setText("\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u6587\u5b57\u30b5\u30a4\u30ba(&W)");
        winTextSize.setMenu(winTextSizeMenu);
        fontSize = new MenuItem[fs.length];
        for (int i = 0; i < fs.length; ++i) {
            fontSize[i] = this.initWindowFontSize(winTextSizeMenu, fs[i]);
        }
        this.frame.addJive2chListener(new Jive2chAdapter(){

            @Override
            public void threadSelected(Jive2chEvent e) {
                refresh.setEnabled(e.getThread() != null);
                refreshForce.setEnabled(e.getThread() != null);
            }
        });
    }

    private void initSearchMenu(Menu menubar) {
        int meta = Platform.META;
        MenuItem search = new MenuItem(menubar, 64);
        Menu menu = new Menu(search);
        search.setText("\u691c\u7d22");
        search.setMenu(menu);
        MenuItem searchThread = new MenuItem(menu, 8);
        searchThread.setText("\u30b9\u30ec\u30c3\u30c9\u5185\u306e\u691c\u7d22(&F)");
        searchThread.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.searchThreadContent();
            }
        });
        MenuItem searchThreadList = new MenuItem(menu, 8);
        searchThreadList.setText("\u8868\u793a\u4e2d\u306e\u30b9\u30ec\u30c3\u30c9\u4e00\u89a7\u304b\u3089\u691c\u7d22(&S)...");
        searchThreadList.setAccelerator(meta | 0x46);
        searchThreadList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.searchThreads();
            }
        });
        MenuItem searchThreadLog = new MenuItem(menu, 8);
        searchThreadLog.setText("\u65e2\u5f97\u30ed\u30b0\u304b\u3089\u691c\u7d22(&L)...");
        searchThreadLog.setAccelerator(meta | 0x48);
        searchThreadLog.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.searchThreadLog();
            }
        });
        new MenuItem(menu, 2);
        MenuItem searchThreadTitle = new MenuItem(menu, 8);
        searchThreadTitle.setText("\u5168\u677f\u304b\u3089\u30b9\u30ec\u30c3\u30c9\u30bf\u30a4\u30c8\u30eb\u3067\u691c\u7d22(&T)...");
        searchThreadTitle.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.show("http://is.2ch.net/", "_blank");
            }
        });
    }

    private void initFeatureMenu(Menu menubar) {
        int meta = Platform.META;
        MenuItem feature = new MenuItem(menubar, 64);
        Menu menu = new Menu(feature);
        feature.setText("\u6a5f\u80fd");
        feature.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("\u304a\u6c17\u306b\u5165\u308a\u30b0\u30eb\u30fc\u30d7\u3092\u4f5c\u6210");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.createFavourite();
            }
        });
        final MenuItem delFav = new MenuItem(menu, 8);
        delFav.setText("\u304a\u6c17\u306b\u5165\u308a\u30b0\u30eb\u30fc\u30d7\u3092\u524a\u9664");
        delFav.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.removeFavourite();
            }
        });
        delFav.setEnabled(false);
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        item.setText("AA\u306e\u7ba1\u7406(&A)");
        item.setAccelerator(meta | 0x20000 | 0x41);
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.prefAA();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("\u6b21\u30b9\u30ec\u691c\u7d22(&N)");
        item.setAccelerator(0x1000014);
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.searchNextThread();
            }
        });
        if (Platform.getPlatform().getOS() != Platform.OS.MACOSX) {
            item = new MenuItem(menu, 8);
            item.setText("\u8a2d\u5b9a...");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    MenuBar.this.frame.showPreference();
                }
            });
        }
        this.frame.addJive2chListener(new Jive2chAdapter(){

            @Override
            public void boardSelected(Jive2chEvent e) {
                delFav.setEnabled(e.getCategory() instanceof FavouriteCategory && e.getBoard() != null);
            }
        });
    }

    private void initHelpMenu(Menu menubar) {
        MenuItem help = new MenuItem(menubar, 64);
        Menu menu = new Menu(help);
        help.setText("\u30d8\u30eb\u30d7");
        help.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Jive2ch \u306b\u3064\u3044\u3066...");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.showAbout();
            }
        });
    }

    private void initSkinList(Menu menu) {
        if (this.skins != null) {
            for (MenuItem i : this.skins) {
                i.dispose();
            }
        }
        this.skins = null;
        String current = this.frame.app.config.getSkinName();
        try {
            List<String> names = this.frame.app.skin.getNames();
            Collections.sort(names);
            this.skins = new MenuItem[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                final String name = names.get(i);
                this.skins[i] = new MenuItem(menu, 32);
                this.skins[i].setText(name);
                if (names.get(i).equals(current)) {
                    this.skins[i].setSelection(true);
                }
                this.skins[i].addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        MenuBar.this.frame.setSkin(name);
                    }
                });
            }
        }
        catch (IOException ex) {
            J2Component.fatal(ex);
        }
    }

    private MenuItem initThreadFontSize(Menu menu, final GUI.FontSize fs) {
        String label = fs.toString() + "(&" + fs.getShortcut() + ")";
        MenuItem item = new MenuItem(menu, 16);
        item.setText(label);
        item.setData((Object)fs);
        if (fs.equals((Object)this.frame.app.config.getTheadFontSize())) {
            item.setSelection(true);
        }
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.setThreadFontSize(fs);
            }
        });
        return item;
    }

    private MenuItem initWindowFontSize(Menu menu, final GUI.FontSize fs) {
        String label = fs.toString() + "(&" + fs.getShortcut() + ")";
        MenuItem item = new MenuItem(menu, 16);
        item.setText(label);
        item.setData((Object)fs);
        if (fs.equals((Object)this.frame.app.config.getWindowFontSize())) {
            item.setSelection(true);
        }
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MenuBar.this.frame.setWindowFontSize(fs);
            }
        });
        return item;
    }
}

