/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Kakiko;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.gui.J2MultiPane;
import org.koiroha.jive2ch.gui.Scrap;
import org.koiroha.jive2ch.gui.dialog.MessageDialog;
import org.koiroha.jive2ch.gui.dialog.PreviewDialog;
import org.koiroha.jive2ch.util.AADB;
import org.koiroha.jive2ch.util.Debug;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.TextUtil;
import org.koiroha.jive2ch.worker.ContributeWorker;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.Worker;

public class KakikoPanel
extends J2Component {
    private static final Logger logger = Logger.getLogger(KakikoPanel.class.getName());
    private Thread thread = null;
    private final Map<String, Date> cachedName = new HashMap<String, Date>();
    private final Map<String, Date> cachedMail = new HashMap<String, Date>();
    private final Combo name;
    private final Combo mail;
    private final StyledText content;
    private final Button sage;
    private final Button enterWriting;
    private final Button preview;
    private final Button exec;

    public KakikoPanel(J2MultiPane parent, Composite cmp, Thread thread) {
        super(cmp, 0);
        int META = Platform.META;
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 2;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout(layout);
        Label label = new Label(this, 131072);
        label.setText("\u540d\u524d");
        Composite toolbar = new Composite(this, 0);
        layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        toolbar.setLayout(layout);
        toolbar.setLayoutData(new GridData(768));
        this.name = new Combo(toolbar, 4);
        this.name.setFont(GUI.deriveFontSize(this.name, 0.9f));
        GridData gd = new GridData();
        gd.widthHint = 100;
        this.name.setLayoutData(gd);
        label = new Label(toolbar, 131072);
        label.setText("\u30e1\u30fc\u30eb");
        this.mail = new Combo(toolbar, 4);
        this.mail.setFont(GUI.deriveFontSize(this.mail, 0.9f));
        gd = new GridData();
        gd.widthHint = 100;
        this.mail.setLayoutData(gd);
        this.sage = new Button(toolbar, 32);
        this.sage.setText("sage");
        this.enterWriting = new Button(toolbar, 32);
        this.enterWriting.setText("ENTER\u3067\u66f8\u304d\u8fbc\u307f");
        this.preview = new Button(toolbar, 32);
        this.preview.setText("\u30d7\u30ec\u30d3\u30e5\u30fc");
        label = new Label(this, 0);
        label.setText("\u672c\u6587");
        gd = new GridData();
        gd.verticalAlignment = 128;
        label.setLayoutData(gd);
        Composite cont = new Composite(this, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cont.setLayout(layout);
        cont.setLayoutData(new GridData(1808));
        this.content = new StyledText(cont, 2626);
        this.initContextMenu(this.content);
        this.content.setKeyBinding(META + 65, 262209);
        gd = new GridData(1808);
        this.content.setLayoutData(gd);
        this.exec = new Button(cont, 0x800000);
        this.exec.setImage(Resource.loadImage(this.exec.getDisplay(), "mail-forward.png"));
        this.exec.setToolTipText("\u66f8\u304d\u8fbc\u307f\u3092\u884c\u3044\u307e\u3059");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 40;
        gd.heightHint = 40;
        this.exec.setLayoutData(gd);
        this.setTabList(new Control[]{toolbar, cont});
        toolbar.setTabList(new Control[]{this.name, this.mail, this.sage, this.enterWriting, this.preview});
        cont.setTabList(new Control[]{this.content, this.exec});
        InputListener l = new InputListener();
        this.content.addLineStyleListener(l);
        this.content.addVerifyKeyListener(l);
        this.exec.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                KakikoPanel.this.contribute();
            }
        });
        this.sage.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (KakikoPanel.this.sage.getSelection()) {
                    KakikoPanel.this.mail.setText("sage");
                } else {
                    KakikoPanel.this.mail.setText("");
                }
            }
        });
        this.mail.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                KakikoPanel.this.sage.setSelection(KakikoPanel.this.mail.getText().equals("sage"));
            }
        });
        this.content.addModifyListener(new EnterListener());
        this.setThread(thread);
    }

    @Override
    public void init() {
        super.init();
        Scrap scrap = this.app.scrap.subscrap("kakiko.");
        this.enterWriting.setSelection(scrap.getBoolean("enterWriting", false));
        this.preview.setSelection(scrap.getBoolean("preview", true));
        KakikoPanel.parseCache(this.cachedName, scrap.getString("cache.name", ""), 180L);
        KakikoPanel.parseCache(this.cachedMail, scrap.getString("cache.mail", ""), 180L);
        this.setupCache();
        this.sage.setSelection(scrap.getBoolean("sage", false));
        if (this.sage.getSelection()) {
            this.mail.setText("sage");
        }
    }

    @Override
    public void destroy() {
        Scrap scrap = this.app.scrap.subscrap("kakiko.");
        scrap.setBoolean("sage", this.sage.getSelection());
        scrap.setBoolean("enterWriting", this.enterWriting.getSelection());
        scrap.setBoolean("preview", this.preview.getSelection());
        scrap.setString("cache.name", KakikoPanel.buildCache(this.cachedName, 180L));
        scrap.setString("cache.mail", KakikoPanel.buildCache(this.cachedMail, 180L));
        super.destroy();
    }

    public void edit(String text) {
        String input = this.content.getText();
        if (input.trim().length() == 0) {
            this.content.setText(text);
        } else {
            this.content.setText(input + Text.DELIMITER + text);
        }
        this.content.setSelection(this.content.getText().length());
        this.content.forceFocus();
    }

    public Kakiko getKakiko() {
        return new Kakiko(this.name.getText(), this.mail.getText(), this.content.getText());
    }

    public void setKakiko(Kakiko kakiko) {
        this.name.setText(kakiko.getName());
        this.mail.setText(kakiko.getMail());
        this.content.setText(kakiko.getContent());
    }

    public void contribute() {
        if (this.content.getText().length() == 0) {
            KakikoPanel.messageBox("\u5185\u5bb9\u304c\u306a\u3044\u3067\u3059\u3088");
            this.content.forceFocus();
            return;
        }
        boolean forceContinueCheck = false;
        if (this.preview.getSelection()) {
            if (!this.preview()) {
                this.content.forceFocus();
                return;
            }
            forceContinueCheck = true;
        }
        logger.fine("\u66f8\u304d\u8fbc\u307f\u3092\u884c\u3044\u3063\u3066\u3044\u307e\u3059...");
        String name = this.name.getText();
        String mail = this.mail.getText();
        String content = this.content.getText();
        HashSet<Character> invalid = new HashSet<Character>();
        content = this.normalize(content, invalid);
        if (!forceContinueCheck && !this.checkContinue(invalid)) {
            this.content.forceFocus();
            return;
        }
        this.cachedName.put(name, new Date());
        this.cachedMail.put(mail, new Date());
        this.setupCache();
        Board board = this.thread.getBoard();
        if (board.getContributeInterval() > 0L) {
            Date recent = board.getContributeDate();
            long interval = board.getContributeInterval();
            long now = System.currentTimeMillis();
            if (recent != null && now - recent.getTime() < interval) {
                logger.finer("\u9023\u7d9a\u66f8\u304d\u8fbc\u307f\u898f\u5236\u306e\u7d9a\u884c\u78ba\u8a8d");
                if (!this.checkContinue(recent.getTime(), interval)) {
                    return;
                }
            }
        }
        this.exec.setEnabled(false);
        this.content.setEnabled(false);
        Kakiko kakiko = new Kakiko(name, mail, content);
        ContributeWorker worker = new ContributeWorker(this.thread, kakiko);
        worker.addPropertyChangeListener(GUI.wrapSWTInvoke(this.app, PropertyChangeListener.class));
        worker.addListener(GUI.wrapSWTInvoke(new Listener(), Worker.Listener.class));
        Launcher.start(worker);
        this.content.forceFocus();
    }

    public void setThread(Thread thread) {
        this.thread = thread;
        this.exec.setEnabled(thread != null);
        this.content.setEnabled(thread != null);
    }

    private boolean preview() {
        String name = this.name.getText();
        if (name.length() == 0) {
            Properties s = this.thread.getBoard().getSettings();
            name = s.getProperty("BBS_NONAME_NAME", "\u540d\u7121\u3057\u3055\u3093\uff20Jive2ch");
        }
        HashSet<Character> invalid = new HashSet<Character>();
        String content = " " + this.content.getText();
        content = this.normalize(content, invalid);
        content = content.replaceAll("<", "&lt;");
        content = content.replaceAll("\r?\n", " <br> ");
        if (!this.checkContinue(invalid)) {
            return false;
        }
        Response res = new Response(name, this.mail.getText(), content);
        res.setNumber(1);
        res.setAsciiArt(TextUtil.isAsciiArt(res));
        try {
            PreviewDialog dialog = new PreviewDialog(this, this.thread, res);
            dialog.open();
            if (dialog.getSelectedOption() == J2Dialog.Option.OK) {
                return true;
            }
        }
        catch (IOException ex) {
            KakikoPanel.fatal(ex);
            return false;
        }
        this.content.setFocus();
        return false;
    }

    private boolean checkContinue(Set<Character> invalid) {
        if (invalid.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (char ch : invalid) {
                buffer.append(Debug.literal(ch));
                buffer.append('\t');
                buffer.append(String.format(" (U+%04X)", ch));
                buffer.append('\n');
            }
            MessageDialog dialog = new MessageDialog(this);
            dialog.setMessage("\u3053\u306e\u677f\u306b\u66f8\u304d\u8fbc\u3080\u3068\u5316\u3051\u3066\u3057\u307e\u3044\u305d\u3046\u306a\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\n\u7d9a\u884c\u3057\u307e\u3059\u304b?");
            dialog.setDescription(buffer.toString());
            dialog.setDescriptionVisible(true);
            dialog.setOptionIcon(this.getShell().getDisplay().getSystemImage(4));
            dialog.setOptions(new Object[]{J2Dialog.Option.CONTINUE, J2Dialog.Option.CANCEL});
            dialog.setDefaultOption((Object)J2Dialog.Option.CANCEL);
            dialog.open(true);
            if (dialog.getSelectedOption() != J2Dialog.Option.CONTINUE) {
                this.content.setFocus();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkContinue(long recent, final long interval) {
        String format = "\u3053\u306e\u307e\u307e\u66f8\u304d\u8fbc\u3080\u3068\u9023\u7d9a\u66f8\u304d\u8fbc\u307f\u898f\u5236\u306b\u5f15\u3063\u304b\u304b\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n\u66f8\u304d\u8fbc\u307f\u3092\u7d9a\u884c\u3057\u307e\u3059\u304b? (%2$,d\u79d2\u898f\u5236\u306e\u6b8b\u308a%1$,d\u79d2)";
        final MessageDialog dialog = new MessageDialog(this);
        dialog.setMessage(String.format("\u3053\u306e\u307e\u307e\u66f8\u304d\u8fbc\u3080\u3068\u9023\u7d9a\u66f8\u304d\u8fbc\u307f\u898f\u5236\u306b\u5f15\u3063\u304b\u304b\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n\u66f8\u304d\u8fbc\u307f\u3092\u7d9a\u884c\u3057\u307e\u3059\u304b? (%2$,d\u79d2\u898f\u5236\u306e\u6b8b\u308a%1$,d\u79d2)", (recent + interval - System.currentTimeMillis()) / 1000L, interval / 1000L));
        dialog.setDescriptionVisible(false);
        dialog.setOptionIcon(this.getShell().getDisplay().getSystemImage(4));
        dialog.setOptions(new Object[]{J2Dialog.Option.CONTINUE, J2Dialog.Option.CANCEL});
        dialog.setDefaultOption((Object)J2Dialog.Option.CONTINUE);
        final long time = recent + interval;
        GUI.SWTTimerTask task = new GUI.SWTTimerTask(){

            @Override
            public void asyncExec() {
                long left = Math.max(0L, (time - System.currentTimeMillis()) / 1000L);
                long intv = interval / 1000L;
                dialog.setMessage(String.format("\u3053\u306e\u307e\u307e\u66f8\u304d\u8fbc\u3080\u3068\u9023\u7d9a\u66f8\u304d\u8fbc\u307f\u898f\u5236\u306b\u5f15\u3063\u304b\u304b\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n\u66f8\u304d\u8fbc\u307f\u3092\u7d9a\u884c\u3057\u307e\u3059\u304b? (%2$,d\u79d2\u898f\u5236\u306e\u6b8b\u308a%1$,d\u79d2)", left, intv));
                if (left <= 0L) {
                    this.cancel();
                }
            }
        };
        Calendar cal = Calendar.getInstance();
        long tm = cal.getTimeInMillis();
        cal.clear(14);
        cal.add(13, 1);
        long delay = Math.max(0L, cal.getTimeInMillis() - tm);
        GUI.scheduleAtFixedRate(task, delay, 1000L);
        try {
            dialog.open(true);
        }
        finally {
            task.cancel();
        }
        if (dialog.getSelectedOption() != J2Dialog.Option.CONTINUE) {
            this.content.setFocus();
            return false;
        }
        return true;
    }

    private String normalize(String text, Set<Character> invalid) {
        Properties prop = this.thread.getBoard().getSettings();
        boolean unicode = prop.getProperty("BBS_UNICODE", "change").equalsIgnoreCase("pass");
        return TextUtil.normalizeToContribute(text, invalid, unicode);
    }

    private void inputAA() {
        logger.finest("inputAA()");
        Menu menu = new Menu(this.content);
        List<AADB.Tag> tags = this.app.aadb.getTags();
        for (AADB.Tag t : tags) {
            this.createAAMenuItem(menu, t);
        }
        if (menu.getItemCount() > 0) {
            new MenuItem(menu, 258);
        }
        MenuItem item = new MenuItem(menu, 8);
        item.setText("AA\u306e\u7ba1\u7406...");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                KakikoPanel.this.getAppFrame().prefAA();
            }
        });
        menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuHidden(MenuEvent e) {
                KakikoPanel.this.app.aadb.flush();
            }
        });
        int offset = this.content.getCaretOffset();
        Point p = this.content.getLocationAtOffset(offset);
        p.y += this.content.getLineHeight();
        menu.setLocation(this.content.toDisplay(p));
        menu.setVisible(true);
    }

    private void createAAMenuItem(Menu parent, final AADB.Tag tag) {
        MenuItem item = new MenuItem(parent, 64);
        item.setText(tag.getName());
        item.setImage(GUI.ICON_FOLDER);
        item.setData(tag.getCanonicalName());
        final Menu menu = new Menu(parent);
        item.setMenu(menu);
        menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent e) {
                KakikoPanel.this.openAAMenuItem(menu, tag);
            }
        });
    }

    private void openAAMenuItem(Menu parent, AADB.Tag tag) {
        for (MenuItem item : parent.getItems()) {
            item.dispose();
        }
        for (AADB.Tag c : tag.getChild()) {
            this.createAAMenuItem(parent, c);
        }
        try {
            for (AADB.AA aa : this.app.aadb.getAA(tag.getCanonicalName())) {
                MenuItem item;
                final String a = aa.getAA();
                item = new MenuItem(parent, 8);
                item.setText(aa.getName());
                item.setImage(aa.getImage());
                item.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        KakikoPanel.this.content.insert(a);
                    }
                });
            }
        }
        catch (IOException ex) {
            KakikoPanel.fatal(ex);
        }
    }

    private void setupCache() {
        String name = this.name.getText();
        this.name.removeAll();
        ArrayList<String> list = new ArrayList<String>(this.cachedName.keySet());
        Collections.sort(list);
        for (String n : list) {
            this.name.add(n);
        }
        this.name.setText(name);
        String mail = this.mail.getText();
        this.mail.removeAll();
        list = new ArrayList<String>(this.cachedMail.keySet());
        Collections.sort(list);
        for (String n : list) {
            this.mail.add(n);
        }
        this.mail.setText(mail);
    }

    private void initContextMenu(Control ctrl) {
        Menu menu = new Menu(ctrl);
        final MenuItem urlenc = new MenuItem(menu, 8);
        urlenc.setText("\u9078\u629e\u7bc4\u56f2\u3092URL\u30a8\u30f3\u30b3\u30fc\u30c9");
        urlenc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String text = KakikoPanel.this.content.getSelectionText();
                KakikoPanel.this.content.insert(KakikoPanel.encode(text));
            }
        });
        final MenuItem urldec = new MenuItem(menu, 8);
        urldec.setText("\u9078\u629e\u7bc4\u56f2\u3092URL\u30c7\u30b3\u30fc\u30c9");
        urldec.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String text = KakikoPanel.this.content.getSelectionText();
                KakikoPanel.this.content.insert(KakikoPanel.decode(text));
            }
        });
        MenuItem aainput = new MenuItem(menu, 8);
        aainput.setText("AA\u5165\u529b");
        aainput.setAccelerator(262176);
        aainput.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                KakikoPanel.this.inputAA();
            }
        });
        ctrl.setMenu(menu);
        ctrl.addMenuDetectListener(new MenuDetectListener(){

            @Override
            public void menuDetected(MenuDetectEvent e) {
                boolean select = KakikoPanel.this.content.getSelectionCount() > 0;
                urlenc.setEnabled(select);
                urldec.setEnabled(select);
            }
        });
    }

    private static String encode(String text) {
        try {
            return URLEncoder.encode(text, IO.UTF8.name());
        }
        catch (IOException ex) {
            KakikoPanel.fatal(ex);
            return text;
        }
    }

    private static String decode(String text) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '+') {
                buffer.append(' ');
                continue;
            }
            if (ch != '%') {
                buffer.append(ch);
                continue;
            }
            try {
                String num;
                if (i + 5 < text.length() && Character.toLowerCase(text.charAt(i + 1)) == 'u') {
                    num = text.substring(i + 2, i + 6);
                    ch = (char)Integer.parseInt(num, 16);
                    i += 5;
                } else if (i + 2 < text.length()) {
                    num = text.substring(i + 1, i + 3);
                    ch = (char)Integer.parseInt(num, 16);
                    i += 3;
                }
            }
            catch (NumberFormatException ex) {
                logger.finer("\u4e0d\u6b63\u306aURL\u30a8\u30f3\u30b3\u30fc\u30c9\u5f62\u5f0f: " + ex);
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static void parseCache(Map<String, Date> cache, String value, long expireDate) {
        String[] elem;
        long now = System.currentTimeMillis();
        for (String s : elem = value.split("\n+")) {
            int sep = s.lastIndexOf(61);
            if (sep < 0) continue;
            try {
                String name = s.substring(0, sep);
                long time = Long.parseLong(s.substring(sep + 1).trim());
                if (now - time < expireDate * 24L * 60L * 60L * 1000L) {
                    cache.put(name, new Date(time));
                    continue;
                }
                logger.finest("\u30ad\u30e3\u30c3\u30b7\u30e5\u3055\u308c\u3066\u3044\u305f\u540d\u524d\u307e\u305f\u306f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306e\u671f\u9650 (" + expireDate + "\u65e5) \u304c\u5207\u308c\u307e\u3057\u305f: " + name);
            }
            catch (NumberFormatException ex) {
                logger.warning("\u65e5\u4ed8\u306e\u6570\u5024\u304c\u4e0d\u6b63\u3067\u3059: " + s);
            }
        }
    }

    private static String buildCache(Map<String, Date> cache, long expireDate) {
        long now = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, Date> e : cache.entrySet()) {
            String key = e.getKey();
            Date value = e.getValue();
            if (now - value.getTime() >= expireDate * 24L * 60L * 60L * 1000L) continue;
            buffer.append(key).append('=').append(value.getTime()).append('\n');
        }
        return buffer.toString();
    }

    private class EnterListener
    implements ModifyListener {
        private int lines = this.getLines();

        @Override
        public void modifyText(ModifyEvent e) {
            int lines = this.getLines();
            if (lines != this.lines && KakikoPanel.this.enterWriting.getSelection()) {
                KakikoPanel.this.contribute();
            }
        }

        private int getLines() {
            String str = KakikoPanel.this.content.getText();
            int lines = 1;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != '\n') continue;
                ++lines;
            }
            logger.finest("\u66f8\u304d\u8fbc\u307f\u5185\u5bb9\u306e\u884c\u6570: " + lines + "\u884c");
            return lines;
        }
    }

    private class Listener
    extends Worker.Adapter<Object, Boolean> {
        private Listener() {
        }

        @Override
        public void done(Boolean ret) {
            KakikoPanel.this.exec.setEnabled(true);
            if (!ret.booleanValue()) {
                logger.finer("\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                return;
            }
            logger.info("\u66f8\u304d\u8fbc\u307f\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
            KakikoPanel.this.content.setText("");
            KakikoPanel.this.content.setEnabled(true);
            Date now = new Date();
            Board board = KakikoPanel.this.thread.getBoard();
            Date prev = KakikoPanel.this.thread.getContributeDate();
            if (prev != null && now.getTime() - prev.getTime() < board.getContributeInterval()) {
                board.setContributeInterval(0L);
                logger.fine("\u9023\u7d9a\u66f8\u304d\u8fbc\u307f\u898f\u5236\u304c\u89e3\u9664\u3055\u308c\u307e\u3057\u305f");
            }
            KakikoPanel.this.thread.setContributeDate(now);
            KakikoPanel.this.getAppFrame().refreshThreadContent(false);
        }

        @Override
        public void error(Throwable ex) {
            KakikoPanel.this.exec.setEnabled(true);
            KakikoPanel.this.content.setEnabled(true);
            super.error(ex);
        }
    }

    private class InputListener
    implements LineStyleListener,
    VerifyKeyListener {
        private final CharsetEncoder encoder = IO.SJIS.newEncoder();
        private Color underline = KakikoPanel.this.getShell().getDisplay().getSystemColor(3);
        private Color pointer = KakikoPanel.this.getShell().getDisplay().getSystemColor(9);

        private InputListener() {
        }

        @Override
        public void lineGetStyle(LineStyleEvent e) {
            StyleRange r;
            String text = e.lineText;
            ArrayList<StyleRange> range = new ArrayList<StyleRange>();
            for (int i = 0; i < text.length(); ++i) {
                if (this.encoder.canEncode(text.charAt(i))) continue;
                r = new StyleRange();
                r.start = e.lineOffset + i;
                r.length = 1;
                r.underline = true;
                r.underlineColor = this.underline;
                r.underlineStyle = 3;
                range.add(r);
            }
            Matcher m = TextUtil.PATTERN_POINTER.matcher(text);
            while (m.find()) {
                r = new StyleRange();
                r.start = e.lineOffset + m.start();
                r.length = m.end() - m.start();
                r.foreground = this.pointer;
                range.add(r);
            }
            e.styles = range.toArray(new StyleRange[range.size()]);
        }

        @Override
        public void verifyKey(VerifyEvent e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(GUI.toString(e) + ": " + e.toString());
            }
            if (e.stateMask == 131072 && (e.keyCode == 13 || e.keyCode == 10)) {
                KakikoPanel.this.contribute();
                e.doit = false;
                return;
            }
            if (e.stateMask == 0 && (e.keyCode == 13 || e.keyCode == 10) && KakikoPanel.this.enterWriting.getSelection()) {
                KakikoPanel.this.contribute();
                e.doit = false;
                return;
            }
            if (e.stateMask == 262144 && e.keyCode == 32) {
                KakikoPanel.this.inputAA();
                e.doit = false;
                return;
            }
            if (e.stateMask == 0 && e.keyCode == 9) {
                KakikoPanel.this.exec.forceFocus();
                e.doit = false;
                return;
            }
        }
    }
}

