/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Kakiko;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.event.Jive2chListener;
import org.koiroha.jive2ch.event.Jive2chSupport;
import org.koiroha.jive2ch.func.FavouriteCategory;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.func.SkinManager;
import org.koiroha.jive2ch.gui.FavouriteBar;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2CategoryTree;
import org.koiroha.jive2ch.gui.J2Frame;
import org.koiroha.jive2ch.gui.J2MultiPane;
import org.koiroha.jive2ch.gui.MenuBar;
import org.koiroha.jive2ch.gui.ThreadList;
import org.koiroha.jive2ch.gui.ThreadViewer;
import org.koiroha.jive2ch.gui.ToolPanel;
import org.koiroha.jive2ch.gui.dialog.AAPrefDialog;
import org.koiroha.jive2ch.gui.dialog.AboutDialog;
import org.koiroha.jive2ch.gui.dialog.BBSMenuUpdateDialog;
import org.koiroha.jive2ch.gui.dialog.FavouriteDialog;
import org.koiroha.jive2ch.gui.dialog.NextThreadSearchDialog;
import org.koiroha.jive2ch.gui.dialog.TextEditDialog;
import org.koiroha.jive2ch.gui.pref.PrefDialog;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.util.ThreadFilter;
import org.koiroha.jive2ch.worker.BoardIconUpdateWorker;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.Worker;

public class Jive2chFrame
extends J2Frame {
    private static final Logger logger = Logger.getLogger(Jive2chFrame.class.getName());
    private ToolPanel toolbar = null;
    private FavouriteBar favourite = null;
    private J2CategoryTree categories = null;
    private ThreadList threads = null;
    private J2MultiPane content = null;
    private Label status = null;
    private SashForm boardThreadSash = null;
    private SashForm threadContentSash = null;
    private Jive2chSupport listener = new Jive2chSupport(this);

    public Jive2chFrame() {
        assert (!GUI.isEventDispatchThread());
        GUI.setEventDispatchThread(true);
        GUI.setSystemComponent(this);
        this.initialize();
        this.app.addDispatchListner(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Jive2chFrame.this.propertyChange(evt);
            }
        });
        File bbsmenu = this.app.repository.getBBSMenuFile();
        if (!bbsmenu.isFile()) {
            GUI.schedule(new GUI.SWTTimerTask(){

                @Override
                public void asyncExec() {
                    Jive2chFrame.this.updateBBSMenu("BBS\u30e1\u30cb\u30e5\u30fc\u306e\u66f4\u65b0\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044");
                }
            }, 1L);
        }
        this.loadContribute();
    }

    public void setBoard(Board board) {
        this.threads.setBoard(board);
        this.listener.fireBoardSelected(board);
    }

    public void setThread(Thread thread) {
        try {
            this.content.show(thread);
        }
        catch (IOException ex) {
            Jive2chFrame.fatal(ex);
        }
        this.listener.fireThreadSelected(thread);
    }

    public void setThreadFilter(ThreadFilter filter) {
        this.threads.setFilter(filter);
    }

    public void setStatus(String status) {
        assert (GUI.isEventDispatchThread());
        this.status.setText(status);
    }

    public void openNewTab() {
        this.content.openTab();
    }

    public void updateBBSMenu(String msg) {
        String url = this.app.res.getString("url.menu");
        File local = this.app.repository.getBBSMenuFile();
        BBSMenuUpdateDialog dialog = new BBSMenuUpdateDialog(this, url, local, msg);
        dialog.open();
        List<Category> categories = dialog.getCategoryList();
        if (categories == null) {
            return;
        }
        try {
            this.app.reloadCategoryList();
        }
        catch (IOException ex) {
            Jive2chFrame.fatal(ex);
            return;
        }
        this.categories.updateCategories();
        BoardIconUpdateWorker worker = new BoardIconUpdateWorker(this.app.getCategoryList(), true);
        worker.addListener(GUI.wrapSWTInvoke(new Worker.Adapter<Board, Object>(){

            @Override
            public void processing(List<Board> value) {
                for (Board b : value) {
                    b.resetIcon();
                }
            }
        }, Worker.Listener.class));
        Launcher.start(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContribute() {
        Kakiko kakiko = this.content.contribute.getKakiko();
        RollbackOutputStream out = null;
        try {
            out = new RollbackOutputStream(this.app.repository.kakikomiKariHozon);
            XMLEncoder encoder = new XMLEncoder(out);
            encoder.writeObject(kakiko);
            encoder.close();
            IO.close(out);
        }
        catch (IOException ex) {
            Jive2chFrame.fatal(ex);
        }
        finally {
            IO.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadContribute() {
        block7: {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.app.repository.kakikomiKariHozon);
                XMLDecoder decoder = new XMLDecoder(in);
                Kakiko kakiko = (Kakiko)decoder.readObject();
                this.content.contribute.setKakiko(kakiko);
                IO.close(in);
            }
            catch (FileNotFoundException ex) {
                IO.close(in);
            }
            catch (Exception ex2) {
                Jive2chFrame.fatal(ex2);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IO.close(in);
            }
        }
    }

    public void openContributeLog() {
        File file = this.app.repository.kakikomiFile;
        TextEditDialog dialog = new TextEditDialog(this);
        dialog.setTitle("\u66f8\u304d\u8fbc\u307f\u30ed\u30b0");
        try {
            dialog.load(file);
            dialog.open();
        }
        catch (IOException ex) {
            Jive2chFrame.fatal(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCurrentThread(boolean dat) {
        Thread thread = this.content.getSelectedThread();
        if (thread == null) {
            logger.finer("\u30b9\u30ec\u30c3\u30c9\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        File dir = this.app.config.getExportDirectory();
        dialog.setFilterPath(dir.getAbsolutePath());
        if (dat) {
            dialog.setFileName(thread.getEntityFile().getName());
            dialog.setFilterExtensions(new String[]{"*.dat"});
        } else {
            dialog.setFileName(thread.getTitle() + ".html");
            dialog.setFilterExtensions(new String[]{"*.html;*.htm"});
        }
        dialog.setOverwrite(true);
        String file = dialog.open();
        if (file == null) {
            return;
        }
        this.app.config.setExportDirectory(new File(file).getParentFile());
        FileWriter out = null;
        try {
            if (dat) {
                IO.copy(thread.getEntityFile(), new File(file));
            } else {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("export", "export");
                SkinManager sm = SkinManager.getDefault();
                out = new FileWriter(file);
                sm.convert(out, thread, param, Pointer.ALL);
                logger.fine("HTML\u30d5\u30a1\u30a4\u30eb\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3057\u305f: " + file);
            }
        }
        catch (IOException ex) {
            Jive2chFrame.fatal(ex);
        }
        finally {
            IO.close(out);
        }
    }

    public boolean isOffline() {
        return this.app.config.isOfflineMode();
    }

    public void setOffline(boolean offline) {
        this.app.config.setOfflineMode(offline);
        this.toolbar.setOffline(offline);
    }

    public void refreshThreads() {
        this.threads.reload(false, true);
    }

    public void refreshThreadContent(boolean force) {
        if (!force) {
            this.content.refresh(ThreadViewer.RefreshMode.RESUME);
        } else {
            this.content.refresh(ThreadViewer.RefreshMode.FORCE);
        }
    }

    public void showBrowser() {
        String url = this.toolbar.getURL();
        if (url.trim().length() == 0) {
            url = "about:blank";
        }
        this.showBrowser(url);
    }

    public void showBrowser(String url) {
        if (Platform.getPlatform().openURL(url)) {
            return;
        }
        Program program = Program.findProgram("html");
        if (program != null) {
            program.execute(url);
            logger.finer("URL\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f: " + url + " (" + program.getName() + ")");
            return;
        }
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object desktop = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            Method method = clazz.getMethod("browse", URI.class);
            method.invoke(desktop, URI.create(url));
        }
        catch (Exception ex) {
            logger.fine("JSE 6 Desktop \u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093: " + ex);
        }
        if (Platform.getPlatform().getOS() == Platform.OS.WINDOWS) {
            try {
                Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url});
            }
            catch (IOException ex) {
                Jive2chFrame.fatal(ex);
            }
            return;
        }
        Jive2chFrame.error("\u30d6\u30e9\u30a6\u30b6\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
    }

    public void openClipbardURL() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            String str = (String)clipboard.getContents(TextTransfer.getInstance());
            this.show(str, null);
        }
        catch (ClassCastException ex) {
            Jive2chFrame.fatal(ex);
        }
    }

    public void show(String url, String target) {
        logger.finest("show(" + url + "," + target + ")");
        try {
            this.content.show(new URI(url), target);
        }
        catch (URISyntaxException ex) {
            Jive2chFrame.error("URL\u304c\u4e0d\u6b63\u3067\u3059\n" + url);
        }
        catch (Exception ex) {
            Jive2chFrame.fatal(ex);
        }
    }

    public void popupSelectedResNumber() {
        logger.warning("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setSkin(String name) {
        this.app.config.setSkinName(name);
        this.refresh(ThreadViewer.RefreshMode.LOCAL_RELOAD);
    }

    public void setThreadFontSize(GUI.FontSize size) {
        this.app.config.setThreadFontSize(size);
        this.refresh(ThreadViewer.RefreshMode.REDRAW_ONLY);
    }

    public void setWindowFontSize(GUI.FontSize size) {
        this.app.config.setWindowFontSize(size);
        GUI.setFontSize(this.getShell(), size);
    }

    public void setThreadMaximized(boolean maximized) {
        logger.finest("setThreadMaximized(" + maximized + ")");
        if (maximized) {
            this.boardThreadSash.setMaximizedControl(this.threadContentSash);
            this.threadContentSash.setMaximizedControl(this.content);
        } else {
            this.boardThreadSash.setMaximizedControl(null);
            this.threadContentSash.setMaximizedControl(null);
        }
    }

    public void searchThreadContent() {
        logger.warning("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void searchThreads() {
        this.toolbar.forcusSearch();
    }

    public void searchThreadLog() {
        logger.warning("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void searchNextThread() {
        Thread thread = this.content.getSelectedThread();
        if (thread == null) {
            logger.fine("\u30b9\u30ec\u30c3\u30c9\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        NextThreadSearchDialog dialog = new NextThreadSearchDialog(this, thread);
        dialog.open();
        Thread next = dialog.getSelectedNextThread();
        if (next != null) {
            this.setThread(next);
        }
    }

    public void sortThreadList() {
        this.threads.sort();
    }

    public void createFavourite() {
        FavouriteDialog dialog = new FavouriteDialog(this, this.app.favourite.getDirectory());
        dialog.open();
        String name = dialog.getNewName();
        if (name != null) {
            LocalBoard board = this.app.favourite.createGroup(name);
            this.categories.updateFavourite(board);
            this.setBoard(board);
        }
    }

    public void removeFavourite() {
        Board b = this.categories.getSelectedBoard();
        if (b == null || !(b.getCategory() instanceof FavouriteCategory)) {
            return;
        }
        FavouriteCategory category = (FavouriteCategory)b.getCategory();
        LocalBoard board = (LocalBoard)b;
        try {
            category.removeGroup(board);
            this.categories.updateFavourite(null);
        }
        catch (IOException ex) {
            Jive2chFrame.fatal(ex);
        }
    }

    public void addFavourite(Board board) {
        this.favourite.addBoard(board);
    }

    public void prefAA() {
        AAPrefDialog dialog = new AAPrefDialog(this, this.app.aadb);
        dialog.open();
    }

    public void showPreference() {
        PrefDialog dialog = new PrefDialog(this);
        dialog.open();
    }

    public void showAbout() {
        AboutDialog dialog = new AboutDialog(this);
        dialog.open(false);
    }

    private void propertyChange(PropertyChangeEvent e) {
        if (!this.status.isDisposed() && e.getPropertyName().equals("status")) {
            this.setStatus((String)e.getNewValue());
        }
        if (e.getSource() instanceof J2MultiPane && e.getPropertyName().equals("showingURL")) {
            String url = (String)e.getNewValue();
            if (url != null) {
                this.toolbar.setURL(url);
            } else {
                this.toolbar.setURL("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void open() {
        Display display = this.getDisplay();
        try {
            try {
                super.open();
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                Jive2chFrame.fatal(ex);
            }
        }
        finally {
            super.close();
            display.dispose();
            display = null;
            GUI.setSystemComponent(null);
            GUI.setEventDispatchThread(false);
        }
    }

    public void exit() {
        if (!this.isDisposed()) {
            this.saveContribute();
        }
        this.close();
    }

    public void addJive2chListener(Jive2chListener l) {
        this.listener.addJive2chListener(l);
    }

    public void removeJive2chListener(Jive2chListener l) {
        this.listener.removeJive2chListener(l);
    }

    private void initialize() {
        this.setIcon(GUI.ICON_APP);
        this.setTitle("Jive2ch");
        new MenuBar(this.getShell(), this);
        this.toolbar = new ToolPanel(this);
        this.toolbar.setLayoutData(new GridData(768));
        this.favourite = new FavouriteBar(this);
        this.favourite.setLayoutData(new GridData(768));
        this.boardThreadSash = new SashForm(this, 65792);
        this.boardThreadSash.setSashWidth(3);
        this.boardThreadSash.setLayoutData(new GridData(1808));
        this.categories = new J2CategoryTree(this.boardThreadSash);
        this.categories.setLayoutData(new GridData(1808));
        this.threadContentSash = new SashForm(this.boardThreadSash, 512);
        this.threadContentSash.SASH_WIDTH = 5;
        this.threadContentSash.setLayoutData(new GridData(1808));
        this.threads = new ThreadList(this.threadContentSash);
        this.threads.setLayoutData(new GridData(1808));
        this.content = new J2MultiPane(this.threadContentSash);
        this.content.setLayoutData(new GridData(1808));
        this.content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Jive2chFrame.this.propertyChange(e);
            }
        });
        Composite statusBar = new Composite(this, 0);
        statusBar.setLayoutData(new GridData(768));
        GridLayout l2 = new GridLayout(2, false);
        l2.horizontalSpacing = 4;
        l2.verticalSpacing = 0;
        l2.marginRight = 0;
        l2.marginLeft = 0;
        l2.marginTop = 0;
        l2.marginBottom = 0;
        l2.marginWidth = 0;
        l2.marginHeight = 0;
        statusBar.setLayout(l2);
        this.status = new Label(statusBar, 2048);
        this.status.setText("");
        this.status.setLayoutData(new GridData(1808));
        this.setWindowFontSize(this.app.config.getWindowFontSize());
        this.getShell().setSize(800, 480);
        this.boardThreadSash.setWeights(new int[]{160, 640});
        this.threadContentSash.setWeights(new int[]{140, 340});
        this.getShell().addShellListener(new ShellAdapter(){

            @Override
            public void shellClosed(ShellEvent e) {
                Jive2chFrame.this.exit();
            }
        });
        new GUI.ResizeWeight(this.boardThreadSash, 0.0, 1.0);
        new GUI.ResizeWeight(this.threadContentSash, 0.3, 1.0);
    }

    private void refresh(ThreadViewer.RefreshMode mode) {
        this.content.refresh(mode);
    }
}

