/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.util.logging.Logger;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.Jive2chFrame;

public class J2Window
extends J2Component {
    private static final Logger logger = Logger.getLogger(J2Window.class.getName());
    private boolean defaultClose = true;
    private Composite parent = null;

    public J2Window(Display display, int style) {
        this(new Shell(display, style), 0);
    }

    public J2Window(Composite cmp, int style) {
        this(new Shell(cmp != null ? cmp.getShell() : null, style), 0);
        this.parent = cmp;
    }

    protected J2Window(Shell shell, int style) {
        super(shell, style);
        shell.setLayout(J2Window.newGridLayout());
        this.setLayoutData(new GridData(1808));
        shell.addShellListener(new ShellAdapter(){

            @Override
            public void shellClosed(ShellEvent e) {
                if (J2Window.this.isDefaultClose()) {
                    J2Window.this.close();
                } else {
                    e.doit = false;
                }
            }
        });
    }

    @Override
    public Jive2chFrame getAppFrame() {
        J2Component cmp;
        if (this instanceof Jive2chFrame) {
            return (Jive2chFrame)this;
        }
        if (this.parent != null && (cmp = J2Window.findParent(this.parent)) != null) {
            return cmp.getAppFrame();
        }
        return super.getAppFrame();
    }

    public String getTitle() {
        return this.getShell().getText();
    }

    public void setTitle(String title) {
        Control[] oldValue = this.getTabList();
        String newValue = title;
        this.getShell().setText(title);
        this.firePropertyChange("title", oldValue, newValue);
    }

    public Image getIcon() {
        return this.getShell().getImage();
    }

    public void setIcon(Image icon) {
        Image oldValue = this.getIcon();
        Image newValue = icon;
        this.getShell().setImage(icon);
        this.firePropertyChange("icon", oldValue, newValue);
    }

    public boolean isDefaultClose() {
        return this.defaultClose;
    }

    public void setDefaultClose(boolean defaultClose) {
        Boolean oldValue = this.isDefaultClose();
        Boolean newValue = defaultClose;
        this.defaultClose = defaultClose;
        this.firePropertyChange("defaultClose", oldValue, newValue);
    }

    public void open() {
        this.open(true);
    }

    public void open(boolean modal) {
        Shell shell = this.getShell();
        this.internalInit();
        shell.open();
        if (!modal) {
            return;
        }
        while (!shell.isDisposed()) {
            try {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
            catch (RuntimeException ex) {
                J2Window.fatal(ex);
            }
        }
    }

    public void close() {
        if (this.isDisposed()) {
            return;
        }
        Shell shell = this.getShell();
        if (shell.isDisposed()) {
            logger.fine("dispose(): \u30b7\u30a7\u30eb\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            return;
        }
        this.internalDestroy();
        logger.finer("\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u9589\u3058\u3066\u3044\u307e\u3059");
        this.internalDispose();
        shell.dispose();
    }

    public void moveCenterOfDisplay() {
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        int x = (display.getBounds().width - shell.getSize().x) / 2;
        int y = (display.getBounds().height - shell.getSize().y) / 2;
        shell.setLocation(x, y);
    }
}

