/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.KakikoPanel;
import org.koiroha.jive2ch.gui.PluginPanel;
import org.koiroha.jive2ch.gui.Scrap;
import org.koiroha.jive2ch.gui.ThreadViewer;

public class J2MultiPane
extends J2Component {
    private static final Logger logger = Logger.getLogger(J2MultiPane.class.getName());
    private static final String _BLANK = "_blank";
    private final CLabel title;
    private final CTabFolder tab;
    private final SashForm horSplit;
    private final SashForm verSplit;
    private ThreadViewer selectedViewer = null;
    private boolean autoScroll = true;
    private boolean openEditing = true;
    private boolean rolloverPopup = true;
    public final KakikoPanel contribute;
    public final PluginPanel plugins;

    public J2MultiPane(Composite parent) {
        super(parent, 0);
        Display display = this.getDisplay();
        this.setLayout(J2MultiPane.newGridLayout(1, 1, 1, false));
        this.title = new CLabel(this, 0);
        this.title.setFont(GUI.deriveFontSize(this.title, 1.1f));
        this.title.setForeground(display.getSystemColor(1));
        this.title.setBackground(new Color[]{display.getSystemColor(31), display.getSystemColor(32)}, new int[]{100});
        this.title.setLayoutData(new GridData(768));
        this.horSplit = new SashForm(this, 256);
        this.horSplit.setLayoutData(new GridData(1808));
        this.verSplit = new SashForm(this.horSplit, 512);
        this.tab = new CTabFolder(this.verSplit, 0);
        this.tab.setMaximizeVisible(true);
        this.tab.setSelectionBackground(new Color[]{display.getSystemColor(32), display.getSystemColor(31)}, new int[]{50}, true);
        this.tab.setSelectionForeground(display.getSystemColor(1));
        this.tab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J2MultiPane.this.setSelectedViewer((CTabItem)e.item);
            }
        });
        this.contribute = new KakikoPanel(this, this.verSplit, null);
        this.contribute.setLayoutData(new GridData(1808));
        this.plugins = new PluginPanel(this.horSplit);
        this.plugins.setLayoutData(new GridData(1808));
        this.horSplit.setWeights(new int[]{200, 60});
        new GUI.ResizeWeight(this.horSplit, 1.0, 0.0);
        this.verSplit.setWeights(new int[]{200, 60});
        new GUI.ResizeWeight(this.verSplit, 1.0, 0.0);
        this.tab.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J2MultiPane.this.setCurrentViewer((ThreadViewer)e.item.getData());
            }
        });
        this.tab.addCTabFolder2Listener(new CTabFolder2Adapter(){

            @Override
            public void close(CTabFolderEvent event) {
                logger.finest("close(" + event + ")");
                CTabItem item = (CTabItem)event.item;
                ThreadViewer viewer = (ThreadViewer)item.getData();
                viewer.stop();
                viewer.internalDestroy();
                if (J2MultiPane.this.tab.getItemCount() == 0) {
                    J2MultiPane.this.setCurrentViewer(null);
                }
            }
        });
        this.tab.addCTabFolder2Listener(new CTabFolder2Adapter(){

            @Override
            public void maximize(CTabFolderEvent event) {
                J2MultiPane.this.toggleMaximized();
            }

            @Override
            public void restore(CTabFolderEvent event) {
                J2MultiPane.this.toggleMaximized();
            }
        });
        this.tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                logger.finer("mouseDoubleClick(" + e + ")");
                CTabItem item = J2MultiPane.this.tab.getItem(new Point(e.x, e.y));
                if (item != null) {
                    J2MultiPane.this.toggleMaximized();
                }
            }
        });
        this.openTab();
    }

    @Override
    public void init() {
        super.init();
        Scrap scrap = this.app.scrap.subscrap("view.");
        this.setPluginExpand(scrap.getBoolean("plugins.expand", true));
        this.setAutoScroll(scrap.getBoolean("thread.autoScroll", true));
        this.setOpenEditing(scrap.getBoolean("contribute.expand", true));
        this.setRolloverPopup(scrap.getBoolean("rolloverPopup", true));
        this.setNGWord(scrap.getBoolean("ngWord", true));
    }

    @Override
    public void destroy() {
        Scrap scrap = this.app.scrap.subscrap("view.");
        this.closeAllTab();
        scrap.setBoolean("plugins.expand", this.horSplit.getMaximizedControl() == null);
        scrap.setBoolean("thread.autoScroll", this.autoScroll);
        scrap.setBoolean("contribute.expand", this.openEditing);
        scrap.setBoolean("rolloverPopup", this.rolloverPopup);
        super.destroy();
    }

    public void show(Thread thread) throws IOException {
        logger.finest("show(" + thread.getTitle() + ")");
        ThreadViewer view = this.getSelectedViewer();
        if (view == null) {
            view = this.openTab();
        }
        view.setThread(thread);
        this.setCurrentViewer(view);
        this.refresh(ThreadViewer.RefreshMode.RESUME);
        this.fireShowingURL();
    }

    public void show(URI uri, String target) throws IOException {
        logger.finest("show(" + uri + "," + target + ")");
        ThreadViewer viewer = this.getViewer(target);
        if (viewer == null) {
            viewer = this.openTab();
            if (!_BLANK.equals(target)) {
                viewer.setViewName(target);
            }
        }
        this.setSelectedViewer(viewer);
        viewer.show(uri);
        this.fireShowingURL();
    }

    public String getShowingURL() {
        if (this.selectedViewer == null) {
            return null;
        }
        return this.selectedViewer.getPageURL();
    }

    private void fireShowingURL() {
        Object oldValue = null;
        String newValue = this.getShowingURL();
        this.firePropertyChange("showingURL", oldValue, newValue);
    }

    public void edit(String text) {
        this.setOpenEditing(true);
        this.contribute.edit(text);
    }

    public ThreadViewer getSelectedViewer() {
        CTabItem ti = this.tab.getSelection();
        if (ti == null) {
            return null;
        }
        return (ThreadViewer)ti.getData();
    }

    public void setSelectedViewer(ThreadViewer viewer) {
        for (CTabItem item : this.tab.getItems()) {
            if (item.getData() != viewer) continue;
            this.setSelectedViewer(item);
            return;
        }
        logger.warning("\u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30ef\u30fc\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093");
    }

    private void setSelectedViewer(CTabItem item) {
        ThreadViewer viewer = item != null ? (ThreadViewer)item.getData() : null;
        ThreadViewer oldValue = this.selectedViewer;
        ThreadViewer newValue = viewer;
        this.tab.setSelection(item);
        this.selectedViewer = viewer;
        this.firePropertyChange("selectedViewer", oldValue, newValue);
        this.fireShowingURL();
    }

    public Thread getSelectedThread() {
        ThreadViewer c = this.getSelectedViewer();
        if (c == null) {
            return null;
        }
        return c.getThread();
    }

    public void setPluginExpand(boolean expand) {
        this.horSplit.setMaximizedControl(expand ? null : this.verSplit);
        for (ThreadViewer c : this.getAllViewer()) {
            c.toolbar.setPluginExpandButtonSelected(expand);
        }
        this.plugins.setExpand(expand);
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
        for (ThreadViewer c : this.getAllViewer()) {
            c.toolbar.setAutoScrollButtonSelected(autoScroll);
        }
    }

    public void setOpenEditing(boolean openEditing) {
        this.verSplit.setMaximizedControl(openEditing ? null : this.tab);
        this.contribute.setFocus();
        this.openEditing = openEditing;
        for (ThreadViewer c : this.getAllViewer()) {
            c.toolbar.setOpenEditingButtonSelected(openEditing);
        }
    }

    public void setRolloverPopup(boolean enable) {
        this.rolloverPopup = enable;
        for (ThreadViewer c : this.getAllViewer()) {
            c.toolbar.setRolloverPopupButtonSelected(this.rolloverPopup);
        }
    }

    public void setNGWord(boolean enable) {
        Config.getDefault().setNGWordEnabled(enable);
        for (ThreadViewer c : this.getAllViewer()) {
            c.toolbar.setNGWordButtonSelected(enable);
        }
    }

    public void setThumbnailEnabled(boolean enable) {
        Config.getDefault().setThumbnailEnabled(enable);
        for (ThreadViewer c : this.getAllViewer()) {
            c.toolbar.setThumbnailButtonSelected(enable);
        }
    }

    public void toggleMaximized() {
        this.setMaximized(!this.tab.getMaximized());
    }

    public void setMaximized(boolean maximized) {
        this.tab.setMaximized(maximized);
        this.getAppFrame().setThreadMaximized(maximized);
    }

    public void refresh(ThreadViewer.RefreshMode mode) {
        if (this.tab.getItemCount() == 0) {
            logger.fine("\u6709\u52b9\u306a\u30bf\u30d6\u304c\u5b58\u5728\u3057\u306a\u3044\u72b6\u614b\u3067\u518d\u8868\u793a\u304c\u5b9f\u884c\u3055\u308c\u307e\u3057\u305f");
            return;
        }
        if (this.selectedViewer != null) {
            this.selectedViewer.reload(mode);
        }
    }

    public ThreadViewer openTab() {
        logger.finest("openTab()");
        final CTabItem item = new CTabItem(this.tab, 64);
        item.setText("\u65b0\u898f\u30bf\u30d6");
        Config config = Config.getDefault();
        final ThreadViewer c = new ThreadViewer(this, this.tab);
        c.toolbar.setAutoScrollButtonSelected(this.autoScroll);
        c.toolbar.setPluginExpandButtonSelected(this.horSplit.getMaximizedControl() == null);
        c.toolbar.setOpenEditingButtonSelected(this.openEditing);
        c.toolbar.setRolloverPopupButtonSelected(this.rolloverPopup);
        c.toolbar.setNGWordButtonSelected(config.isNGWordEnabled());
        c.toolbar.setThumbnailButtonSelected(config.isThumbnailEnabled());
        item.setControl(c);
        item.setData(c);
        this.tab.setSelection(item);
        this.selectedViewer = c;
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("title")) {
                    J2MultiPane.this.setTabName(item, (String)evt.getNewValue());
                    if (c == J2MultiPane.this.getSelectedViewer()) {
                        J2MultiPane.this.setCurrentViewer(c);
                    }
                }
            }
        });
        c.internalInit();
        return c;
    }

    public void closeTab() {
        logger.finest("closeTab()");
        this.tab.getSelection().dispose();
    }

    public void closeAllTab() {
        logger.finest("closeAllTab()");
        for (CTabItem t : this.tab.getItems()) {
            t.dispose();
        }
        this.setCurrentViewer(null);
    }

    private void setCurrentViewer(ThreadViewer viewer) {
        logger.finest("setCurrentViewer(" + viewer + ")");
        this.selectedViewer = viewer;
        CTabItem i = this.tab.getSelection();
        if (viewer == null) {
            this.title.setText("");
            this.title.setToolTipText("");
            this.contribute.setThread(null);
        } else {
            this.setTabName(i, viewer.getTitle());
            String title = viewer.getTitle();
            Thread thread = viewer.getThread();
            if (thread != null) {
                this.title.setText("[" + thread.getBoard().getName() + "] " + thread.getTitle());
            } else {
                this.title.setText(title);
            }
            this.title.setToolTipText(title);
            this.contribute.setThread(thread);
        }
    }

    private void setTabName(CTabItem item, String title) {
        logger.finest("setTabName(" + item + "," + title + ")");
        assert (item != null);
        if (item.isDisposed()) {
            return;
        }
        if (title == null) {
            item.setText("\u65b0\u898f\u30bf\u30d6");
            item.setToolTipText("");
            return;
        }
        if (title.length() > 10) {
            item.setText(title.substring(0, 9) + "\u2026");
        } else if (title.length() > 0) {
            item.setText(title);
        } else {
            item.setText("\u7121\u984c");
        }
        item.setToolTipText(title);
    }

    private List<ThreadViewer> getAllViewer() {
        ArrayList<ThreadViewer> list = new ArrayList<ThreadViewer>();
        for (CTabItem ti : this.tab.getItems()) {
            if (!(ti.getData() instanceof ThreadViewer)) continue;
            list.add((ThreadViewer)ti.getData());
        }
        return list;
    }

    private ThreadViewer getViewer(String target) {
        if (target == null) {
            return this.selectedViewer;
        }
        if (target.equals(_BLANK)) {
            return null;
        }
        for (CTabItem ti : this.tab.getItems()) {
            ThreadViewer v;
            Object obj = ti.getData();
            if (!(obj instanceof ThreadViewer) || !target.equals((v = (ThreadViewer)obj).getViewName())) continue;
            return v;
        }
        return null;
    }
}

