/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Window;

public class J2Dialog
extends J2Window {
    private Label icon = null;
    private Composite messagePane = null;
    private Composite buttonPane = null;
    private Object[] options = null;
    private Button[] optionButtons = null;
    private Object defaultOption = null;
    private Object selectedOption = null;

    public J2Dialog(Composite parent) {
        this(parent, 67680);
    }

    public J2Dialog(Composite parent, int style) {
        super(parent == null ? GUI.getSystemComponent() : parent, style);
        this.initialize();
    }

    protected J2Dialog(Display display, int style) {
        super(display, style);
        this.initialize();
    }

    private void initialize() {
        this.setIcon(GUI.ICON_APP);
        this.setTitle("\u30c0\u30a4\u30a2\u30ed\u30b0");
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        this.setLayout(layout);
        this.setLayoutData(new GridData(1808));
        this.icon = new Label(this, 0);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        this.icon.setLayoutData(gd);
        this.messagePane = new Composite(this, 0);
        gd = new GridData(1808);
        this.messagePane.setLayoutData(gd);
        Label sep = new Label(this, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        sep.setLayoutData(gd);
        this.buttonPane = new Composite(this, 0);
        this.buttonPane.setLayout(new GridLayout(1, true));
        gd = new GridData(768);
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 0x1000000;
        gd.horizontalSpan = 2;
        this.buttonPane.setLayoutData(gd);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title + " - " + "Jive2ch");
    }

    public void setOptionIcon(Image icon) {
        this.icon.setImage(icon);
    }

    public Image getOptionIcon() {
        return this.icon.getImage();
    }

    public void setOptions(final Object ... options) {
        this.options = options;
        if (this.optionButtons != null) {
            for (Button b : this.optionButtons) {
                b.dispose();
            }
        }
        this.optionButtons = new Button[options.length];
        this.buttonPane.setLayout(new GridLayout(options.length, true));
        for (int i = 0; i < options.length; ++i) {
            final int index = i;
            this.optionButtons[i] = new Button(this.buttonPane, 8);
            this.optionButtons[i].setText(this.getButtonLabel(options[i]));
            this.optionButtons[i].setLayoutData(new GridData(768));
            SelectionAdapter l = new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    J2Dialog.this.selectedOption = options[index];
                    J2Dialog.this.close();
                }
            };
            this.optionButtons[i].addSelectionListener(l);
            this.optionButtons[i].setData("selectionListener", l);
            this.optionButtons[i].setData("availabel", Boolean.TRUE);
        }
        this.getShell().layout(true, true);
    }

    public Object[] getOptions() {
        return (Object[])this.options.clone();
    }

    public Button getOptionButton(Object option) {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(option)) continue;
            return this.optionButtons[i];
        }
        return null;
    }

    public void setOptionAvailable(Object option, boolean available) {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(option)) continue;
            SelectionListener l = (SelectionListener)this.optionButtons[i].getData("selectionListener");
            Boolean avail = (Boolean)this.optionButtons[i].getData("availabel");
            if (available != avail) {
                if (available) {
                    this.optionButtons[i].addSelectionListener(l);
                } else {
                    this.optionButtons[i].removeSelectionListener(l);
                }
                this.optionButtons[i].setData("availabel", available);
            }
            return;
        }
    }

    public Object getDefaultOption() {
        return this.defaultOption;
    }

    public void setDefaultOption(Object defaultOption) {
        if (defaultOption == null) {
            this.getShell().setDefaultButton(null);
            return;
        }
        Button button = null;
        for (int i = 0; i < this.options.length; ++i) {
            if (this.options[i] != defaultOption && (this.options[i] == null || !this.options[i].equals(defaultOption))) continue;
            button = this.optionButtons[i];
            break;
        }
        this.getShell().setDefaultButton(button);
    }

    public Object getSelectedOption() {
        return this.selectedOption;
    }

    protected Composite getMessagePane() {
        return this.messagePane;
    }

    protected String getButtonLabel(Object option) {
        if (option instanceof Option) {
            switch ((Option)((Object)option)) {
                case OK: {
                    return "OK";
                }
                case CANCEL: {
                    return "\u30ad\u30e3\u30f3\u30bb\u30eb";
                }
                case CONTINUE: {
                    return "\u7d9a\u884c";
                }
                case RETRY: {
                    return "\u518d\u5b9f\u884c";
                }
                case STOP: {
                    return "\u4e2d\u65ad";
                }
            }
            return option.toString();
        }
        return String.valueOf(option);
    }

    protected void onClose(Object option) {
    }

    @Override
    public void open() {
        this.open(true);
    }

    @Override
    public void open(boolean modal) {
        this.getShell().layout(true, true);
        this.getShell().pack(true);
        this.pack();
        this.layout(true, true);
        this.moveCenterOfDisplay();
        super.open(modal);
    }

    @Override
    public void close() {
        this.onClose(this.getSelectedOption());
        super.close();
    }

    public static enum Option {
        OK,
        CANCEL,
        CONTINUE,
        RETRY,
        STOP;

    }
}

