/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.gui.Jive2chFrame;
import org.koiroha.jive2ch.gui.dialog.MessageDialog;

public class J2Component
extends Composite {
    private static final Logger logger = Logger.getLogger(J2Component.class.getName());
    public final Jive2ch app;
    private final List<J2Component> child = new ArrayList<J2Component>();
    private final PropertyChangeSupport listener = new PropertyChangeSupport(this);

    protected J2Component(Shell shell, int style) {
        this((Composite)shell, style);
    }

    protected J2Component(Composite cmp, int style) {
        super(cmp, style);
        final J2Component parent = J2Component.findParent(cmp);
        if (parent != null) {
            parent.child.add(this);
            this.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent e) {
                    parent.child.remove(J2Component.this);
                }
            });
        }
        this.app = Jive2ch.getDefault();
        this.setLayout(J2Component.newGridLayout());
    }

    static J2Component findParent(Composite parent) {
        for (Composite mover = parent; mover != null; mover = mover.getParent()) {
            if (!(mover instanceof J2Component)) continue;
            logger.finest("\u30b5\u30d6\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8: " + parent.getClass().getSimpleName() + ": " + mover.getClass().getSimpleName());
            return (J2Component)mover;
        }
        logger.finest("\u30c8\u30c3\u30d7\u30ec\u30d9\u30eb\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8: " + parent.getClass().getSimpleName());
        return null;
    }

    public void init() {
    }

    public void destroy() {
    }

    void internalInit() {
        logger.finest("init(): " + this.getClass().getName());
        this.init();
        for (J2Component cmp : this.child) {
            cmp.internalInit();
        }
    }

    void internalDestroy() {
        for (J2Component cmp : this.child) {
            cmp.internalDestroy();
        }
        logger.finest("destroy(): " + this.getClass().getName());
        this.destroy();
    }

    void internalDispose() {
        if (!this.isDisposed()) {
            logger.finest("dispose(): " + this.getClass().getName());
            this.dispose();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        this.listener.firePropertyChange(e);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(propertyName + ": " + oldValue + " -> " + newValue);
        }
        this.listener.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Jive2chFrame getAppFrame() {
        J2Component parent = J2Component.findParent(this.getParent());
        if (parent != null) {
            return parent.getAppFrame();
        }
        assert (this instanceof Jive2chFrame) : "\u30c8\u30c3\u30d7\u30ec\u30d9\u30eb\u304c J2AppFrame \u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + this.getClass().getSimpleName();
        return (Jive2chFrame)this;
    }

    public static GridLayout newGridLayout() {
        return J2Component.newGridLayout(1, 0, 0, false);
    }

    public static GridLayout newGridLayout(int cols) {
        return J2Component.newGridLayout(cols, 0, 0, false);
    }

    public static GridLayout newGridLayout(int cols, int top, int left, int bottom, int right, boolean equalWidth) {
        GridLayout layout = new GridLayout();
        layout.marginTop = top;
        layout.marginBottom = bottom;
        layout.marginLeft = left;
        layout.marginRight = right;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = equalWidth;
        layout.numColumns = cols;
        return layout;
    }

    public static GridLayout newGridLayout(int cols, int width, int height, boolean equalWidth) {
        GridLayout layout = new GridLayout();
        layout.marginTop = height;
        layout.marginBottom = height;
        layout.marginLeft = width;
        layout.marginRight = width;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = width;
        layout.verticalSpacing = height;
        layout.makeColumnsEqualWidth = equalWidth;
        layout.numColumns = cols;
        return layout;
    }

    public static void messageBox(String message) {
        J2Component.messageBox(message, "\u30e1\u30c3\u30bb\u30fc\u30b8");
    }

    public static void messageBox(String message, String title) {
        J2Component.messageBox(message, title, null);
    }

    public static void messageBox(String message, String title, String desc) {
        Display display = Display.getDefault();
        MessageDialog dialog = new MessageDialog(GUI.getSystemComponent());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setOptionIcon(display.getSystemImage(2));
        if (desc == null) {
            dialog.setDescriptionVisible(false);
        } else {
            dialog.setDescription(desc);
            dialog.setDescriptionVisible(true);
        }
        dialog.open();
    }

    public static boolean confirm(String message, String title) {
        Display display = Display.getDefault();
        MessageDialog dialog = new MessageDialog(GUI.getSystemComponent());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setOptionIcon(display.getSystemImage(4));
        dialog.setDescriptionVisible(false);
        dialog.setOptions(new Object[]{J2Dialog.Option.OK, J2Dialog.Option.CANCEL});
        dialog.setDefaultOption((Object)J2Dialog.Option.OK);
        dialog.open();
        return dialog.getSelectedOption() == J2Dialog.Option.OK;
    }

    public static boolean confirm(String message, String title, String desc) {
        Display display = Display.getDefault();
        MessageDialog dialog = new MessageDialog(GUI.getSystemComponent());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setOptionIcon(display.getSystemImage(4));
        if (desc == null || desc.length() == 0) {
            dialog.setDescriptionVisible(false);
        } else {
            dialog.setDescription(desc);
            dialog.setDescriptionVisible(true);
        }
        dialog.setOptions(new Object[]{J2Dialog.Option.OK, J2Dialog.Option.CANCEL});
        dialog.setDefaultOption((Object)J2Dialog.Option.OK);
        dialog.open();
        return dialog.getSelectedOption() == J2Dialog.Option.OK;
    }

    public static void error(String msg) {
        J2Component.error(msg, null);
    }

    public static void error(String msg, Throwable ex) {
        if (ex != null) {
            ex.printStackTrace();
        }
        MessageDialog dialog = new MessageDialog(GUI.getSystemComponent());
        dialog.setTitle("\u30a8\u30e9\u30fc");
        dialog.setMessage(msg);
        if (ex != null) {
            dialog.setStackTrace(ex);
        }
        dialog.open();
    }

    public static void fatal(Throwable ex) {
        ex.printStackTrace();
        MessageDialog dialog = new MessageDialog(GUI.getSystemComponent());
        dialog.setTitle("Fatal Error");
        dialog.setOptionIcon(GUI.ICON_FATAL_DIALOG);
        dialog.setStackTrace(ex);
        dialog.setDescriptionVisible(true);
        dialog.open();
    }
}

