/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.FavouriteCategory;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.dialog.BoardPropertyDialog;
import org.koiroha.jive2ch.worker.BoardIconUpdateWorker;
import org.koiroha.jive2ch.worker.Launcher;
import org.koiroha.jive2ch.worker.Worker;

class J2CategoryTree
extends J2Component {
    private static final Logger logger = Logger.getLogger(J2CategoryTree.class.getName());
    private final Tree categories = new Tree(this, 2052);
    private final PropertyChangeListener propChange;

    public J2CategoryTree(Composite parent) {
        super(parent, 0);
        this.categories.setSize(200, 480);
        this.categories.setLinesVisible(false);
        this.categories.setLayoutData(new GridData(1808));
        this.categories.addListener(17, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.item instanceof TreeItem) {
                    TreeItem i = (TreeItem)event.item;
                    J2CategoryTree.this.setIcon(i, ((Category)i.getData()).getExpandIcon());
                }
            }
        });
        this.categories.addListener(18, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.item instanceof TreeItem) {
                    TreeItem i = (TreeItem)event.item;
                    J2CategoryTree.this.setIcon(i, ((Category)i.getData()).getCollapseIcon());
                }
            }
        });
        this.categories.addMenuDetectListener(new MenuDetectListener(){

            @Override
            public void menuDetected(MenuDetectEvent e) {
                Point p = J2CategoryTree.this.categories.toControl(e.x, e.y);
                TreeItem item = J2CategoryTree.this.categories.getItem(p);
                if (item.getData() instanceof Board) {
                    e.doit = false;
                    J2CategoryTree.this.popup(e.x, e.y);
                }
            }
        });
        this.categories.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                J2CategoryTree.this.onAction((TreeItem)e.item, true);
            }
        });
        this.categories.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                if (GUI.isLeftDoubleClick(e)) {
                    J2CategoryTree.this.onAction(J2CategoryTree.this.categories.getItem(new Point(e.x, e.y)), true);
                }
            }

            @Override
            public void mouseDown(MouseEvent e) {
                if (GUI.isLeftClick(e)) {
                    J2CategoryTree.this.onAction(J2CategoryTree.this.categories.getItem(new Point(e.x, e.y)), false);
                }
            }
        });
        this.propChange = GUI.wrapSWTInvoke(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Board b;
                TreeItem i;
                if (e.getSource() instanceof Board && e.getPropertyName().equals("icon") && (i = J2CategoryTree.this.itemOf(b = (Board)e.getSource())) != null) {
                    J2CategoryTree.this.setIcon(i, b.getIcon().getImage());
                }
            }
        }, PropertyChangeListener.class);
        this.updateCategories();
        DragSource ds = new DragSource(this.categories, 1);
        ds.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        ds.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragSetData(DragSourceEvent e) {
                TreeItem[] items = J2CategoryTree.this.categories.getSelection();
                if (items == null || items.length == 0 || !(items[0].getData() instanceof Board)) {
                    e.doit = false;
                    e.detail = 0;
                    return;
                }
                e.data = ((Board)items[0].getData()).getURI().toString();
                e.detail = 1;
            }
        });
        DropTarget dt = new DropTarget(this.categories, 17);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetEvent event) {
                J2CategoryTree.this.onDragOver(event);
            }

            @Override
            public void drop(DropTargetEvent event) {
                J2CategoryTree.this.dropDone((TreeItem)event.item, (String[])event.data);
            }
        });
    }

    public Board getSelectedBoard() {
        TreeItem[] i = this.categories.getSelection();
        if (i == null || i.length == 0 || i[0].getParentItem() == null) {
            return null;
        }
        return (Board)i[0].getData();
    }

    private void onAction(TreeItem i, boolean dblclick) {
        if (i != null) {
            if (i.getData() instanceof Board) {
                this.getAppFrame().setBoard((Board)i.getData());
            } else if (i.getData() instanceof Category && dblclick) {
                Category c = (Category)i.getData();
                i.setExpanded(!i.getExpanded());
                this.setIcon(i, i.getExpanded() ? c.getExpandIcon() : c.getCollapseIcon());
            }
        }
    }

    public void updateCategories() {
        Set<String> expand = this.getExpandedCategories();
        this.categories.removeAll();
        logger.finer("\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u304b\u3089\u30ab\u30c6\u30b4\u30ea\u4e00\u89a7\u3092\u524a\u9664");
        for (Category c : this.app.getCategoryList()) {
            TreeItem root = new TreeItem(this.categories, 0);
            root.setText(c.getName());
            root.setData(c);
            for (Board b : c.getBoards()) {
                this.createBoardNode(root, b);
            }
            if (expand.contains(c.getName())) {
                root.setExpanded(true);
                this.setIcon(root, c.getExpandIcon());
                continue;
            }
            root.setExpanded(false);
            this.setIcon(root, c.getCollapseIcon());
        }
        logger.finer("\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u306b\u30ab\u30c6\u30b4\u30ea\u4e00\u89a7\u3092\u518d\u69cb\u6210");
        BoardIconUpdateWorker worker = new BoardIconUpdateWorker(this.app.getCategoryList(), false);
        worker.addListener(GUI.wrapSWTInvoke(new Worker.Adapter<Board, Object>(){

            @Override
            public void processing(List<Board> value) {
                J2CategoryTree.this.setBoardIcon(value);
            }
        }, Worker.Listener.class));
        Launcher.start(worker);
    }

    public void updateFavourite(LocalBoard board) {
        TreeItem cat = null;
        for (TreeItem i : this.categories.getItems()) {
            if (!(i.getData() instanceof FavouriteCategory)) continue;
            cat = i;
            break;
        }
        if (cat == null) {
            logger.warning("\u304a\u6c17\u306b\u5165\u308a\u30ab\u30c6\u30b4\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            return;
        }
        cat.removeAll();
        for (Board b : this.app.favourite.getBoards()) {
            TreeItem item = this.createBoardNode(cat, b);
            if (b != board) continue;
            this.categories.setSelection(item);
        }
    }

    private TreeItem createBoardNode(TreeItem parent, Board board) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(board.getName());
        item.setData(board);
        this.setIcon(item, GUI.ICON_DEFAULT_BOARD);
        board.removePropertyChangeListener(this.propChange);
        board.addPropertyChangeListener(this.propChange);
        return item;
    }

    private void setBoardIcon(List<Board> boards) {
        for (Board b : boards) {
            TreeItem item = this.itemOf(b);
            if (item == null) continue;
            this.setIcon(item, b.getIcon().getImage());
        }
    }

    private void setIcon(TreeItem item, Image img) {
        if (img != null) {
            item.setImage(GUI.getFontScaledImage(img, item.getFont()));
        }
    }

    private TreeItem itemOf(Board board) {
        for (TreeItem cat : this.categories.getItems()) {
            assert (cat.getData() instanceof Category);
            for (TreeItem b : cat.getItems()) {
                assert (b.getData() instanceof Board);
                if (b.getData() != board) continue;
                return b;
            }
        }
        return null;
    }

    @Override
    public void init() {
        HashSet<String> expand = new HashSet<String>();
        StringTokenizer tk = new StringTokenizer(this.app.scrap.getString("category.expand", ""), "\n");
        while (tk.hasMoreTokens()) {
            String name = tk.nextToken();
            expand.add(name);
        }
        for (TreeItem i : this.categories.getItems()) {
            if (!(i.getData() instanceof Category)) continue;
            Category c = (Category)i.getData();
            if (expand.contains(c.getName())) {
                i.setExpanded(true);
                continue;
            }
            i.setExpanded(false);
        }
        super.init();
    }

    @Override
    public void destroy() {
        StringBuilder buffer = new StringBuilder();
        for (String name : this.getExpandedCategories()) {
            buffer.append(name);
            buffer.append('\n');
        }
        this.app.scrap.setString("category.expand", buffer.toString());
        super.destroy();
    }

    private Set<String> getExpandedCategories() {
        HashSet<String> expand = new HashSet<String>();
        TreeItem[] t = this.categories.getItems();
        for (int i = 0; t != null && i < t.length; ++i) {
            if (!t[i].getExpanded()) continue;
            expand.add(t[i].getText());
        }
        logger.finest("\u73fe\u5728\u958b\u3044\u3066\u3044\u308b\u30ab\u30c6\u30b4\u30ea: " + expand);
        return expand;
    }

    private void popup(int x, int y) {
        Point p = this.categories.toControl(x, y);
        TreeItem item = this.categories.getItem(p);
        if (item == null) {
            return;
        }
        if (item.getData() instanceof Board) {
            final Board board = (Board)item.getData();
            Menu menu = new Menu(this.categories.getShell(), 8);
            MenuItem mi = null;
            mi = new MenuItem(menu, 8);
            mi.setText("\u304a\u6c17\u306b\u5165\u308a\u30d0\u30fc\u306b\u8ffd\u52a0(&F)");
            mi.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    J2CategoryTree.this.getAppFrame().addFavourite(board);
                }
            });
            mi = new MenuItem(menu, 8);
            mi.setText("\u30d7\u30ed\u30d1\u30c6\u30a3(&P)");
            mi.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    J2CategoryTree.this.showBoardProperty(board);
                }
            });
            menu.setLocation(x, y);
            menu.setVisible(true);
            return;
        }
    }

    private void showBoardProperty(Board board) {
        BoardPropertyDialog dialog = new BoardPropertyDialog(this, board);
        dialog.open(true);
    }

    private void onDragOver(DropTargetEvent e) {
        TreeItem item = (TreeItem)e.item;
        if (item == null || !(item.getData() instanceof LocalBoard)) {
            e.detail = 0;
            return;
        }
        LocalBoard board = (LocalBoard)item.getData();
        if (!(board.getCategory() instanceof FavouriteCategory)) {
            e.detail = 0;
            return;
        }
        String[] files = (String[])e.data;
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].endsWith(".dat")) continue;
            e.detail = 0;
            return;
        }
        e.detail = 1;
    }

    private void dropDone(TreeItem item, String[] fileNames) {
        logger.finest("dropDone(" + item + "," + Arrays.toString(fileNames) + ")");
        if (!(item.getData() instanceof LocalBoard) || !(((Board)item.getData()).getCategory() instanceof FavouriteCategory)) {
            return;
        }
        LocalBoard board = (LocalBoard)item.getData();
        try {
            for (String fileName : fileNames) {
                File file = new File(fileName);
                Thread thread = this.app.getThreadByLocalFile(file);
                if (thread != null) {
                    board.addThread(thread);
                    logger.info("\u30c9\u30ed\u30c3\u30d7\u3055\u308c\u305f\u30b9\u30ec\u30c3\u30c9\u3092\u767b\u9332\u3057\u307e\u3057\u305f: " + fileName);
                    continue;
                }
                J2CategoryTree.messageBox("\u30c9\u30ed\u30c3\u30d7\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306f\u30b9\u30ec\u30c3\u30c9\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + file.getName());
            }
        }
        catch (IOException ex) {
            J2CategoryTree.fatal(ex);
        }
    }
}

