/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.util.AWT;
import org.koiroha.jive2ch.util.Debug;

public final class GUI {
    private static final Logger logger = Logger.getLogger(GUI.class.getName());
    private static final ThreadLocal<String> EDT = new ThreadLocal();
    private static J2Component SYSTEM_COMPONENT = null;
    private static final Timer SWT_EVENT_TIMER = new Timer("SWT Event Timer", true);
    private static Font AA_FONT = null;
    private static Map<Image, Map<Integer, Image>> IMAGE_CACHE = new HashMap<Image, Map<Integer, Image>>();
    private static Map<Image, Image> IMAGE_REV_CACHE = new HashMap<Image, Image>();
    public static final Image ICON_APP = GUI.loadImage("applications-internet.png");
    public static final Image ICON_APP64 = GUI.loadImage("applications-internet.png", 64, 64);
    public static final Image ICON_APP16 = GUI.loadImage("applications-internet.png", 16, 16);
    public static final Image ICON_FOLDER = GUI.loadImage("folder.png");
    public static final Image ICON_KIDOKU_UPDATED_THREAD = GUI.loadImage("Bullet_red.png");
    public static final Image ICON_KIDOKU_THREAD = GUI.loadImage("Bullet_green.png");
    public static final Image ICON_FATAL_DIALOG = GUI.loadImage("Dialog-warning-custom.svg.png");
    public static final Image ICON_ERROR_DIALOG = GUI.loadImage("Dialog-warning.svg.png");
    public static final Image ICON_NODE_EXPAND = GUI.loadImage("Bullet_toggle_plus.png");
    public static final Image ICON_NODE_COLLAPSE = GUI.loadImage("Bullet_toggle_minus.png");
    public static final Image ICON_FAVOURITE = GUI.loadImage("Star.png");
    public static final Image ICON_PLUGIN_DEFAULT = GUI.loadImage("Icons-mini-page_java.gif");
    public static final Image ICON_PLUGIN_EXPAND = GUI.loadImage("Icons-mini-icon_component.gif");
    public static final Image ICON_CATEGORY_EXPAND = GUI.loadImage("Book_open.png");
    public static final Image ICON_CATEGORY_COLLAPSE = GUI.loadImage("Book-silk.png");
    public static final Image ICON_DEFAULT_BOARD = GUI.loadImage("Page_white.png");
    public static final Image ICON_NEW_DOCUMENT = GUI.loadImage("document-new.png");
    public static final Image ICON_TRASH = GUI.loadImage("Bin.png");
    public static final Image ICON_LIST_ADD = GUI.loadImage("list-add.png");
    public static final Image ICON_LIST_REMOVE = GUI.loadImage("list-remove.png");
    public static final KeyListener DEFAULT_KEY_LISTENER = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.stateMask == Platform.META && e.character == 'A' && e.widget instanceof Text) {
                ((Text)e.widget).selectAll();
            }
        }
    };
    public static final FocusListener DEFAULT_FOCUS_LISTENER = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (e.widget instanceof Text) {
                ((Text)e.widget).selectAll();
            }
        }
    };

    private GUI() {
    }

    public static Image getFontScaledImage(Icon icon, Font font) {
        return GUI.getFontScaledImage(icon.getImage(), font);
    }

    public static Image getFontScaledImage(Image image, Font font) {
        int height = 1;
        for (FontData fd : font.getFontData()) {
            height = Math.max(height, fd.getHeight());
        }
        return GUI.getScaledImage(image, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getScaledImage(Image image, int size) {
        if (image == null) {
            return null;
        }
        int w = image.getBounds().width;
        int h = image.getBounds().height;
        if (w < size && h < size) {
            return image;
        }
        Map<Image, Map<Integer, Image>> map = IMAGE_CACHE;
        synchronized (map) {
            Map<Integer, Image> thumb = IMAGE_CACHE.get(image);
            if (thumb != null && thumb.containsKey(size)) {
                return thumb.get(size);
            }
        }
        Image newImage = null;
        try {
            ImageLoader l = new ImageLoader();
            l.data = new ImageData[]{image.getImageData()};
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            l.save(out, 5);
            byte[] bin = AWT.getImage(new ByteArrayInputStream(out.toByteArray()), size, size);
            newImage = new Image(image.getDevice(), new ByteArrayInputStream(bin));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Map<Image, Object> map2 = IMAGE_CACHE;
        synchronized (map2) {
            Map<Integer, Image> thumb = IMAGE_CACHE.get(image);
            if (thumb == null) {
                thumb = new HashMap<Integer, Image>();
                IMAGE_CACHE.put(image, thumb);
            }
            thumb.put(size, newImage);
        }
        map2 = IMAGE_REV_CACHE;
        synchronized (map2) {
            IMAGE_REV_CACHE.put(newImage, image);
        }
        return newImage;
    }

    public static Font deriveSize(Font font, float scale) {
        FontData[] fd1 = font.getFontData();
        FontData[] fd2 = new FontData[fd1.length];
        for (int i = 0; i < fd1.length; ++i) {
            fd2[i] = new FontData(fd1[i].getName(), (int)((float)fd1[i].getHeight() * scale), fd1[i].getStyle());
        }
        return new Font(font.getDevice(), fd2);
    }

    public static Font deriveFontSize(Control cmp, float scale) {
        return GUI.deriveSize(cmp.getFont(), scale);
    }

    public static Font deriveStyle(Font font, int style) {
        assert (style == 0 || style == 2 || style == 1 || style == 3);
        FontData[] fd1 = font.getFontData();
        FontData[] fd2 = new FontData[fd1.length];
        for (int i = 0; i < fd1.length; ++i) {
            fd2[i] = new FontData(fd1[i].getName(), fd1[i].getHeight(), style);
        }
        return new Font(font.getDevice(), fd2);
    }

    public static int getStyle(Font font) {
        FontData[] fd = font.getFontData();
        int style = 0;
        for (int i = 0; i < fd.length; ++i) {
            style |= fd[i].getStyle();
        }
        return style;
    }

    public static Font deriveStyle(Control cmp, int style) {
        return GUI.deriveStyle(cmp.getFont(), style);
    }

    public static Font getAAFont() {
        if (AA_FONT == null) {
            Display display = Display.getDefault();
            FontData[] fd = display.getFontList("Mona", true);
            if (fd == null || fd.length == 0) {
                fd = display.getFontList("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", true);
            }
            if (fd == null || fd.length == 0) {
                fd = display.getFontList("Osaka", true);
            }
            for (int i = 0; i < fd.length; ++i) {
                fd[i].setHeight(12);
                fd[i].setStyle(0);
            }
            AA_FONT = new Font((Device)Display.getDefault(), fd);
        }
        return AA_FONT;
    }

    public static boolean isEventDispatchThread() {
        return EDT.get() != null;
    }

    static void setEventDispatchThread(boolean edt) {
        Thread current = Thread.currentThread();
        if (edt) {
            EDT.set(current.getName());
            current.setName("SWT-EDT");
        } else {
            current.setName(EDT.get());
            EDT.set(null);
        }
    }

    public static J2Component getSystemComponent() {
        return SYSTEM_COMPONENT;
    }

    static void setSystemComponent(J2Component cmp) {
        assert (cmp == null && SYSTEM_COMPONENT != null || cmp != null && SYSTEM_COMPONENT == null);
        SYSTEM_COMPONENT = cmp;
    }

    public static <T> T wrapSWTInvoke(T obj, Class<?> ... clazz) {
        Object t = Proxy.newProxyInstance(GUI.class.getClassLoader(), clazz, (InvocationHandler)new SWTInvoker(obj));
        return (T)t;
    }

    public static void schedule(SWTTimerTask task, long delay) {
        logger.finest("schedule(" + task.getClass().getSimpleName() + "," + delay + ")");
        if (delay < 0L) {
            logger.log(Level.WARNING, "\u30bf\u30a4\u30de\u30fc\u306e\u5f85\u3061\u6642\u9593\u6307\u5b9a\u306b\u8ca0\u306e\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + delay);
            logger.log(Level.WARNING, "\u5f85\u3061\u6642\u9593 0 [ms]\u3068\u3057\u3066\u52d5\u4f5c\u3057\u307e\u3059", new Exception());
            delay = 0L;
        }
        SWT_EVENT_TIMER.schedule((TimerTask)task, delay);
    }

    public static void schedule(SWTTimerTask task, Date time) {
        logger.finest("schedule(" + task.getClass().getSimpleName() + "," + time + ")");
        SWT_EVENT_TIMER.schedule((TimerTask)task, time);
    }

    public static void scheduleAtFixedRate(SWTTimerTask task, long delay, long period) {
        logger.finest("scheduleAtFixedRate(" + task.getClass().getSimpleName() + "," + delay + "," + period + ")");
        if (delay < 0L) {
            logger.log(Level.WARNING, "\u30bf\u30a4\u30de\u30fc\u306e\u5f85\u3061\u6642\u9593\u6307\u5b9a\u306b\u8ca0\u306e\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + delay);
            logger.log(Level.WARNING, "\u5f85\u3061\u6642\u9593 0 [ms]\u3068\u3057\u3066\u52d5\u4f5c\u3057\u307e\u3059", new Exception());
            delay = 0L;
        }
        SWT_EVENT_TIMER.scheduleAtFixedRate((TimerTask)task, delay, period);
    }

    public static void setFontSize(Composite composite, FontSize fs) {
        fs.setFont(composite);
        for (Control c : composite.getChildren()) {
            Composite t;
            if (c instanceof Composite) {
                Composite cmp = (Composite)c;
                GUI.setFontSize(cmp, fs);
            } else {
                fs.setFont(c);
            }
            if (c instanceof Button && ((Button)c).getImage() != null) {
                Button b = (Button)c;
                if (b.getText() == null || b.getText().length() <= 0) continue;
                Image img = IMAGE_REV_CACHE.get(b.getImage());
                if (img == null) {
                    img = b.getImage();
                }
                b.setImage(GUI.getFontScaledImage(img, b.getFont()));
                continue;
            }
            if (c instanceof Tree) {
                t = (Tree)c;
                for (Item item : ((Tree)t).getItems()) {
                    Image icon = ((TreeItem)item).getImage();
                    if (icon == null) continue;
                    Image img = IMAGE_REV_CACHE.get(icon);
                    if (img == null) {
                        img = icon;
                    }
                    ((TreeItem)item).setImage(GUI.getFontScaledImage(img, t.getFont()));
                }
                continue;
            }
            if (!(c instanceof Table)) continue;
            t = (Table)c;
            for (Item item : ((Table)t).getItems()) {
                for (int i = 0; i < ((Table)t).getColumnCount(); ++i) {
                    Image icon = ((TableItem)item).getImage(i);
                    if (icon == null) continue;
                    Image img = IMAGE_REV_CACHE.get(icon);
                    if (img == null) {
                        img = icon;
                    }
                    ((TableItem)item).setImage(i, GUI.getFontScaledImage(img, t.getFont()));
                }
            }
        }
        composite.layout(true, true);
    }

    public static void copyToClipboard(String text) {
        Display display = Display.getDefault();
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    public static boolean isKeyStroke(KeyEvent e, int meta, char ch) {
        return e.stateMask == meta && Character.toLowerCase(ch) == Character.toLowerCase(e.character);
    }

    public static boolean isLeftClick(MouseEvent e) {
        return e.button == 1 && e.count == 1;
    }

    public static boolean isLeftDoubleClick(MouseEvent e) {
        return e.button == 1 && e.count == 2;
    }

    public static boolean isRightClick(MouseEvent e) {
        return e.button == 3 && e.count == 1;
    }

    public static String toString(KeyEvent e) {
        StringBuilder buffer = new StringBuilder();
        int stateMask = e.stateMask;
        buffer.append(Platform.getPlatform().getKeyStrokeLabel(stateMask));
        if (buffer.length() > 0) {
            buffer.append('+');
        }
        buffer.append(Debug.literal(e.character));
        return buffer.toString();
    }

    public static boolean equals(Color c1, Color c2) {
        return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
    }

    private static Image loadImage(String fileName) {
        return Resource.loadImage(Display.getDefault(), fileName);
    }

    private static Image loadImage(String fileName, int width, int height) {
        return Resource.loadImage(Display.getDefault(), fileName, width, height);
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... param) {
        try {
            return clazz.getMethod(name, param);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static /* synthetic */ Method access$000(Class x0, String x1, Class[] x2) {
        return GUI.getMethod(x0, x1, x2);
    }

    public static class ResizeWeight
    extends ControlAdapter {
        private final int style;
        private final SashForm sash;
        private final Control[] ctrl;
        private int[] size = null;
        private final double[] weight;

        public ResizeWeight(SashForm sash, double ... w) {
            int mask = 768;
            this.style = sash.getStyle() & mask;
            assert (this.style != mask && this.style != 0);
            this.sash = sash;
            sash.addControlListener(this);
            ArrayList<Control> list = new ArrayList<Control>();
            for (Control c : sash.getChildren()) {
                logger.finest(c.getClass().getName());
                if (c instanceof Sash) continue;
                c.addControlListener(this);
                list.add(c);
            }
            this.ctrl = list.toArray(new Control[list.size()]);
            this.weight = w;
            assert (this.ctrl.length == this.weight.length) : this.ctrl.length + " != " + this.weight.length;
            this.size = new int[this.ctrl.length];
            for (int i = 0; i < this.ctrl.length; ++i) {
                this.size[i] = this.length(this.ctrl[i]);
            }
        }

        @Override
        public void controlResized(ControlEvent e) {
            if (e.widget == this.sash) {
                this.sashResized();
            } else if (e.getSource() instanceof Control) {
                this.controlResized((Control)e.getSource());
            }
        }

        private void sashResized() {
            int i;
            int childTotalWidth = 0;
            for (int i2 = 0; i2 < this.size.length; ++i2) {
                childTotalWidth += this.size[i2];
            }
            int diff = this.length(this.sash) - childTotalWidth;
            boolean tooSmall = false;
            int[] resize = new int[this.ctrl.length];
            for (i = 0; i < this.size.length; ++i) {
                resize[i] = (int)((double)this.size[i] + (double)diff * this.weight[i]);
                tooSmall = tooSmall || resize[i] <= 24;
            }
            if (tooSmall) {
                for (i = 0; i < this.size.length; ++i) {
                    this.size[i] = this.length(this.ctrl[i]);
                }
                return;
            }
            this.sash.setWeights(resize);
            this.size = resize;
        }

        private void controlResized(Control control) {
            for (int i = 0; i < this.ctrl.length; ++i) {
                if (control != this.ctrl[i]) continue;
                this.size[i] = this.length(control);
                break;
            }
        }

        private int length(Control ctrl) {
            if (this.style == 256) {
                return ctrl.getBounds().width;
            }
            return ctrl.getBounds().height;
        }
    }

    private static class SWTInvoker
    implements InvocationHandler {
        private static final Method EQUALS = GUI.access$000(Object.class, "equals", new Class[]{Object.class});
        private final Object obj;

        public SWTInvoker(Object obj) {
            assert (obj != null);
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (EQUALS.equals(method) && args[0] != null && Proxy.isProxyClass(args[0].getClass())) {
                InvocationHandler h = Proxy.getInvocationHandler(args[0]);
                if (h instanceof SWTInvoker) {
                    return this.obj.equals(((SWTInvoker)h).obj);
                }
                logger.warning("\u52d5\u7684\u30d7\u30ed\u30ad\u30b7\u306b\u5bfe\u3057\u3066equals()\u304c\u547c\u3070\u308c\u307e\u3057\u305f\u3051\u3069\u5927\u4e08\u592b?: " + this.obj + " <-> " + args[0]);
            }
            if (GUI.isEventDispatchThread()) {
                return method.invoke(this.obj, args);
            }
            final Object[] result = new Object[1];
            final Throwable[] exception = new Throwable[1];
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        assert (SWTInvoker.this.obj != null);
                        assert (args != null);
                        result[0] = method.invoke(SWTInvoker.this.obj, args);
                    }
                    catch (Throwable ex) {
                        logger.log(Level.WARNING, "\u30e1\u30bd\u30c3\u30c9\u306e\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
                        J2Component.fatal(ex);
                        exception[0] = ex;
                    }
                }
            };
            Display display = Display.getDefault();
            if (method.getReturnType().equals(Void.TYPE)) {
                display.asyncExec(r);
            } else {
                display.syncExec(r);
            }
            if (exception[0] != null) {
                throw exception[1];
            }
            return result[0];
        }
    }

    public static class SWTTimerTask
    extends TimerTask {
        private final Display display;

        public SWTTimerTask() {
            this(Display.getCurrent());
        }

        public SWTTimerTask(Display display) {
            this.display = display;
        }

        @Override
        public final void run() {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        SWTTimerTask.this.asyncExec();
                    }
                    catch (Exception ex) {
                        J2Component.fatal(ex);
                    }
                }
            });
        }

        public void asyncExec() {
        }
    }

    public static enum FontSize {
        X_LARGE("\u6700\u5927", 'G', 18, 1.25f),
        LARGE("\u5927", 'L', 16, 1.1f),
        MEDIUM("\u4e2d", 'M', 14, 1.0f),
        SMALL("\u5c0f", 'S', 12, 0.9f),
        X_SMALL("\u6700\u5c0f", 'A', 11, 0.8f);

        private final String label;
        private final char shortcut;
        private final int size;
        private final float scale;

        private FontSize(String label, char shortcut, int size, float scale) {
            this.label = label;
            this.shortcut = shortcut;
            this.size = size;
            this.scale = scale;
        }

        public void setFont(Control ctrl) {
            Font defaultFont = (Font)ctrl.getData("default-font");
            if (defaultFont == null) {
                defaultFont = ctrl.getFont();
                ctrl.setData("default-font", defaultFont);
            }
            Font newFont = GUI.deriveSize(defaultFont, this.scale);
            Font oldFont = ctrl.getFont();
            ctrl.setFont(newFont);
            if (oldFont != defaultFont) {
                oldFont.dispose();
            }
        }

        public int getSize() {
            return this.size;
        }

        public Font deriveFont(Font font) {
            return GUI.deriveSize(font, this.scale);
        }

        public char getShortcut() {
            return this.shortcut;
        }

        public String toString() {
            return this.label;
        }
    }
}

