/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.J2Bean;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.util.IO;

public class FavouriteBar
extends J2Component {
    private static final Logger logger = Logger.getLogger(FavouriteBar.class.getName());
    private final List<J2Bean> favourite = new ArrayList<J2Bean>();
    private final Composite toolbar;
    private final DnD dnd = new DnD();
    private final SelectionListener listener = new SelectionAdapter(){

        @Override
        public void widgetSelected(SelectionEvent e) {
            FavouriteBar.this.action(e.widget);
        }
    };

    public FavouriteBar(Composite cmp) {
        super(cmp, 0);
        this.toolbar = new Composite(this, 0);
        this.toolbar.setLayoutData(new GridData(768));
        this.toolbar.setFont(GUI.deriveFontSize(this.toolbar, 0.7f));
        RowLayout layout = new RowLayout(256);
        layout.fill = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.spacing = 3;
        layout.fill = true;
        layout.wrap = true;
        this.toolbar.setLayout(layout);
        this.favourite.add(this.app.appCategory);
        this.favourite.add(this.app.favourite);
        this.favourite.add(null);
        this.rebuild();
        DropTarget dt = new DropTarget(this.toolbar, 5);
        dt.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        dt.addDropListener(this.dnd);
        this.toolbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                Button item = FavouriteBar.this.getButton(e.x, e.y);
                if (GUI.isRightClick(e) && item != null) {
                    FavouriteBar.this.showPopupMenu(item, FavouriteBar.this.toolbar.toDisplay(e.x, e.y));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void init() {
        block8: {
            super.init();
            File file = this.app.repository.favouriteFile;
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(file));
                while ((line = in.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    this.add(line);
                }
                IO.close(in);
            }
            catch (FileNotFoundException ex) {
                IO.close(in);
            }
            catch (IOException ex2) {
                FavouriteBar.fatal(ex2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IO.close(in);
            }
        }
        this.rebuild();
    }

    private void add(String uri) {
        this.insert(uri, null);
    }

    private void insert(String uri, J2Bean ref) {
        J2Bean obj = this.getJ2Bean(uri);
        if (obj == null) {
            logger.warning("URL\u306b\u5bfe\u3059\u308b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093: " + uri);
            return;
        }
        if (ref == null) {
            this.favourite.add(obj);
        } else {
            int i = this.favourite.indexOf(ref);
            if (i >= 0) {
                this.favourite.add(i, obj);
            } else {
                this.favourite.add(obj);
            }
        }
    }

    private J2Bean getJ2Bean(String uri) {
        Board board = null;
        try {
            URI u = new URI(uri);
            board = this.app.getBoardByURI(u);
            if (board != null) {
                return board;
            }
        }
        catch (Exception ex) {
            FavouriteBar.fatal(ex);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.app.repository.favouriteFile));
            for (Control c : this.toolbar.getChildren()) {
                if (!(c instanceof Button) || this.isSystemButton((Button)c) || !(c.getData() instanceof Board)) continue;
                Board board = (Board)c.getData();
                out.println(board.getURI());
            }
            IO.close(out);
        }
        catch (IOException ex) {
            FavouriteBar.fatal(ex);
        }
        finally {
            IO.close(out);
        }
        super.destroy();
    }

    public void addBoard(Board board) {
        this.favourite.add(board);
        this.rebuild();
    }

    private void rebuild() {
        for (Control c : this.toolbar.getChildren()) {
            c.dispose();
        }
        for (J2Bean obj : this.favourite) {
            if (obj == null) {
                RowData rd = new RowData();
                rd.height = 1;
                Label sep = new Label(this.toolbar, 514);
                sep.setLayoutData(rd);
                continue;
            }
            if (obj instanceof Category) {
                this.create((Category)obj);
                continue;
            }
            if (obj instanceof Board) {
                this.create((Board)obj);
                continue;
            }
            assert (false);
        }
        this.layout(true, true);
    }

    private Button create(Category cat) {
        Image image = null;
        image = cat == this.app.appCategory ? GUI.ICON_APP16 : (cat == this.app.favourite ? GUI.ICON_FAVOURITE : cat.getCollapseIcon());
        Button item = this.create(cat.getName(), image);
        item.setData(cat);
        item.addSelectionListener(this.listener);
        return item;
    }

    private Button create(Board board) {
        final Button item = this.create(board.getName(), board.getIcon().getImage());
        item.setToolTipText(board.getURI().toString());
        item.setData(board);
        item.addSelectionListener(this.listener);
        board.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("icon") || e.getPropertyName().equals("name")) {
                    Board board = (Board)e.getSource();
                    item.setText(board.getName());
                    item.setImage(board.getIcon().getImage(16));
                }
            }
        });
        return item;
    }

    private Button create(String name, Image image) {
        final Button item = new Button(this.toolbar, 0x800000);
        item.setText(name);
        item.setFont(GUI.deriveFontSize(item, 0.8f));
        if (image != null) {
            item.setImage(GUI.getFontScaledImage(image, item.getFont()));
        }
        item.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                if (GUI.isRightClick(e)) {
                    FavouriteBar.this.showPopupMenu(item, item.toDisplay(e.x, e.y));
                }
            }
        });
        DragSource ds = new DragSource(item, 17);
        ds.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        ds.addDragListener(this.dnd);
        DropTarget dt = new DropTarget(item, 5);
        dt.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        dt.addDropListener(this.dnd);
        return item;
    }

    private void action(Widget item) {
        if (item.getData() instanceof Board) {
            Board board = (Board)item.getData();
            this.getAppFrame().setBoard(board);
            return;
        }
        if (item.getData() instanceof Category && item instanceof Control) {
            Menu menu = new Menu(this.toolbar);
            for (Board b : ((Category)item.getData()).getBoards()) {
                MenuItem mi = new MenuItem(menu, 8);
                mi.setText(b.getName());
                mi.setData(b);
                mi.setImage(b.getIcon().getImage(16));
                mi.addSelectionListener(this.listener);
            }
            Control ctrl = (Control)item;
            int x = ctrl.getBounds().x;
            int y = ctrl.getBounds().y + ctrl.getBounds().height;
            menu.setLocation(this.toolbar.toDisplay(x, y));
            menu.setVisible(true);
        }
    }

    private void showPopupMenu(final Button item, Point p) {
        Menu menu = new Menu(this.toolbar);
        MenuItem mi = new MenuItem(menu, 8);
        mi.setText("\u304a\u6c17\u306b\u5165\u308a\u304b\u3089\u524a\u9664");
        mi.setImage(GUI.ICON_TRASH);
        mi.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                item.dispose();
                FavouriteBar.this.layout(true, true);
            }
        });
        mi.setEnabled(!this.isSystemButton(item));
        menu.setLocation(p);
        menu.setVisible(true);
    }

    private boolean isSystemButton(Button item) {
        return item.getData() == this.app.appCategory || item.getData() == this.app.favourite;
    }

    private Button getButton(int x, int y) {
        for (Control c : this.toolbar.getChildren()) {
            Rectangle b = c.getBounds();
            if (!(c instanceof Button) || !b.contains(x, y)) continue;
            return (Button)c;
        }
        return null;
    }

    private void move(J2Bean obj, J2Bean ref) {
        assert (obj != null);
        if (obj == ref) {
            return;
        }
        this.favourite.remove(obj);
        if (ref == null) {
            this.favourite.add(obj);
        } else {
            int i = this.favourite.indexOf(ref);
            if (i >= 0) {
                this.favourite.add(i, obj);
            } else {
                this.favourite.add(obj);
            }
        }
        this.rebuild();
    }

    private class DnD
    extends DropTargetAdapter
    implements DragSourceListener {
        private Button item = null;

        private DnD() {
        }

        @Override
        public void dragStart(DragSourceEvent event) {
            logger.finest("dragStart(" + event + ")");
            this.item = (Button)((DragSource)event.widget).getControl();
            if (this.item == null || this.item.getData() == FavouriteBar.this.app.appCategory || this.item.getData() == FavouriteBar.this.app.favourite) {
                event.doit = false;
                event.detail = 0;
            } else {
                event.detail = 1;
                event.image = this.item.getImage();
            }
        }

        @Override
        public void dragSetData(DragSourceEvent event) {
            logger.finest("dragSetData(" + event + ")");
            if (this.item != null && this.item.getData() instanceof Board) {
                event.data = ((Board)this.item.getData()).getURI().toString();
            }
        }

        @Override
        public void dragFinished(DragSourceEvent event) {
            logger.finest("dragFinished(" + event + ")");
            if (this.item != null && !this.item.isDisposed()) {
                this.item.setEnabled(true);
            }
            FavouriteBar.this.getShell().setFocus();
            this.item = null;
        }

        @Override
        public void dragEnter(DropTargetEvent e) {
            logger.finest("dragEnter(" + e + ")");
            e.detail = 1;
        }

        @Override
        public void drop(DropTargetEvent e) {
            logger.finest("drop(" + e + ")");
            Widget ref = null;
            for (Control c : FavouriteBar.this.toolbar.getChildren()) {
                Rectangle b = c.getBounds();
                if (!(c instanceof Button) || e.x >= b.x + b.width / 2) continue;
                ref = (Button)c;
                break;
            }
            if (this.item == null && e.data != null) {
                if (ref == null) {
                    FavouriteBar.this.add((String)e.data);
                } else {
                    FavouriteBar.this.insert((String)e.data, (J2Bean)ref.getData());
                }
                FavouriteBar.this.rebuild();
                return;
            }
            if (this.item != null) {
                final J2Bean obj = (J2Bean)this.item.getData();
                final J2Bean r = ref != null ? (J2Bean)ref.getData() : null;
                Display display = FavouriteBar.this.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FavouriteBar.this.move(obj, r);
                    }
                });
            }
        }
    }
}

