/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.Skin;
import org.koiroha.jive2ch.util.Debug;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.jive2ch.util.XML;
import org.koiroha.xml.Html;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.HTMLDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XsltSkin
extends Skin {
    private static final Logger logger = Logger.getLogger(XsltSkin.class.getName());
    private final Templates templates;

    public XsltSkin(File file, PrintWriter out) throws TransformerException {
        super(file);
        EL el = new EL(out);
        logger.finer("XSL \u30b9\u30ad\u30f3\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059: " + file);
        Document xsl = null;
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            f.setXIncludeAware(true);
            DocumentBuilder b = f.newDocumentBuilder();
            b.setErrorHandler(el);
            xsl = b.parse(file);
        }
        catch (SAXException ex) {
            throw new TransformerException("XML\u69cb\u6587\u304c\u4e0d\u6b63\u3067\u3059", ex);
        }
        catch (Exception ex) {
            throw new TransformerException("XSL\u3092\u30b3\u30f3\u30d1\u30a4\u30eb\u3067\u304d\u307e\u305b\u3093", ex);
        }
        DOMSource src = new DOMSource(xsl);
        src.setSystemId(file.toURI().toString());
        TransformerFactory f = TransformerFactory.newInstance();
        f.setErrorListener(new EL(out));
        this.templates = f.newTemplates(src);
    }

    @Override
    public void convert(Writer out, Response res, Map<String, String> param) throws IOException {
        Document xml = XML.newDocument();
        XsltSkin.buildXML(xml, xml, res);
        DOMSource src = new DOMSource(xml);
        StreamResult rs = new StreamResult(out);
        this.transform(src, rs, param);
    }

    @Override
    public void convert(Writer out, Thread thread, Map<String, String> param, Pointer ptr) throws IOException {
        Document xml = XML.newDocument();
        Element t = xml.createElement("thread");
        xml.appendChild(t);
        if (thread != null) {
            t.setAttribute("title", thread.getTitle());
            for (Response res : ptr.pickup(thread.getResponse())) {
                XsltSkin.buildXML(xml, t, res);
                t.appendChild(xml.createTextNode("\n"));
            }
        } else {
            t.setAttribute("title", "");
        }
        this.transform(out, xml, param);
    }

    private void transform(Writer out, Document xml, Map<String, String> param) throws IOException {
        DOMSource src = new DOMSource(xml);
        StreamResult rs = new StreamResult(out);
        try {
            this.transform(src, rs, param);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30da\u30fc\u30b8\u306e\u57fa\u672cHTML\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String st = Xml.escape(sw.toString());
            out.append("<html><body><div id=\"content\"></div><div><b>XSL\u5909\u63db\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f</b><pre>" + Html.escape(st) + "</pre></div></body></html>");
        }
    }

    private void transform(Source src, Result rs, Map<String, String> param) throws IOException {
        try {
            Transformer t = this.templates.newTransformer();
            for (Map.Entry<String, String> e : param.entrySet()) {
                t.setParameter(e.getKey(), e.getValue());
            }
            t.transform(src, rs);
        }
        catch (TransformerException ex) {
            throw new IOException(ex.toString());
        }
    }

    private static void buildXML(Document xml, Node parent, Response res) {
        Config config = Config.getDefault();
        Element message = xml.createElement("response");
        parent.appendChild(message);
        if (res.isNew()) {
            message.setAttribute("new", "New!");
        }
        if (res.isNG() && config.isNGWordEnabled()) {
            message.setAttribute("ng", config.isTransparentAbone() ? "transparent" : "abone");
        }
        message.appendChild(xml.createTextNode("\n"));
        class Util {
            final /* synthetic */ Document val$xml;

            Util(Document document) {
                this.val$xml = document;
            }

            public Element create(String name, String text) {
                Element e = this.val$xml.createElement(name);
                e.appendChild(this.val$xml.createTextNode(text));
                return e;
            }
        }
        Util util = new Util(xml);
        Element number = xml.createElement("number");
        message.appendChild(xml.createTextNode("\t"));
        message.appendChild(number);
        message.appendChild(xml.createTextNode("\n"));
        number.appendChild(xml.createTextNode(String.valueOf(res.getNumber())));
        String author = res.getAuthor();
        author = Html.unescape(author);
        Element name = xml.createElement("name");
        message.appendChild(xml.createTextNode("\t"));
        message.appendChild(name);
        message.appendChild(xml.createTextNode("\n"));
        name.appendChild(xml.createTextNode(author));
        XsltSkin.clusterAll(name, "fusianasan", "</[bB]>([^<]*)<[bB]>", "$1");
        Element mail = xml.createElement("mail");
        message.appendChild(xml.createTextNode("\t"));
        message.appendChild(mail);
        message.appendChild(xml.createTextNode("\n"));
        mail.appendChild(xml.createTextNode(res.getMail()));
        Date d = res.getDate();
        if (d != null) {
            Element date = xml.createElement("date");
            message.appendChild(xml.createTextNode("\t"));
            message.appendChild(date);
            message.appendChild(xml.createTextNode("\n"));
            date.setAttribute("utc", String.valueOf(d.getTime()));
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            date.appendChild(util.create("tY", new SimpleDateFormat("yyyy").format(d)));
            date.appendChild(xml.createTextNode("/"));
            date.appendChild(util.create("tM", new SimpleDateFormat("MM").format(d)));
            date.appendChild(xml.createTextNode("/"));
            date.appendChild(util.create("tD", new SimpleDateFormat("dd").format(d)));
            date.appendChild(xml.createTextNode("("));
            date.appendChild(util.create("tE", new SimpleDateFormat("E").format(d)));
            date.appendChild(xml.createTextNode(") "));
            date.appendChild(util.create("th", new SimpleDateFormat("HH").format(d)));
            date.appendChild(xml.createTextNode(":"));
            date.appendChild(util.create("tm", new SimpleDateFormat("mm").format(d)));
            date.appendChild(xml.createTextNode(":"));
            date.appendChild(util.create("ts", new SimpleDateFormat("ss").format(d)));
            date.appendChild(xml.createTextNode("."));
            date.appendChild(util.create("tS", new SimpleDateFormat("SSS").format(d)));
        }
        Element misc = xml.createElement("misc");
        message.appendChild(xml.createTextNode("\t"));
        message.appendChild(misc);
        message.appendChild(xml.createTextNode("\n"));
        misc.appendChild(xml.createTextNode(res.getMisc()));
        if (res.getId() != null) {
            XsltSkin.clusterAll(misc, "id", Pattern.quote("ID:" + res.getId()), "$0");
        }
        if (res.getBe() != null) {
            XsltSkin.clusterAll(misc, "be", Pattern.quote("BE:" + res.getBe()), "$0");
        }
        Element c = xml.createElement("content");
        message.appendChild(xml.createTextNode("\t"));
        message.appendChild(c);
        message.appendChild(xml.createTextNode("\n"));
        String content = res.getContent();
        XsltSkin.setContent(c, content);
        if (res.isAsciiArt()) {
            c.setAttribute("aa", "aa");
        }
        XsltSkin.clusterAll(c, "span", "<font\\s+color=\"([^\"]*)\">", "$0");
        XsltSkin.clusterAll(c, "id", "ID:[a-zA-Z0-9+/\\.]{6,10}", "$0");
        XsltSkin.clusterBeIcon(c);
        XsltSkin.clusterLink(c);
        Debug.dump("\u5909\u63db\u5bfe\u8c61\u306eXML", xml);
    }

    private static void clusterBeIcon(Element elem) {
        String regex = "sssp://([\\S]*)";
        XsltSkin.clusterAll(elem, "img", regex, "$0");
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            if (!(nl.item(i) instanceof Element) || !(e = (Element)nl.item(i)).getTagName().equals("img") || !e.getTextContent().matches(regex)) continue;
            String href = "http://" + e.getTextContent().replaceAll(regex, "$1");
            e.setAttribute("src", href);
            while (e.getChildNodes().getLength() > 0) {
                e.removeChild(e.getFirstChild());
            }
        }
    }

    private static void clusterLink(Element elem) {
        String regex = "(h?ttps?|ftp)://[\\p{Alnum}\\p{Punct}]{1,}";
        XsltSkin.clusterAll(elem, "a", regex, "$0");
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            if (!(nl.item(i) instanceof Element) || !(e = (Element)nl.item(i)).getTagName().equals("a")) continue;
            String text = e.getTextContent();
            String link = text;
            if (link.startsWith("ttp")) {
                link = "h" + link;
            }
            e.setAttribute("href", link);
            e.setAttribute("target", "_blank");
            String dec = XsltSkin.decodeURL(text);
            if (dec.equals(text)) continue;
            while (e.getChildNodes().getLength() > 0) {
                e.removeChild(e.getFirstChild());
            }
            Text t = e.getOwnerDocument().createTextNode(dec);
            e.appendChild(t);
        }
    }

    private static String decodeURL(String urlText) {
        String[] enc;
        for (String encoding : enc = new String[]{IO.UTF8.name(), IO.SJIS.name(), "EUC-JP", "JISAutoDetect"}) {
            try {
                String dec = URLDecoder.decode(urlText, encoding);
                if (!dec.equals(new String(dec.getBytes(IO.SJIS.name()), IO.SJIS.name()))) continue;
                dec = XsltSkin.decodeWikiAnchor(dec);
                return dec;
            }
            catch (Exception ex) {
                logger.fine(ex.toString() + "; " + urlText);
            }
        }
        for (int i = 0; i < enc.length; ++i) {
            try {
                String dec = URLDecoder.decode(urlText, enc[i]);
                if (!XsltSkin.valid(dec)) continue;
                return dec;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return urlText;
    }

    private static String decodeWikiAnchor(String urlText) {
        try {
            int hash = urlText.lastIndexOf(35);
            if (hash < 0) {
                return urlText;
            }
            String base = urlText.substring(0, hash + 1);
            String anchor = urlText.substring(hash + 1);
            Pattern pattern = Pattern.compile("\\.([\\dA-Fa-f]{2})");
            Matcher matcher = pattern.matcher(anchor);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int begin = 0;
            while (matcher.find()) {
                out.write(anchor.substring(begin, matcher.start()).getBytes(IO.UTF8.name()));
                begin = matcher.end();
                out.write(Integer.parseInt(matcher.group(1), 16));
            }
            out.write(anchor.substring(begin).getBytes(IO.UTF8.name()));
            return base + new String(out.toByteArray(), IO.UTF8.name());
        }
        catch (Exception ex) {
            logger.fine(ex.toString() + "; " + urlText);
            return urlText;
        }
    }

    private static boolean valid(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isDefined(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void clusterAll(Element elem, String name, String pattern, String replacement) {
        Pattern p = Pattern.compile(pattern);
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getParentNode() == null || !(n instanceof Text)) continue;
            XsltSkin.cluster((Text)n, name, p, replacement);
        }
    }

    private static void cluster(Text text, String tagName, Pattern pattern, String replacement) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(text.getData());
        while (text.getNextSibling() instanceof Text) {
            Text t = (Text)text.getNextSibling();
            buffer.append(t.getData());
            t.getParentNode().removeChild(t);
        }
        String s = buffer.toString();
        Node parent = text.getParentNode();
        Text newText = text.getOwnerDocument().createTextNode(s);
        parent.replaceChild(newText, text);
        text = newText;
        Matcher m = pattern.matcher(s);
        if (!m.find()) {
            return;
        }
        String e = m.group(0).replaceFirst(pattern.pattern(), replacement);
        Document doc = text.getOwnerDocument();
        Text head = doc.createTextNode(s.substring(0, m.start()));
        Text tail = doc.createTextNode(s.substring(m.end()));
        Element elem = doc.createElement(tagName);
        if (e.length() > 0) {
            elem.appendChild(doc.createTextNode(e));
        }
        text.getParentNode().insertBefore(head, text);
        text.getParentNode().insertBefore(elem, text);
        text.getParentNode().insertBefore(tail, text);
        text.getParentNode().removeChild(text);
    }

    private static void setContent(Element content, String text) {
        text = text.replaceAll("(?i)<a\\s+[^>]*>([^<]*)</a>", "$1");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("[>\uff1e\u226b]{1,2}([\\d\uff10-\uff19]{1,4}((-[\\d\uff10-\uff19]{1,4})|(,[\\d\uff10-\uff19]{1,4}))*)", "<pointer href=\"$1\">$0</pointer>");
        Debug.dump("\u5909\u63db\u5bfe\u8c61\u306e\u30c6\u30ad\u30b9\u30c8", "%s", text);
        HTMLDocumentBuilderFactory f = new HTMLDocumentBuilderFactory();
        try {
            DocumentBuilder b = f.newDocumentBuilder();
            Document doc = b.parse(new InputSource(new StringReader(text)));
            Element root = doc.getDocumentElement();
            if (root == null) {
                root = doc.createElement("html");
            }
            NodeList nl = root.getChildNodes();
            Document dst = content.getOwnerDocument();
            for (int i = 0; i < nl.getLength(); ++i) {
                content.appendChild(dst.importNode(nl.item(i), true));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private class EL
    extends DefaultHandler
    implements ErrorListener {
        private final PrintWriter out;
        private Locator l = null;

        public EL(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.l = locator;
        }

        @Override
        public void warning(SAXParseException ex) {
            this.error(Level.WARNING, ex);
        }

        @Override
        public void error(SAXParseException ex) {
            this.error(Level.SEVERE, ex);
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.error(Level.SEVERE, ex);
        }

        @Override
        public void warning(TransformerException ex) {
            this.error(Level.WARNING, ex);
        }

        @Override
        public void error(TransformerException ex) {
            this.error(Level.SEVERE, ex);
        }

        @Override
        public void fatalError(TransformerException ex) {
            this.error(Level.SEVERE, ex);
        }

        private void error(Level level, TransformerException ex) {
            logger.log(level, "XSL\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            SourceLocator l = ex.getLocator();
            if (l != null) {
                this.out.print(l.getSystemId() + "(" + l.getLineNumber() + "," + l.getColumnNumber() + "): ");
            } else {
                this.out.print(XsltSkin.this.getFile() + ": ");
            }
            this.out.println(ex.getLocalizedMessage());
        }

        private void error(Level level, SAXException ex) {
            logger.log(level, "", ex);
            if (this.l != null) {
                this.out.print(this.l.getSystemId() + "(" + this.l.getLineNumber() + "," + this.l.getColumnNumber() + "): ");
            } else {
                this.out.print(XsltSkin.this.getFile() + ": ");
            }
            this.out.println(ex.getLocalizedMessage());
        }
    }
}

