/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.Skin;
import org.koiroha.jive2ch.func.XsltSkin;
import org.koiroha.jive2ch.util.Debug;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.xml.Html;

public class SkinManager {
    private static final Logger logger = Logger.getLogger(SkinManager.class.getName());
    private static final Set<String> EXT = new HashSet<String>();
    private static SkinManager DEFAULT = null;
    private final File dir;
    private final Map<String, Skin> cache = new HashMap<String, Skin>();

    public SkinManager(File dir) throws IOException {
        File def;
        this.dir = dir;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(def = new File(dir, "default.xsl")).isFile()) {
            URL url = Resource.getResource("default.xsl");
            IO.copy(url, def);
        }
    }

    public List<String> getNames() throws IOException {
        IO.mkdir(this.dir);
        ArrayList<String> skins = new ArrayList<String>();
        for (String f : this.dir.list()) {
            if (!new File(this.dir, f).isFile()) continue;
            String basename = f;
            String ext = "";
            int sep = f.lastIndexOf(46);
            if (sep >= 0) {
                basename = f.substring(0, sep);
                ext = f.substring(sep);
            }
            if (!EXT.contains(ext.toLowerCase())) continue;
            skins.add(basename);
        }
        logger.finest("skins: " + skins);
        return skins;
    }

    private Skin getSkin(String name) {
        Skin skin = this.cache.get(name);
        if (skin != null && !skin.isExpires()) {
            return skin;
        }
        skin = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        File file = null;
        try {
            file = new File(this.dir, name + ".xsl");
            if (file.isFile()) {
                skin = new XsltSkin(file, pw);
            }
            this.cache.put(name, skin);
        }
        catch (TransformerException ex) {
            skin = new ErrorSkin(file, sw.toString(), ex);
        }
        return skin;
    }

    private Skin getCurrentSkin() {
        Config config = Config.getDefault();
        return this.getSkin(config.getSkinName());
    }

    public String getThreadHTML(Thread thread, Map<String, String> param) throws IOException {
        StringWriter sw = new StringWriter();
        this.convert(sw, thread, param, Pointer.EMPTY);
        return sw.toString();
    }

    public void convert(Writer out, Thread thread, Map<String, String> param, Pointer ptr) throws IOException {
        Config c = Config.getDefault();
        param.put("font-size", c.getTheadFontSize().getSize() + "px");
        this.getCurrentSkin().convert(out, thread, param, ptr);
    }

    public String getResponseHTML(List<Response> list, Map<String, String> param) throws IOException {
        Config c = Config.getDefault();
        if (c.isThumbnailEnabled()) {
            param.put("thumb", "thumb");
        }
        Performance pfm = Performance.start();
        Skin skin = this.getCurrentSkin();
        StringWriter sw = new StringWriter();
        for (Response r : list) {
            skin.convert(sw, r, param);
        }
        String html = sw.toString();
        pfm.mark(list.size() + " \u30ec\u30b9 " + html.length() + " \u6587\u5b57\u306e HTML \u5909\u63db\u51e6\u7406");
        Debug.dump("\u30ec\u30b9\u5909\u63db\u7d50\u679c", "%s", html);
        return html;
    }

    public static void setDefault(SkinManager defaultManager) {
        DEFAULT = defaultManager;
    }

    public static SkinManager getDefault() {
        return DEFAULT;
    }

    static {
        EXT.add(".xsl");
        EXT.add(".zip");
    }

    private static class ErrorSkin
    extends Skin {
        private final String log;
        private final Throwable ex;

        public ErrorSkin(File file, String log, Throwable ex) {
            super(file);
            this.log = log;
            this.ex = ex;
        }

        @Override
        public void convert(Writer out, Response res, Map<String, String> param) throws IOException {
        }

        @Override
        public void convert(Writer out, Thread thread, Map<String, String> param, Pointer ptr) throws IOException {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(this.log);
            this.ex.printStackTrace(pw);
            pw.flush();
            String msg = sw.toString();
            msg = msg.replace("<", "&lt;").replace("\n", "<br/>");
            out.write("<html>");
            out.write("<head>");
            out.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>");
            out.write("<body>");
            out.write("<h1>" + Html.escape(this.ex.getMessage()) + "</h1>");
            out.write("File: " + Html.escape(this.getFile().toString()));
            out.write("<pre>" + msg + "</pre>");
            out.write("<div id=\"content\"></div>");
            out.write("</body>");
            out.write("</html>");
        }
    }
}

