/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Kakiko;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.Ch2Service;
import org.koiroha.jive2ch.func.MachiBBSService;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.xml.Html;

public abstract class Service {
    private static final Logger logger = Logger.getLogger(Service.class.getName());
    private static final List<Service> services = new ArrayList<Service>();
    private final List<Pattern> pattern = new ArrayList<Pattern>();

    protected Service() {
    }

    protected void addAcceptPattern(String pattern) {
        this.pattern.add(Pattern.compile(pattern));
    }

    public boolean accept(URI url) {
        String u = url.toString();
        for (Pattern p : this.pattern) {
            if (!p.matcher(u).matches()) continue;
            return true;
        }
        return false;
    }

    public Board createBoard(Category category, String name, URI uri) {
        uri = this.getDataURI(uri);
        return new Board(this, category, name, uri);
    }

    public Thread createThread(Board board, String fileName, String title, int res) throws IOException {
        Date created = this.parseDate(fileName);
        return new Thread(board, fileName, title, res, created);
    }

    public URI getBrowserURI(Thread thread) {
        URI base = thread.getBoard().getURI();
        String bpath = base.getPath();
        String path = "?";
        if (thread.getCreated() != null) {
            path = String.valueOf(thread.getCreated().getTime() / 1000L);
        }
        return base.resolve("/test/read.cgi/" + bpath + "/" + path + "/").normalize();
    }

    public URI getDataURI(URI uri) {
        logger.finest("getDataURI(" + uri + ")");
        Pattern pattern = Pattern.compile("/test/read.cgi/([^/]*)/([^/]*)");
        Matcher matcher = pattern.matcher(uri.getPath());
        if (matcher.lookingAt()) {
            String path = "/" + matcher.group(1) + "/dat/" + matcher.group(2) + ".dat";
            return uri.resolve(path);
        }
        return uri;
    }

    public URI getBoardURI(URI uri) {
        logger.finest("getBoardURI(" + uri + ")");
        uri = this.getDataURI(uri);
        Pattern pattern = Pattern.compile("/([^/]*).*");
        Matcher matcher = pattern.matcher(uri.getPath());
        if (matcher.lookingAt()) {
            String path = "/" + matcher.group(1) + "/";
            return uri.resolve(path);
        }
        return uri;
    }

    public String getFileName(URI uri) {
        logger.finest("getFileName(" + uri + ")");
        uri = this.getDataURI(uri);
        String path = uri.getPath();
        int sep = path.lastIndexOf(47);
        if (sep >= 0) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public Pointer getResponsePointer(URI uri) {
        String p;
        logger.finest("getResponsePointer(" + uri + ")");
        Pattern pattern = Pattern.compile("/test/read\\.cgi/([^/]*)/([^/]*)/?([^/]*)");
        Matcher matcher = pattern.matcher(uri.getPath());
        if (matcher.lookingAt() && (p = matcher.group(3)).length() > 0) {
            return Pointer.compile(p);
        }
        return null;
    }

    public boolean contribute(Thread thread, Kakiko kakiko) throws IOException {
        throw new IOException("\u66f8\u304d\u8fbc\u307f\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public Thread parseSubject(Board board, String line) throws IOException {
        String[] elem = this.getSubjectParser().parse(line);
        if (elem == null) {
            return null;
        }
        String fileName = elem[0];
        String title = Html.unescape(elem[1]);
        int res = Integer.parseInt(elem[2]);
        return this.createThread(board, fileName, title, res);
    }

    private Date parseDate(String fileName) {
        String[] elem = this.getFileNameParser().parse(fileName);
        if (elem != null) {
            try {
                long tm = Long.parseLong(elem[0]) * 1000L;
                return new Date(tm);
            }
            catch (NumberFormatException ex) {
                logger.fine("dat\u30d5\u30a1\u30a4\u30eb\u540d\u304b\u3089\u4f5c\u6210\u65e5\u6642\u306e\u53d6\u5f97\u306b\u5931\u6557: " + fileName);
            }
        }
        return null;
    }

    protected abstract Parser getSubjectParser();

    protected abstract Parser getFileNameParser();

    public static void install(Service s) {
        services.add(0, s);
    }

    public static void uninstall(Service s) {
        services.remove(s);
    }

    public static Service getService(URI uri) {
        for (Service s : services) {
            if (!s.accept(uri)) continue;
            return s;
        }
        logger.finer("\u30cf\u30f3\u30c9\u30eb\u53ef\u80fd\u306a\u30b5\u30fc\u30d3\u30b9\u304c\u3042\u308a\u307e\u305b\u3093: " + uri);
        return null;
    }

    static {
        Service.install(new Ch2Service());
        Service.install(new MachiBBSService());
    }

    public static class PatternParser
    implements Parser {
        private final Pattern pattern;
        private final int[] map;

        public PatternParser(String pattern, int ... groupIndex) {
            this.pattern = Pattern.compile(pattern);
            this.map = groupIndex;
        }

        @Override
        public String[] parse(String text) {
            Matcher matcher = this.pattern.matcher(text);
            if (!matcher.matches()) {
                return null;
            }
            String[] elem = new String[this.map.length];
            for (int i = 0; i < this.map.length; ++i) {
                elem[i] = matcher.group(this.map[i]);
            }
            return elem;
        }
    }

    public static interface Parser {
        public String[] parse(String var1);
    }
}

