/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.xml.Xml;

public class LocalBoard
extends Board {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LocalBoard.class.getName());
    private final File subject = new File(this.getDirectory(), "subject.txt");
    private List<Thread> threads = null;
    private boolean cascadeDelete = false;

    public LocalBoard(Category category, String name, String id) {
        this(category, name, "_", id);
    }

    public LocalBoard(Category category, String name, String categoryId, String boardId) {
        super(null, category, name, LocalBoard.getLocalFile(category, categoryId, boardId + "/"));
        try {
            this.subject.createNewFile();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, this.subject.getName() + " \u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.getDirectory(), ex);
        }
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        this.cascadeDelete = cascadeDelete;
    }

    @Override
    public File getSubjectFile() {
        return this.subject;
    }

    public synchronized void addThread(Thread thread) {
        try {
            if (this.threads == null) {
                this.read();
            }
            for (int i = 0; i < this.threads.size(); ++i) {
                Thread t = this.threads.get(i);
                if (!t.sameAs(thread) && (!this.cascadeDelete || this.threads.get(i).isKidoku())) continue;
                this.threads.remove(i);
                --i;
            }
            this.threads.add(0, thread);
            thread.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("kidoku") && !((Boolean)e.getNewValue()).booleanValue() && LocalBoard.this.cascadeDelete) {
                        Thread t = (Thread)e.getSource();
                        LocalBoard.this.threads.remove(t);
                        logger.finer("\u30ed\u30fc\u30ab\u30eb\u63b2\u793a\u677f\u304b\u3089\u524a\u9664\u3055\u308c\u307e\u3057\u305f: " + t);
                    }
                }
            });
            this.write();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30ed\u30fc\u30ab\u30eb\u63b2\u793a\u677f\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
    }

    public synchronized void removeThread(Thread thread) {
        try {
            if (this.threads == null) {
                this.read();
            }
            for (int i = 0; i < this.threads.size(); ++i) {
                if (!thread.sameAs(this.threads.get(i))) continue;
                this.threads.remove(i);
                this.write();
                break;
            }
            logger.finer("\u30b9\u30ec\u30c3\u30c9\u3092\u524a\u9664\u3057\u307e\u3057\u305f: " + thread.getTitle());
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30ed\u30fc\u30ab\u30eb\u63b2\u793a\u677f\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
    }

    public synchronized List<Thread> getThreads() {
        try {
            if (this.threads == null) {
                this.read();
            }
            for (int i = 0; i < this.threads.size(); ++i) {
                this.threads.get(i).setNumber(i + 1);
            }
            return new ArrayList<Thread>(this.threads);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30ed\u30fc\u30ab\u30eb\u63b2\u793a\u677f\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            return Collections.emptyList();
        }
    }

    public synchronized void update(Thread thread) {
        try {
            if (this.threads == null) {
                this.read();
            }
            for (int i = 0; i < this.threads.size(); ++i) {
                if (!thread.sameAs(this.threads.get(i))) continue;
                this.threads.set(i, thread);
                break;
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30ed\u30fc\u30ab\u30eb\u63b2\u793a\u677f\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
    }

    public void deleteLocal() throws IOException {
        IO.rmdir(this.getDirectory());
    }

    public boolean contains(Thread thread) {
        for (Thread t : this.getThreads()) {
            if (!t.sameAs(thread)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        HashSet<String> uris = new HashSet<String>();
        File file = this.getSubjectFile();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] elem = line.split("<>");
                try {
                    if (elem.length < 4) {
                        throw new RuntimeException();
                    }
                    uris.add(elem[0]);
                    list.add(elem);
                }
                catch (RuntimeException ex) {
                    logger.log(Level.WARNING, file + " \u306b\u4e0d\u6b63\u306a\u884c\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059: " + line, ex);
                }
            }
        }
        catch (FileNotFoundException ex) {
            try {
                logger.finer("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f: " + file);
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
            IO.close(in);
        }
        IO.close(in);
        HashMap<String, Board> boards = new HashMap<String, Board>();
        for (String uri : uris) {
            Board board = this.getCategory().getJive2ch().getBoardByURI(URI.create(uri));
            if (board == null) continue;
            boards.put(uri, board);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < list.size(); ++i) {
            String[] elem = (String[])list.get(i);
            Board board = (Board)boards.get(elem[0]);
            if (board != null) {
                String fileName = elem[1];
                String title = Xml.unescape(elem[2]);
                try {
                    int count = Integer.parseInt(elem[3]);
                    Thread t = board.getService().createThread(board, fileName, title, count);
                    if (!this.cascadeDelete || t.isKidoku()) {
                        threads.add(t);
                        continue;
                    }
                    logger.finer("\u30ed\u30fc\u30ab\u30eb\u524a\u9664\u3055\u308c\u3066\u3044\u308b\u30b9\u30ec\u30c3\u30c9\u3092\u8aad\u307f\u98db\u3070\u3057\u307e\u3057\u305f: " + t);
                }
                catch (RuntimeException ex) {
                    logger.log(Level.WARNING, "\u4e0d\u6b63\u306a\u6570\u5024\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059: " + elem[3]);
                }
                continue;
            }
            logger.warning("\u63b2\u793a\u677f\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093: " + elem[0]);
        }
        this.threads = threads;
        logger.finer(threads.size() + " \u4ef6\u306e\u30b9\u30ec\u30c3\u30c9\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        File file = this.getSubjectFile();
        PrintWriter out = null;
        RollbackOutputStream os = null;
        boolean success = false;
        try {
            os = new RollbackOutputStream(file);
            out = new PrintWriter(os);
            for (int i = 0; i < this.threads.size(); ++i) {
                Thread t = this.threads.get(i);
                out.print(t.getBoard().getURI());
                out.print("<>");
                out.print(t.getFileName());
                out.print("<>");
                out.print(Xml.escape(t.getTitle()));
                out.print("<>");
                out.print(t.getResponseCount());
                out.println();
            }
            out.flush();
            success = true;
            logger.finer("\u30ed\u30fc\u30ab\u30eb\u63b2\u793a\u677f\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f");
            if (!success && os != null) {
                os.rollback();
            }
        }
        catch (Throwable throwable) {
            if (!success && os != null) {
                os.rollback();
            }
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
    }

    private static File getLocalFile(Category cat, String catId, String fileName) {
        Jive2ch app = cat.getJive2ch();
        File dir = app.repository.getServerDirectory(catId);
        return new File(dir, fileName);
    }
}

