/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.util.IO;

public class FavouriteCategory
extends Category {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(FavouriteCategory.class.getName());

    public FavouriteCategory(Jive2ch app) {
        super(app, "\u304a\u6c17\u306b\u5165\u308a");
        this.setCollapseIcon(GUI.ICON_FAVOURITE);
        this.setExpandIcon(GUI.ICON_FAVOURITE);
        File dir = this.getDirectory();
        try {
            IO.mkdir(dir);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u63b2\u793a\u677f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + dir, ex);
        }
        for (File d : dir.listFiles()) {
            if (!d.isDirectory()) continue;
            this.createGroup(d.getName());
        }
    }

    @Override
    public List<Board> getBoards() {
        ArrayList<Board> list = new ArrayList<Board>(super.getBoards());
        Collections.sort(list, new Comparator<Board>(){

            @Override
            public int compare(Board o1, Board o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return list;
    }

    public LocalBoard createGroup(String name) {
        LocalBoard board = new LocalBoard(this, name, "_favourite", name);
        this.addBoard(board);
        return board;
    }

    public void removeGroup(LocalBoard board) throws IOException {
        board.deleteLocal();
        this.removeBoard(board);
    }

    public File getDirectory() {
        return this.getJive2ch().repository.getServerDirectory("_favourite");
    }

    public boolean isFavourite(Thread thread) {
        if (thread == null) {
            return false;
        }
        for (Board b : this.getBoards()) {
            LocalBoard lb = (LocalBoard)b;
            if (!lb.contains(thread)) continue;
            return true;
        }
        return false;
    }
}

