/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.koiroha.jive2ch.func.DAT2XML;
import org.koiroha.jive2ch.util.IO;

public class DAT2XMLReader
extends Reader {
    private final BufferedReader in;
    private StringBuilder buffer = new StringBuilder();
    private int responseCount = 0;
    private boolean eof = false;

    public DAT2XMLReader(InputStream in) throws IOException {
        this(in, IO.SJIS.name());
    }

    public DAT2XMLReader(InputStream in, String charset) throws IOException {
        this(new InputStreamReader(in, charset));
    }

    public DAT2XMLReader(Reader in) throws IOException {
        this.in = new BufferedReader(in);
        this.buffer.append("<?xml version=\"1.0\"?>\n");
        this.buffer.append("<thread>\n");
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        if (!this.fill()) {
            return -1;
        }
        char ch = this.buffer.charAt(0);
        this.buffer.delete(0, 1);
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.fill()) {
            return -1;
        }
        int length = Math.min(len, this.buffer.length());
        for (int i = 0; i < length; ++i) {
            cbuf[off + i] = this.buffer.charAt(i);
        }
        this.buffer.delete(0, length);
        return length;
    }

    private boolean fill() throws IOException {
        if (this.buffer.length() != 0) {
            return true;
        }
        if (this.eof) {
            return false;
        }
        String line = this.in.readLine();
        if (line == null) {
            if (!this.eof) {
                this.buffer.append("</thread>");
                this.eof = true;
            }
            return true;
        }
        ++this.responseCount;
        DAT2XML.convert(line, this.buffer);
        return true;
    }
}

