/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.xml.Html;
import org.koiroha.xml.Xml;

public final class DAT2XML {
    private static final Logger logger = Logger.getLogger(DAT2XML.class.getName());

    private DAT2XML() {
    }

    public static void convert(String datLine, Appendable buffer) throws IOException {
        try {
            DAT2XML.convert2(datLine, buffer);
        }
        catch (RuntimeException ex) {
            throw new IOException("\u672a\u5bfe\u5fdc\u306e dat \u5f62\u5f0f\u3092\u691c\u51fa\u3057\u307e\u3057\u305f: " + datLine + "; " + ex);
        }
    }

    private static void convert2(String datLine, Appendable buffer) throws IOException {
        String[] elem = datLine.split("<>");
        String name = elem[0];
        String mail = elem[1];
        String misc = elem[2];
        String content = elem[3];
        String title = elem.length > 4 ? elem[4] : null;
        Date date = null;
        Pattern p = Pattern.compile("(\\d+)/(\\d+)/(\\d+)\\(.\\)\\s+(\\d+):(\\d+):(\\d+)(\\.(\\d+))?");
        Matcher m = p.matcher(misc);
        if (m.find()) {
            int YY = Integer.parseInt(m.group(1));
            int MM = Integer.parseInt(m.group(2));
            int DD = Integer.parseInt(m.group(3));
            int hh = Integer.parseInt(m.group(4));
            int mm = Integer.parseInt(m.group(5));
            int ss = Integer.parseInt(m.group(6));
            if (YY < 100) {
                YY += 2000;
            } else if (YY < 200) {
                YY += 1900;
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("JST"));
            cal.set(YY, MM, DD, hh, mm, ss);
            if (m.groupCount() >= 9) {
                cal.set(14, Integer.parseInt(m.group(8)));
            } else {
                cal.set(14, cal.getActualMinimum(14));
            }
            date = cal.getTime();
            misc = misc.substring(0, m.start()) + misc.substring(m.end());
        }
        String id = null;
        p = Pattern.compile("ID:([^\\s]+)");
        m = p.matcher(misc);
        if (m.find()) {
            id = m.group(1);
            misc = misc.substring(0, m.start()) + misc.substring(m.end());
        }
        String be = null;
        p = Pattern.compile("BE:([^\\s]+)");
        m = p.matcher(misc);
        if (m.find()) {
            be = m.group(1);
            misc = misc.substring(0, m.start()) + misc.substring(m.end());
        }
        if (misc.trim().length() > 0) {
            logger.fine("misc\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u672a\u78ba\u8a8d\u306e\u30c7\u30fc\u30bf\u304c\u6b8b\u3063\u3066\u3044\u307e\u3059: " + misc.trim());
        }
        content = content.replaceAll("<br\\s*/?>", "\n");
        content = content.replaceAll("<a\\s+[^>]*>([^<]*)</a>", "$1");
        content = Html.unescape(content);
        content = Xml.escape(content);
        content = content.replaceAll("\n", "<br/>");
        content = DAT2XML.parsePointer(content);
        content = DAT2XML.parseLink(content);
        buffer.append("\t<message>\n");
        if (title != null) {
            buffer.append("\t\t<title>");
            Xml.escape(buffer, title);
            buffer.append("</title>\n");
        }
        buffer.append("\t\t<name>");
        Xml.escape(buffer, name);
        buffer.append("</name>\n");
        buffer.append("\t\t<mail>");
        Xml.escape(buffer, mail);
        buffer.append("</mail>\n");
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss");
            buffer.append("\t\t<date utc=\"").append(String.valueOf(date.getTime())).append("\">");
            Xml.escape(buffer, df.format(date));
            buffer.append("</date>\n");
        }
        if (id != null) {
            buffer.append("\t\t<id>");
            Xml.escape(buffer, id);
            buffer.append("</id>\n");
        }
        if (be != null) {
            buffer.append("\t\t<be>");
            Xml.escape(buffer, be);
            buffer.append("</be>\n");
        }
        buffer.append("\t\t<content>").append(content).append("</content>\n");
        buffer.append("\t</message>\n");
    }

    private static String parsePointer(String content) {
        StringBuilder buffer = new StringBuilder();
        Pattern pattern = Pattern.compile("(&gt;|\uff1e|\t\u226b){1,2}([\\d\uff10-\uff19]{1,4})");
        Matcher matcher = pattern.matcher(content);
        int end = 0;
        while (matcher.find()) {
            int num;
            if (matcher.start() != end) {
                buffer.append(content, end, matcher.start());
            }
            if ((num = Integer.parseInt(matcher.group(matcher.groupCount()))) <= 0 || num > 1001) {
                buffer.append(matcher.group(0));
            } else {
                buffer.append("<a href=\"#n" + num + "\">");
                buffer.append(matcher.group(0));
                buffer.append("</a>");
            }
            end = matcher.end();
        }
        buffer.append(content, end, content.length());
        return buffer.toString();
    }

    private static String parseLink(String content) {
        StringBuilder buffer = new StringBuilder();
        Pattern pattern = Pattern.compile("h?ttp://[\\S]*");
        Matcher matcher = pattern.matcher(content);
        int end = 0;
        while (matcher.find()) {
            String url;
            if (matcher.start() != end) {
                buffer.append(content, end, matcher.start());
            }
            if ((url = matcher.group()).startsWith("ttp:")) {
                url = "h" + url;
            }
            buffer.append("<a href=\"").append(url).append("\">").append(url).append("</a>");
            end = matcher.end();
        }
        buffer.append(content, end, content.length());
        return buffer.toString();
    }
}

