/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.func;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Kakiko;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Dialog;
import org.koiroha.jive2ch.gui.dialog.BrowserDialog;
import org.koiroha.jive2ch.util.Debug;
import org.koiroha.jive2ch.util.XML;
import org.koiroha.xml.parser.HTMLDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

class Ch2Service
extends Service {
    private static final Logger logger = Logger.getLogger(Ch2Service.class.getName());
    private static final Service.Parser SUBJECT = new Service.PatternParser("(.*)<>(.*)\\s+\\((\\d+)\\).*", 1, 2, 3);
    private static final Service.Parser FILENAME = new Service.PatternParser("(\\d+)\\.dat", 1);

    public Ch2Service() {
        this.addAcceptPattern("http://[^/]*\\.2ch\\.net/[^/?&]+/.*");
        this.addAcceptPattern("http://[^/]*\\.bbspink\\.com/[^/?&]+/.*");
    }

    @Override
    public boolean contribute(Thread thread, Kakiko kakiko) throws IOException {
        block6: {
            String title;
            URI base = thread.getBoard().getURI();
            URI uri = base.resolve("/test/bbs.cgi?guid=ON").normalize();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("FROM", kakiko.getName());
            param.put("mail", kakiko.getMail());
            param.put("MESSAGE", kakiko.getContent());
            Document html = Ch2Service.getDefaultForm(thread, uri);
            do {
                html = UserAgent.getDefault().submit(uri, html, param);
                param.clear();
                Date now = new Date();
                Board board = thread.getBoard();
                board.setContributeDate(now);
                board.saveMetaInfo();
                title = XML.evalString("/html/head/title", html);
                String mark = XML.evalString("//comment()[contains(.,'2ch_X:')]", html);
                logger.finer("title=" + title + "; mark=" + mark);
                if (title.indexOf("\u66f8\u304d\u3053\u307f\u307e\u3057\u305f") >= 0 || mark.indexOf("2ch_X:true") >= 0) {
                    logger.info("\u66f8\u304d\u8fbc\u307f\u306b\u6210\u529f\u3057\u307e\u3057\u305f");
                    return true;
                }
                boolean ok = Ch2Service.showMessage(html, title);
                if (mark.indexOf("2ch_X:false") >= 0) {
                    logger.info("\u66f8\u304d\u8fbc\u307f\u306b\u6210\u529f\u3057\u307e\u3057\u305f (\u8b66\u544a\u4ed8\u304d)");
                    return true;
                }
                if (mark.indexOf("2ch_X:check") >= 0) {
                    logger.info("\u5185\u5bb9\u78ba\u8a8d\u304c\u8fd4\u3063\u3066\u304d\u307e\u3057\u305f");
                    break block6;
                }
                if (title.indexOf("\u66f8\u304d\u8fbc\u307f\u78ba\u8a8d") >= 0 || mark.indexOf("2ch_X:cookie") >= 0) {
                    logger.info("\u66f8\u304d\u8fbc\u307f\u78ba\u8a8d\u304c\u8fd4\u3063\u3066\u304d\u307e\u3057\u305f");
                    if (!ok) break block6;
                }
                if (title.indexOf("\uff25\uff32\uff32\uff2f\uff32") < 0 && mark.indexOf("2ch_X:error") < 0) continue;
                logger.info("\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                String text = html.getDocumentElement().getTextContent();
                Matcher m = Pattern.compile("\\s*-\\s+593\\s+(\\d+)\\s*sec").matcher(text);
                if (m.find()) {
                    int sec = Integer.parseInt(m.group(1));
                    thread.getBoard().setContributeInterval(sec * 1000);
                    logger.finer("\u9023\u7d9a\u66f8\u304d\u8fbc\u307f\u898f\u5236\u3092\u691c\u51fa: " + sec + " \u79d2");
                }
                Debug.dump("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u5185\u5bb9", html);
                break block6;
            } while (title.indexOf("\u304a\u8336\u3067\u3082") < 0);
            logger.info("\u30b5\u30fc\u30d0\u904e\u8ca0\u8377\u3063\u307d\u3044");
        }
        return false;
    }

    private static boolean showMessage(Document html, final String title) {
        final String response = XML.toString(html);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(response);
        }
        final J2Dialog.Option[] o = new J2Dialog.Option[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BrowserDialog dialog = new BrowserDialog(GUI.getSystemComponent());
                dialog.setTitle(title);
                dialog.setText("<html><style>body{font-size:12px;}</style>" + response);
                dialog.setOptions(new Object[]{J2Dialog.Option.OK, J2Dialog.Option.CANCEL});
                dialog.setDefaultOption((Object)J2Dialog.Option.OK);
                dialog.open();
                o[0] = (J2Dialog.Option)((Object)dialog.getSelectedOption());
            }
        };
        Display.getDefault().syncExec(r);
        logger.fine("\u9078\u629e\u3057\u305f\u52d5\u4f5c: " + (Object)((Object)o[0]));
        return o[0] == J2Dialog.Option.OK;
    }

    private static Document getDefaultForm(Thread thread, URI uri) {
        URI base = thread.getBoard().getURI();
        Date recent = thread.getRecentAccess();
        if (recent == null) {
            recent = new Date(System.currentTimeMillis() - 18000000L);
        }
        String bbs = base.getPath().replaceAll("/([^/]+)/.*", "$1");
        String key = thread.getFileName().replaceAll("(\\d+).*", "$1");
        String time = String.valueOf(recent.getTime() / 1000L);
        String submit = "\u66f8\u304d\u8fbc\u3080";
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>");
        buffer.append("<form action=\"" + uri + "\">");
        buffer.append("<input name=\"bbs\" value=\"" + bbs + "\"/>");
        buffer.append("<input name=\"key\" value=\"" + key + "\"/>");
        buffer.append("<input name=\"time\" value=\"" + time + "\"/>");
        buffer.append("<input name=\"submit\" value=\"" + submit + "\"/>");
        buffer.append("<input name=\"FROM\" value=\"\"/>");
        buffer.append("<input name=\"mail\" value=\"\"/>");
        buffer.append("<input name=\"MESSAGE\" value=\"\"/>");
        buffer.append("</form>");
        buffer.append("</html>");
        HTMLDocumentBuilderFactory f = new HTMLDocumentBuilderFactory();
        try {
            return f.newDocumentBuilder().parse(new InputSource(new StringReader(buffer.toString())));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected Service.Parser getSubjectParser() {
        return SUBJECT;
    }

    @Override
    protected Service.Parser getFileNameParser() {
        return FILENAME;
    }
}

