/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.event;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.event.Jive2chEvent;
import org.koiroha.jive2ch.event.Jive2chListener;

public class Jive2chSupport {
    private static final Logger logger = Logger.getLogger(Jive2chSupport.class.getName());
    private final Object source;
    private final List<Jive2chListener> listener = new ArrayList<Jive2chListener>();

    public Jive2chSupport(Object source) {
        this.source = source;
    }

    public void addJive2chListener(Jive2chListener l) {
        this.listener.add(l);
    }

    public void removeJive2chListener(Jive2chListener l) {
        for (int i = 0; i < this.listener.size(); ++i) {
            if (this.listener.get(i) != l) continue;
            this.listener.remove(i);
            return;
        }
    }

    public void fireBoardSelected(Board board) {
        Jive2chEvent e = new Jive2chEvent(this.source, board);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("fireBoardChange(" + e + ")");
        }
        for (int i = 0; i < this.listener.size(); ++i) {
            this.listener.get(i).boardSelected(e);
        }
    }

    public void fireThreadSelected(Thread thread) {
        Jive2chEvent e = new Jive2chEvent(this.source, thread);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("fireThreadSelected(" + e + ")");
        }
        for (int i = 0; i < this.listener.size(); ++i) {
            this.listener.get(i).threadSelected(e);
        }
    }
}

