/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.event;

import java.util.EventObject;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.Thread;

public class Jive2chEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final Category category;
    private final Board board;
    private final Thread thread;
    private final Response response;
    private final String url;

    public Jive2chEvent(Object source, Category category) {
        super(source);
        this.category = category != null ? category : null;
        this.board = null;
        this.thread = null;
        this.response = null;
        this.url = null;
    }

    public Jive2chEvent(Object source, Board board) {
        super(source);
        if (board != null) {
            this.category = board.getCategory();
            this.board = board;
        } else {
            this.category = null;
            this.board = null;
        }
        this.thread = null;
        this.response = null;
        this.url = null;
    }

    public Jive2chEvent(Object source, Thread thread) {
        this(source, thread, null);
    }

    public Jive2chEvent(Object source, Thread thread, Response response) {
        super(source);
        if (thread != null) {
            this.category = thread.getBoard().getCategory();
            this.board = thread.getBoard();
            this.thread = thread;
            this.url = thread.getBrowserURI().toString();
        } else {
            this.category = null;
            this.board = null;
            this.thread = null;
            this.url = null;
        }
        this.response = response;
    }

    public Category getCategory() {
        return this.category;
    }

    public Board getBoard() {
        return this.board;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        if (this.category != null) {
            buffer.append("[" + this.category.getName() + "]");
            if (this.board != null) {
                buffer.append(this.board.getName());
                if (this.thread != null) {
                    buffer.append(":" + this.thread.getTitle());
                    if (this.response != null) {
                        buffer.append(" (" + this.response.getNumber() + ")");
                    }
                }
            }
        }
        return buffer.toString();
    }
}

