/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.client;

import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.client.Connection;
import org.koiroha.jive2ch.client.OfflineException;
import org.koiroha.jive2ch.client.UserAgentEvent;
import org.koiroha.jive2ch.client.UserAgentListener;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.XML;
import org.koiroha.xml.parser.HTMLDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class UserAgent {
    private static final Logger logger = Logger.getLogger(UserAgent.class.getName());
    public static final String DEFAULT_USER_AGENT = "Monazilla/1.00 (Jive2ch/" + Jive2ch.APP_VER + "_" + Jive2ch.APP_SUBVER + ")";
    private static final String HTTP_DATE_FORMAT = "EEE',' dd MMM yyyy HH:mm:ss 'GMT'";
    private static final UserAgent USER_AGENT = new UserAgent();
    private String userAgent = DEFAULT_USER_AGENT;
    private int connectionTimeout = 5000;
    private int readTimeout = 30000;
    private Proxy proxy = null;
    private final Map<InetAddress, Long[]> timeDiff = Collections.synchronizedMap(new HashMap());
    private volatile int transmitCount = 0;
    private volatile int receiveCount = 0;
    private final List<UserAgentListener> listener = new ArrayList<UserAgentListener>();

    private UserAgent() {
    }

    public static UserAgent getDefault() {
        return USER_AGENT;
    }

    public int getTransmitCount() {
        return this.transmitCount;
    }

    public int getReceiveCount() {
        return this.receiveCount;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public void setProxy(String host, int port) {
        logger.finer("setProxy(" + host + "," + port + ")");
        this.proxy = host == null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)) : null;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Connection open(URL url) throws IOException {
        if (Config.getDefault().isOfflineMode()) {
            throw new OfflineException();
        }
        URLConnection con = null;
        con = this.proxy == null ? url.openConnection() : url.openConnection(this.proxy);
        con.setConnectTimeout(this.connectionTimeout);
        con.setReadTimeout(this.readTimeout);
        con.setRequestProperty("User-Agent", this.userAgent);
        con.setRequestProperty("Accept-Encoding", "gzip");
        return new Connection(this, con);
    }

    public Document submit(URI base, Node node, Map<String, String> param) throws IOException {
        logger.finer("\u30d5\u30a9\u30fc\u30e0\u30b5\u30d6\u30df\u30c3\u30c8\u306e\u5b9f\u884c: " + base);
        Element form = (Element)XML.evaluate("//form", node, XPathConstants.NODE);
        if (form == null) {
            logger.warning("\u6307\u5b9a\u3055\u308c\u305f\u30ce\u30fc\u30c9\u306b form \u8981\u7d20\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093");
            return null;
        }
        param = new HashMap<String, String>(param);
        String action = form.getAttribute("action");
        StringBuilder query = new StringBuilder();
        for (Node node2 : XML.evalList("//input", form)) {
            Element input = (Element)node2;
            String name = input.getAttribute("name");
            String value = input.getAttribute("value");
            if (query.length() > 0) {
                query.append("&");
            }
            if (param.containsKey(name)) {
                value = param.get(name);
            }
            if (value != null) {
                query.append(name).append("=").append(URLEncoder.encode(value, IO.SJIS.name()));
                logger.finest("\u30af\u30a8\u30ea\u30fc: " + name + "=" + value);
            }
            param.remove(name);
        }
        for (Map.Entry entry : param.entrySet()) {
            if (entry.getValue() == null) continue;
            query.append((String)entry.getKey());
            query.append("=");
            query.append(URLEncoder.encode((String)entry.getValue(), IO.SJIS.name()));
            logger.finest("\u30af\u30a8\u30ea\u30fc: " + (String)entry.getKey() + "=" + (String)entry.getValue() + " (\u30d1\u30e9\u30e1\u30fc\u30bf\u3067\u8ffd\u52a0)");
        }
        logger.finest("\u518d\u5b9f\u884c\u7528\u30af\u30a8\u30ea\u30fc\u6587\u5b57\u5217: " + query);
        URI uri = base.resolve(action);
        Connection connection = this.open(uri.toURL());
        connection.setRequestHeader("Referer", base.toString());
        Reader in = connection.getReader(query.toString());
        Document html = null;
        try {
            HTMLDocumentBuilderFactory factory = new HTMLDocumentBuilderFactory();
            DocumentBuilder b = factory.newDocumentBuilder();
            html = b.parse(new InputSource(in));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IllegalStateException(ex);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(html.getDocumentElement().getTextContent());
        }
        return html;
    }

    public Long getTimeDifference(String host) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            logger.finer("IP\u30a2\u30c9\u30ec\u30b9\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + host);
            return null;
        }
        Long[] array = this.timeDiff.get(addr);
        long sum = 0L;
        int count = 0;
        for (int i = 0; i < array.length && array[i] != null; ++i) {
            sum += array[i].longValue();
            ++count;
        }
        if (count == 0) {
            return null;
        }
        long diff = sum / (long)count - 500L;
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeDifference(InetAddress addr, long diff) {
        Map<InetAddress, Long[]> map = this.timeDiff;
        synchronized (map) {
            Long[] array = this.timeDiff.get(addr);
            if (array == null) {
                array = new Long[60];
                this.timeDiff.put(addr, array);
            }
            System.arraycopy(array, 0, array, 1, array.length - 1);
            array[0] = diff;
        }
    }

    public void addUserAgentListener(UserAgentListener l) {
        this.listener.add(l);
    }

    public void removeUserAgentListener(UserAgentListener l) {
        for (int i = 0; i < this.listener.size(); ++i) {
            if (l != this.listener.get(i)) continue;
            this.listener.remove(i);
        }
    }

    synchronized void addConnectionCount(boolean receive, int diff) {
        if (receive) {
            this.receiveCount += diff;
        } else {
            this.transmitCount += diff;
        }
        UserAgentEvent e = new UserAgentEvent(this);
        for (UserAgentListener l : this.listener) {
            l.connecting(e);
        }
    }

    public static DateFormat getHttpDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }
}

