/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.koiroha.jive2ch.client.Cookie;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class SessionManager
extends CookieHandler {
    private static final Logger logger = Logger.getLogger(SessionManager.class.getName());
    private final File file;
    private List<Cookie> cookies = null;

    public SessionManager(File file) {
        this.file = file;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        logger.finer("Cookie\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u307e\u3059");
        ArrayList<String> cookie = new ArrayList<String>();
        for (Cookie c : this.getCookie(uri)) {
            cookie.add(c.getName() + "=" + c.getValue());
            logger.finest("Cookie\u304c\u9001\u4fe1\u3055\u308c\u307e\u3059: " + c.getName() + "=" + c.getValue());
        }
        if (cookie.size() == 0) {
            return requestHeaders;
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(requestHeaders);
        List<String> field = null;
        for (Map.Entry e : headers.entrySet()) {
            if (!((String)e.getKey()).equalsIgnoreCase("Cookie")) continue;
            field = (List)e.getValue();
            break;
        }
        if (field == null) {
            field = new ArrayList<String>();
            headers.put("Cookie", field);
        }
        field.addAll(cookie);
        logger.finest(uri + ": " + headers);
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        logger.finer("Cookie\u3092\u4fdd\u5b58\u3057\u3066\u3044\u307e\u3059");
        logger.finest(uri + ": " + responseHeaders);
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        for (Map.Entry<String, List<String>> e : responseHeaders.entrySet()) {
            String name = e.getKey();
            if (name == null || !name.equalsIgnoreCase("Set-Cookie") && !name.equalsIgnoreCase("Set-Cookie2")) continue;
            for (String h : e.getValue()) {
                logger.finest(name + ": " + h);
                list.addAll(Cookie.parse(h, uri));
            }
        }
        if (list.size() > 0) {
            List<Cookie> list2 = this.cookies;
            synchronized (list2) {
                for (Cookie c : list) {
                    this.addCookie(c);
                }
                this.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<Cookie> getCookie(URI uri) throws IOException {
        if (this.cookies == null) {
            this.load();
        }
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        List<Cookie> list2 = this.cookies;
        synchronized (list2) {
            for (Cookie c : this.cookies) {
                if (!c.matches(uri)) continue;
                list.add(c);
            }
        }
        return list;
    }

    private void addCookie(Cookie cookie) {
        assert (Thread.holdsLock(this.cookies));
        for (int i = 0; i < this.cookies.size(); ++i) {
            Cookie c = this.cookies.get(i);
            if (!c.isExpired() && !c.canOverride(cookie)) continue;
            this.cookies.remove(i);
            --i;
            logger.finest("Cookie\u3092\u524a\u9664\u3057\u307e\u3057\u305f: " + c);
        }
        if (!cookie.isExpired()) {
            this.cookies.add(cookie);
            logger.finest("Cookie\u304c\u8ffd\u52a0\u3055\u308c\u307e\u3057\u305f: " + cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void load() throws IOException {
        this.cookies = new ArrayList<Cookie>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(this.file));
            while ((line = in.readLine()) != null) {
                this.cookies.addAll(Cookie.parse(line, null));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IO.close(in);
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        logger.finer("Cookie\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f: " + this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        assert (Thread.holdsLock(this.cookies));
        PrintWriter out = null;
        try {
            IO.mkdir(this.file.getParentFile());
            out = new PrintWriter(new RollbackOutputStream(this.file));
            for (Cookie c : this.cookies) {
                if (c.isSession() || c.isExpired()) continue;
                out.println(c.getCooieString());
            }
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
        logger.finer("Cookie\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + this.cookies.size() + "\u500b");
    }
}

