/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.client;

import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Cookie
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Cookie.class.getName());
    private static final String DATE_FORMAT = "EEEE',' dd-MMM-yyyy HH:mm:ss 'GMT'";
    private static final Pattern[] NAMEVALUE = new Pattern[]{Pattern.compile("([^;,\\s]*)\\s*=\\s*\"([^\"]*)\"\\s*;?"), Pattern.compile("([^;,\\s]*)\\s*=\\s*([^;]*)\\s*;?"), Pattern.compile("([^;,\\s]*)\\s*;?")};
    private String name = null;
    private String value = null;
    private String domain = null;
    private String path = null;
    private boolean secure = false;
    private Long maxAge = null;
    private long created = System.currentTimeMillis();

    private Cookie(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.setAttribute(e.getKey(), e.getValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    private String getDomain() {
        return this.domain;
    }

    private void setDomain(String domain) {
        this.domain = domain.toLowerCase();
    }

    public boolean isExpired() {
        if (this.maxAge == null) {
            return false;
        }
        return System.currentTimeMillis() >= this.maxAge + this.created;
    }

    public boolean isSession() {
        return this.maxAge == null;
    }

    public boolean matches(URI uri) {
        if (this.secure && uri.getScheme().equalsIgnoreCase("https")) {
            return false;
        }
        String host = uri.getHost().toLowerCase();
        if (this.domain.startsWith(".") && !host.endsWith(this.domain)) {
            return false;
        }
        if (!this.domain.startsWith(".") && !this.domain.equals(host)) {
            return false;
        }
        return this.path == null || uri.getPath().startsWith(this.path);
    }

    public boolean canOverride(Cookie other) {
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!this.getDomain().equals(other.getDomain())) {
            return false;
        }
        return this.path == null || this.path.equals(other.path);
    }

    public String getCooieString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name + "=" + this.value);
        if (this.domain != null) {
            buffer.append(";Domain=" + this.domain);
        }
        if (this.path != null) {
            buffer.append(";Path=" + this.path);
        }
        if (this.secure) {
            buffer.append(";Secure");
        }
        if (this.maxAge != null) {
            Date date = new Date(this.created + this.maxAge);
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            buffer.append(";Expires=" + df.format(date));
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getCooieString();
    }

    public static List<Cookie> parse(String cookies, URI uri) {
        StringBuilder buffer;
        Cookie c;
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        String cookie = cookies.trim();
        while (cookie.length() > 0 && (c = Cookie.parseNext(cookie, buffer = new StringBuilder())) != null) {
            if (c.getDomain() == null) {
                c.setDomain(uri.getHost());
            }
            list.add(c);
            cookie = buffer.toString();
        }
        return list;
    }

    private static Cookie parseNext(String cookie, StringBuilder buffer) {
        Cookie c;
        cookie = cookie.trim();
        HashMap<String, String> map = new HashMap<String, String>();
        while (cookie.length() > 0) {
            Matcher m = Cookie.matcher(cookie);
            if (m == null || m.start() == m.end()) {
                logger.finer("\u30d1\u30bf\u30fc\u30f3\u4e00\u81f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + cookie);
                break;
            }
            cookie = cookie.substring(m.end()).trim();
            String name = m.group(1);
            String value = null;
            if (m.groupCount() >= 2) {
                value = m.group(2);
            }
            map.put(name, value);
        }
        if ((c = new Cookie(map)).getName() == null) {
            logger.fine("\u540d\u524d\u306e\u306a\u3044 Cookie \u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            return null;
        }
        buffer.append(cookie);
        return c;
    }

    private static Matcher matcher(String cookie) {
        for (Pattern p : NAMEVALUE) {
            Matcher m = p.matcher(cookie);
            if (!m.lookingAt()) continue;
            return m;
        }
        return null;
    }

    private void setAttribute(String name, String value) {
        if (name.equalsIgnoreCase("domain")) {
            this.domain = value;
            return;
        }
        if (name.equalsIgnoreCase("max-age")) {
            try {
                this.maxAge = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                logger.fine("Max-Age\u5024\u304c\u4e0d\u6b63\u3067\u3059: " + value);
            }
            return;
        }
        if (name.equalsIgnoreCase("path")) {
            this.path = value;
            return;
        }
        if (name.equalsIgnoreCase("secure")) {
            this.secure = true;
            return;
        }
        if (name.equalsIgnoreCase("expires")) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date date = df.parse(value);
                this.maxAge = date.getTime() - this.created;
            }
            catch (ParseException ex) {
                logger.fine("Expires\u5024\u304c\u4e0d\u6b63: " + value + "; " + ex.getMessage());
                this.maxAge = -1L;
            }
            return;
        }
        if (name.equalsIgnoreCase("version") || name.equalsIgnoreCase("comment") || name.equalsIgnoreCase("commenturl") || name.equalsIgnoreCase("discared") || name.startsWith("$")) {
            logger.finer("Cookie\u5c5e\u6027\u3092\u7121\u8996: " + name + "=" + value);
            return;
        }
        if (this.name != null) {
            logger.warning("\u540c\u4e00 Cookie \u5185\u306b\u8907\u6570\u306e\u5b9a\u7fa9\u3092\u691c\u51fa\u3057\u307e\u3057\u305f: " + this.name + " -> " + name);
        }
        this.name = name;
        this.value = value;
    }
}

