/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.koiroha.jive2ch.client.AboneException;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.ProgressListener;
import org.koiroha.jive2ch.util.ProgressSupport;
import org.koiroha.jive2ch.util.RollbackOutputStream;
import org.koiroha.jive2ch.util.TeeInputStream;
import org.koiroha.xml.Xml;

public class Connection {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private final UserAgent userAgent;
    private final URLConnection con;
    private long entityLength = -1L;
    private long responseLength = -1L;
    private Charset defaultCharset = IO.SJIS;
    private boolean connecting = false;
    private final ProgressSupport listener = new ProgressSupport(this);

    Connection(UserAgent ua, URLConnection con) {
        this.userAgent = ua;
        this.con = con;
    }

    protected void finalize() throws Throwable {
        if (this.connecting) {
            this.disconnect();
        }
        super.finalize();
    }

    public void setDefaultCharset(Charset defaultCharset) {
        assert (defaultCharset != null);
        this.defaultCharset = defaultCharset;
    }

    public void setRequestHeader(String name, String value) {
        this.con.setRequestProperty(name, value);
        logger.finest(name + ": " + value);
    }

    public void setDateRequestHeader(String name, Date value) {
        String date = UserAgent.getHttpDateFormat().format(value);
        this.con.setRequestProperty(name, date);
        logger.finest(name + ": " + date);
    }

    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    public Date getDateResponseHeader(String name) {
        long date = this.con.getHeaderFieldDate(name, -1L);
        if (date >= 0L) {
            return new Date(date);
        }
        return null;
    }

    public void disconnect() {
        if (this.connecting) {
            if (this.con instanceof HttpURLConnection) {
                ((HttpURLConnection)this.con).disconnect();
            }
            this.userAgent.addConnectionCount(true, -1);
            this.connecting = false;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(null);
    }

    public InputStream getInputStream(String query) throws IOException {
        if (query == null) {
            this.doRequest(false, null);
        } else {
            this.doRequest(true, query);
        }
        return this.getInputStream0(0L);
    }

    public Reader getReader() throws IOException {
        return this.getReader(null);
    }

    public Reader getReader(String query) throws IOException {
        InputStream in = this.getInputStream(query);
        Charset charset = Xml.getCharset(this.con.getContentType());
        if (charset == null) {
            charset = this.defaultCharset;
        }
        return new InputStreamReader(in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getDatInputStream(File file) throws IOException {
        this.doRequest(false, null);
        int code = 200;
        if (this.con instanceof HttpURLConnection) {
            code = ((HttpURLConnection)this.con).getResponseCode();
        }
        logger.finest("\u30ec\u30b9\u30dd\u30f3\u30b9\u30b3\u30fc\u30c9: " + code);
        if (code == 304) {
            logger.finer("\u30ed\u30fc\u30ab\u30eb\u30c7\u30fc\u30bf\u306f\u6700\u65b0\u306e\u3088\u3046\u3067\u3059: " + file.getName());
            this.disconnect();
            return new ByteArrayInputStream(new byte[0]);
        }
        if (code == 416) {
            logger.finer("\u30b9\u30ec\u30c3\u30c9\u306b\u3042\u307c\u30fc\u3093\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u3088\u3046\u3067\u3059: " + file.getName());
            this.disconnect();
            throw new AboneException();
        }
        if (code >= 300) {
            this.con.getInputStream();
            this.disconnect();
            throw new IOException(this.con.getHeaderField(null));
        }
        boolean partial = code == 206;
        long position = 0L;
        if (partial) {
            logger.finer("\u5dee\u5206\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9: " + file.getName());
            position = file.length();
        } else {
            logger.finer("\u5168\u30b5\u30a4\u30ba\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9: " + file.getName());
            position = 0L;
        }
        boolean success = false;
        RollbackOutputStream out = null;
        InputStream in = this.getInputStream0(position);
        try {
            int ch;
            if (partial && (ch = in.read()) != 10) {
                this.disconnect();
                throw new AboneException();
            }
            out = new RollbackOutputStream(file, partial);
            return new TeeInputStream(in, out);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IO.close(out);
            IO.close(in);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(boolean post, String query) throws IOException {
        Date date;
        byte[] binary = null;
        if (post) {
            binary = query.getBytes(IO.UTF8.name());
            this.con.setDoOutput(true);
            this.con.setDoInput(true);
            this.con.setUseCaches(false);
            this.con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.con.setRequestProperty("Content-Length", String.valueOf(binary.length));
        } else {
            this.con.setUseCaches(true);
            this.con.setDoOutput(false);
            this.con.setDoInput(true);
        }
        logger.finer((post ? "POST" : "GET") + " " + this.con.getURL().getFile() + " HTTP/1.1");
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.con.getRequestProperties().toString());
        }
        logger.finer("\u63a5\u7d9a\u3057\u3066\u3044\u307e\u3059...: " + this.con.getURL());
        this.userAgent.addConnectionCount(false, 1);
        try {
            this.con.connect();
        }
        finally {
            this.userAgent.addConnectionCount(false, -1);
        }
        this.connecting = true;
        this.userAgent.addConnectionCount(true, 1);
        if (post) {
            OutputStream os = this.con.getOutputStream();
            if (binary != null) {
                os.write(binary);
            }
            os.flush();
        }
        long start = System.currentTimeMillis();
        logger.finer(this.con.getHeaderField(null));
        long end = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.con.getHeaderFields().toString());
        }
        if (this.con.getHeaderField("Content-Range") != null) {
            Pattern p = Pattern.compile("bytes\\s+(\\d+)-(\\d+)/(\\d+)", 2);
            Matcher m = p.matcher(this.con.getHeaderField("Content-Range").trim());
            if (m.matches()) {
                try {
                    long t;
                    long p1 = Long.parseLong(m.group(1));
                    long p2 = Long.parseLong(m.group(2));
                    this.entityLength = t = Long.parseLong(m.group(3));
                    this.responseLength = p2 - p1;
                    logger.finer("Content-Range: bytes " + p1 + "-" + p2 + "/" + t);
                }
                catch (NumberFormatException ex) {}
            }
        } else if (this.con.getHeaderField("Content-Length") != null) {
            try {
                this.responseLength = this.entityLength = Long.valueOf(this.con.getHeaderField("Content-Length")).longValue();
                logger.finer("Content-Length: " + this.entityLength);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (this.responseLength < 0L && this.entityLength < 0L) {
            logger.finer("\u30ec\u30b9\u30dd\u30f3\u30b9\u30c7\u30fc\u30bf\u9577\u306f\u4e0d\u660e\u3067\u3059");
        } else {
            logger.finer("\u5168\u30c7\u30fc\u30bf\u9577: " + this.nf.format(this.entityLength));
            logger.finer("\u30ec\u30b9\u30dd\u30f3\u30b9\u30c7\u30fc\u30bf\u9577: " + this.nf.format(this.responseLength));
        }
        if (end - start < 1000L && (date = this.getDateResponseHeader("Date")) != null) {
            date = new Date(date.getTime() + 500L);
            String host = this.con.getURL().getHost();
            long local = start + (end - start) / 2L;
            long diff = date.getTime() - local;
            try {
                InetAddress addr = InetAddress.getByName(host);
                this.userAgent.setTimeDifference(addr, diff);
            }
            catch (UnknownHostException ex) {
                logger.fine("\u30db\u30b9\u30c8\u540d\u304c\u4e0d\u660e\u3067\u3059: " + host);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss.SSS");
            logger.finer("\u30b5\u30fc\u30d0\u4e88\u60f3\u6642\u523b  : " + df.format(new Date(local + this.userAgent.getTimeDifference(host))));
            logger.finer("\u30b5\u30fc\u30d0\u57fa\u6e96\u6642\u523b  : " + df.format(date));
            logger.finer("\u30ed\u30fc\u30ab\u30eb\u57fa\u6e96\u6642\u523b: " + df.format(new Date(local)));
            logger.finer("\u30ed\u30fc\u30ab\u30eb\u57fa\u6e96\u5e45: " + (end - start) + "ms");
            logger.finer("\u30b5\u30fc\u30d0\u6642\u5dee\u8a2d\u5b9a: " + host + ": " + diff);
        }
    }

    private InputStream getInputStream0(long current) throws IOException {
        HttpURLConnection hcon;
        if (this.con instanceof HttpURLConnection && (hcon = (HttpURLConnection)this.con).getResponseCode() != 206) {
            current = 0L;
        }
        InputStream in = this.con.getInputStream();
        in = this.listener.wrap(in, this.entityLength, current);
        if (this.isGZIPCompressed()) {
            in = new GZIPInputStream(in);
        }
        in = new FilterInputStream(in){

            @Override
            public void close() throws IOException {
                super.close();
                Connection.this.disconnect();
            }
        };
        return in;
    }

    private boolean isGZIPCompressed() {
        String ce = this.con.getHeaderField("Content-Encoding");
        return ce != null && (ce.equalsIgnoreCase("gzip") || ce.equalsIgnoreCase("x-gzip"));
    }

    public void addProgressListener(ProgressListener l) {
        this.listener.addProgressListener(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listener.removeProgressListener(l);
    }
}

