/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.J2Bean;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.NGWord;
import org.koiroha.jive2ch.util.Performance;
import org.koiroha.jive2ch.util.Pointer;
import org.koiroha.jive2ch.util.TeeInputStream;

public class Thread
extends J2Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Thread.class.getName());
    private final Board board;
    private final String fileName;
    private final Date created;
    private String title = "";
    private List<Response> res = null;
    private int number = 0;
    private boolean recent = false;
    private final File localFile;

    public Thread(Board board, String fileName, String title, int res, Date created) throws IOException {
        this.board = board;
        this.fileName = fileName;
        this.title = title;
        this.created = created;
        this.localFile = new File(board.getDirectory(), fileName);
        this.setMetaFile(new File(this.getBoard().getDirectory(), "." + this.getFileName()));
        this.setResponseCount(res);
    }

    public Board getBoard() {
        return this.board;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        assert (title != null);
        String oldValue = this.title;
        String newValue = title;
        this.title = title;
        this.firePropertyChange("title", oldValue, newValue);
    }

    public int getResponseCount() {
        return this.getMetaInfo("responseCount", 0);
    }

    public void setResponseCount(int responseCount) {
        Integer oldValue = this.getResponseCount();
        Integer newValue = responseCount;
        this.setMetaInfo("responseCount", responseCount);
        this.firePropertyChange("responseCount", oldValue, newValue);
    }

    public int getAcquiredCount() {
        return this.getMetaInfo("aquiredCount", 0);
    }

    private void setAcquiredCount(int acquiredCount) {
        Integer oldValue = this.getAcquiredCount();
        Integer newValue = acquiredCount;
        this.setMetaInfo("aquiredCount", String.valueOf(acquiredCount));
        this.firePropertyChange("acquiredCount", oldValue, newValue);
    }

    public Date getContributeDate() {
        return this.getMetaInfo("contributeDate", null);
    }

    public void setContributeDate(Date contDate) {
        Date oldValue = this.getContributeDate();
        Date newValue = contDate;
        this.setMetaInfo("contributeDate", contDate);
        this.firePropertyChange("contributeDate", oldValue, newValue);
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getRecentAccess() {
        return this.getMetaInfo("header.date", null);
    }

    public void setRecentAccess(Date date) {
        Date oldValue = this.getRecentAccess();
        Date newValue = date;
        this.setMetaInfo("header.date", date);
        this.firePropertyChange("recentAccess", oldValue, newValue);
    }

    public Date getLastModified() {
        return this.getMetaInfo("header.last-modified", null);
    }

    public void setLastModified(Date date) {
        Date oldValue = this.getLastModified();
        Date newValue = date;
        this.setMetaInfo("header.last-modified", date);
        this.firePropertyChange("lastModified", oldValue, newValue);
    }

    public String getETag() {
        return this.getMetaInfo("header.etag");
    }

    public void setETag(String etag) {
        String oldValue = this.getETag();
        String newValue = etag;
        this.setMetaInfo("header.etag", etag);
        this.firePropertyChange("ETag", oldValue, newValue);
    }

    public double getEnergy() {
        Date c = this.getCreated();
        if (c == null || this.isArchived()) {
            return Double.NaN;
        }
        long span = System.currentTimeMillis() - c.getTime();
        if (span <= 0L) {
            return Double.NaN;
        }
        return (double)this.getResponseCount() / (double)span * 24.0 * 60.0 * 60.0 * 1000.0;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        Integer oldValue = this.number;
        Integer newValue = number;
        this.number = number;
        this.firePropertyChange("number", oldValue, newValue);
    }

    public boolean isNew() {
        return this.recent && !this.isArchived();
    }

    public void setNew(boolean recent) {
        Boolean oldValue = this.recent;
        Boolean newValue = recent;
        this.recent = recent;
        this.firePropertyChange("new", oldValue, newValue);
    }

    public boolean isKidoku() {
        if (this.isArchived()) {
            return true;
        }
        File file = this.getLocalFile();
        return file.isFile() && file.length() > 0L;
    }

    public boolean isShinchaku() {
        return this.isKidoku() && this.getResponseCount() > this.getAcquiredCount();
    }

    public boolean isArchived() {
        File archive = this.getArchiveFile();
        File local = this.getLocalFile();
        return (!local.isFile() || local.length() == 0L) && archive.isFile();
    }

    public void setArchived(boolean archived) throws IOException {
        boolean oldValue = this.isArchived();
        boolean newValue = archived;
        File archive = this.getArchiveFile();
        File local = this.getLocalFile();
        if (!oldValue && newValue) {
            IO.compress(local, archive);
            IO.delete(local);
        } else if (oldValue && !newValue) {
            IO.decompress(archive, local);
            IO.delete(archive);
        }
        this.firePropertyChange("archived", oldValue, newValue);
    }

    public File getLocalFile() {
        return this.localFile;
    }

    private File getArchiveFile() {
        File file = this.getLocalFile();
        return new File(file.getParentFile(), file.getName() + ".gz");
    }

    public File getEntityFile() {
        if (this.isArchived()) {
            return this.getArchiveFile();
        }
        return this.getLocalFile();
    }

    public BufferedReader getReader() throws IOException {
        InputStream in = null;
        try {
            File file = this.getLocalFile();
            in = new FileInputStream(file);
            logger.finest("\u8aad\u307f\u8fbc\u307f\u7528\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u30aa\u30fc\u30d7\u30f3: " + file.length());
        }
        catch (FileNotFoundException ex) {
            try {
                File file = this.getArchiveFile();
                in = new GZIPInputStream(new FileInputStream(file));
                logger.finest("\u8aad\u307f\u8fbc\u307f\u7528\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u30aa\u30fc\u30d7\u30f3: " + file.length() + " (GZIP)");
            }
            catch (FileNotFoundException ex2) {
                throw ex;
            }
        }
        return new BufferedReader(new InputStreamReader(in, IO.SJIS));
    }

    public synchronized void deleteLocalCache() {
        logger.fine("\u30ed\u30fc\u30ab\u30eb\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059");
        boolean oldValue = this.isKidoku();
        this.setAcquiredCount(0);
        this.clearMetaInfo();
        try {
            IO.delete(this.getLocalFile());
        }
        catch (IOException ex) {
            logger.warning("\u30ed\u30fc\u30ab\u30eb\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.getLocalFile().getName());
        }
        try {
            IO.delete(this.getArchiveFile());
        }
        catch (IOException ex) {
            logger.warning("\u30a2\u30fc\u30ab\u30a4\u30d6\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.getArchiveFile().getName());
        }
        try {
            this.deleteMetaFile();
        }
        catch (IOException ex) {
            logger.warning("\u30e1\u30bf\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.getMetaFile().getName());
        }
        logger.fine("\u30ed\u30fc\u30ab\u30eb\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u524a\u9664\u3057\u307e\u3057\u305f");
        this.firePropertyChange("kidoku", oldValue, false);
    }

    public synchronized void flush() throws IOException {
        this.res = null;
        this.saveMetaInfo();
    }

    public synchronized List<Response> getResponse() {
        assert (this.isCharged()) : "thread not charged!";
        return new ArrayList<Response>(this.res);
    }

    public synchronized void addResponses(List<Response> list) {
        if (this.res == null) {
            this.res = new ArrayList<Response>();
        }
        int size = this.res.size();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setNumber(size + i + 1);
            this.setNGStatus(list.get(i));
        }
        this.res.addAll(list);
        if (this.getAcquiredCount() < this.res.size()) {
            this.setAcquiredCount(this.res.size());
        }
        if (this.getResponseCount() < this.res.size()) {
            this.setResponseCount(this.res.size());
        }
        if (this.res.size() == list.size() && this.res.size() > 0) {
            this.setTitle(this.res.get(0).getTitle());
        }
        for (Response res : this.getLocalNG().pickup(list)) {
            res.setNG(true);
        }
    }

    public synchronized void chargeTitle() throws IOException {
        if (this.title == null) {
            this.charge(1);
            this.uncharge();
        }
    }

    public synchronized void charge() throws IOException {
        this.charge(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void charge(int count) throws IOException {
        assert (count > 0);
        Performance pfm = Performance.start();
        logger.finer("charge(): \u30ed\u30fc\u30ab\u30eb\u306e\u30b9\u30ec\u30c3\u30c9\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059...: " + this.getFileName());
        ArrayList<Response> list = new ArrayList<Response>();
        BufferedReader in = null;
        try {
            in = this.getReader();
            for (int i = 0; i < count; ++i) {
                IO.checkCancel();
                String line = in.readLine();
                if (line == null) break;
                Response res = Response.parse(line);
                res.setNumber(i + 1);
                if (i == 0 && (res.getTitle() == null || this.getTitle() == null)) {
                    if (res.getTitle() != null) {
                        this.setTitle(res.getTitle());
                    } else if (this.getTitle() != null) {
                        res.setTitle(this.getTitle());
                    } else {
                        this.setTitle("\u4e0d\u660e");
                        res.setTitle("\u4e0d\u660e");
                    }
                }
                list.add(res);
            }
            if (this.getTitle() == null) {
                this.setTitle("\u4e0d\u660e");
            }
        }
        catch (FileNotFoundException ex) {
        }
        finally {
            IO.close(in);
        }
        this.res = null;
        this.addResponses(list);
        pfm.mark("\u30ed\u30fc\u30ab\u30eb\u306e\u30b9\u30ec\u30c3\u30c9\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f: " + this.getFileName() + ": " + list.size() + " \u30ec\u30b9");
    }

    public synchronized void uncharge() {
        this.res = null;
        logger.finer("uncharge(): \u30ad\u30e3\u30c3\u30b7\u30e5\u3055\u308c\u3066\u3044\u308b\u30b9\u30ec\u30c3\u30c9\u30c7\u30fc\u30bf\u3092\u7834\u68c4\u3057\u307e\u3057\u305f");
    }

    public boolean isCharged() {
        return this.res != null;
    }

    public synchronized void clearAllNew() {
        if (this.res != null) {
            for (Response r : this.res) {
                r.setNew(false);
            }
        }
    }

    public Pointer getLocalNG() {
        String ng = this.getMetaInfo("localNG");
        if (ng == null || ng.length() == 0) {
            return Pointer.EMPTY;
        }
        return Pointer.compile(ng);
    }

    public void setLocalNG(Pointer ng) {
        this.setMetaInfo("localNG", ng.toPattern());
        if (this.res != null) {
            int total = this.getResponseCount();
            for (Response r : this.res) {
                if (ng.contains(total, r.getNumber())) {
                    r.setNG(true);
                    continue;
                }
                r.setNG(false);
            }
        }
    }

    public boolean sameAs(Thread other) {
        return this.getFileName().equals(other.getFileName()) && this.getBoard().sameAs(other.getBoard());
    }

    public URI getBrowserURI() {
        return this.getBoard().getService().getBrowserURI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List<Response> quicklook(Thread t, Pointer p) throws IOException {
        block5: {
            block4: {
                is = null;
                os = null;
                try {
                    board = t.getBoard();
                    app = board.getCategory().getJive2ch();
                    fileName = t.getFileName();
                    dir = app.repository.getBoardDirectory(board.getURI());
                    file = new File(dir, fileName);
                    if (!file.isFile() || file.length() <= 0L) ** GOTO lbl25
                    is = new FileInputStream(file);
                    list = Thread.readTopResponse(is, p);
                    if (list == null) break block4;
                    Thread.logger.finer("\u30ed\u30fc\u30ab\u30eb\u30ea\u30dd\u30b8\u30c8\u30ea\u304b\u3089\u30af\u30a4\u30c3\u30af\u30eb\u30c3\u30af: " + file);
                    var10_10 = list;
                }
                catch (Throwable var15_16) {
                    IO.close(is);
                    IO.close(os);
                    throw var15_16;
                }
                IO.close(is);
                IO.close(os);
                return var10_10;
            }
            is.close();
lbl25:
            // 2 sources

            base = board.getURI();
            uri = base.resolve(base.getPath() + "/dat/" + fileName);
            ua = UserAgent.getDefault();
            con = ua.open(uri.toURL());
            is = con.getInputStream();
            IO.mkdir(file.getParentFile());
            os = new FileOutputStream(file);
            is = new TeeInputStream(is, os);
            list = Thread.readTopResponse(is, p);
            if (list == null) break block5;
            Thread.logger.finer("\u30ea\u30e2\u30fc\u30c8\u304b\u3089\u30af\u30a4\u30c3\u30af\u30eb\u30c3\u30af: " + uri);
            var14_15 = list;
            IO.close(is);
            IO.close(os);
            return var14_15;
        }
        is.close();
        os.close();
        Thread.logger.finer("\u30af\u30a4\u30c3\u30af\u30eb\u30c3\u30af\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        IO.close(is);
        IO.close(os);
        return null;
    }

    private void setNGStatus(Response res) {
        Config config = Config.getDefault();
        for (NGWord n : config.getNGWords()) {
            if (!n.isNG(res)) continue;
            res.setNG(true);
            return;
        }
        res.setNG(false);
    }

    private static List<Response> readTopResponse(InputStream is, Pointer p) throws IOException {
        String line;
        String title = null;
        ArrayList<Response> list = new ArrayList<Response>();
        BufferedReader in = new BufferedReader(new InputStreamReader(is, IO.SJIS));
        int i = 0;
        while ((line = in.readLine()) != null) {
            Response res = Response.parse(line);
            if (i == 0 && res.isDamepo()) break;
            res.setNumber(i + 1);
            list.add(res);
            if (i == 0 && res.getTitle() != null) {
                title = res.getTitle();
            }
            ++i;
        }
        ArrayList<Response> f = new ArrayList<Response>();
        p.newSelector(list.size()).pickup(list, f);
        if (f.size() == 0) {
            return null;
        }
        ((Response)f.get(0)).setTitle(title);
        return f;
    }

    public String toString() {
        return this.title + " (" + this.getResponseCount() + ")";
    }
}

